/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.File;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.zip.ZipSplitReadOnlySeekableByteChannel;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ZipSplitReadOnlySeekableByteChannelTest {
    @Test
    public void buildFromLastSplitSegmentThrowsOnNotZipFile() throws IOException {
        File lastFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        Assertions.assertThrows(IllegalArgumentException.class, () -> ZipSplitReadOnlySeekableByteChannel.buildFromLastSplitSegment((File)lastFile));
    }

    @Test
    public void channelsPositionIsZeroAfterConstructor() throws IOException {
        List<SeekableByteChannel> channels = this.getSplitZipChannels();
        new ZipSplitReadOnlySeekableByteChannel(channels);
        for (SeekableByteChannel channel : channels) {
            Assertions.assertEquals((long)0L, (long)channel.position());
        }
    }

    @Test
    public void constructorThrowsOnNonSplitZipFiles() throws IOException {
        ArrayList<SeekableByteChannel> channels = new ArrayList<SeekableByteChannel>();
        File file = AbstractTestCase.getFile("COMPRESS-189.zip");
        channels.add(Files.newByteChannel(file.toPath(), StandardOpenOption.READ));
        Assertions.assertThrows(IOException.class, () -> new ZipSplitReadOnlySeekableByteChannel(channels));
    }

    @Test
    public void constructorThrowsOnNullArg() {
        Assertions.assertThrows(NullPointerException.class, () -> new ZipSplitReadOnlySeekableByteChannel(null));
    }

    @Test
    public void forFilesOfTwoParametersThrowsOnNullArg() {
        Assertions.assertThrows(NullPointerException.class, () -> ZipSplitReadOnlySeekableByteChannel.forFiles(null, null));
    }

    @Test
    public void forFilesReturnCorrectClass() throws IOException {
        File firstFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        File secondFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z02");
        File lastFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        ArrayList<File> list = new ArrayList<File>();
        list.add(firstFile);
        list.add(secondFile);
        SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.forFiles((File)lastFile, list);
        Assertions.assertTrue((boolean)(channel instanceof ZipSplitReadOnlySeekableByteChannel));
        channel = ZipSplitReadOnlySeekableByteChannel.forFiles((File[])new File[]{firstFile, secondFile, lastFile});
        Assertions.assertTrue((boolean)(channel instanceof ZipSplitReadOnlySeekableByteChannel));
    }

    @Test
    public void forFilesThrowsOnNullArg() {
        Assertions.assertThrows(NullPointerException.class, () -> ZipSplitReadOnlySeekableByteChannel.forFiles(null));
    }

    @Test
    public void forOrderedSeekableByteChannelsOfTwoParametersThrowsOnNullArg() {
        Assertions.assertThrows(NullPointerException.class, () -> ZipSplitReadOnlySeekableByteChannel.forOrderedSeekableByteChannels(null, null));
    }

    @Test
    public void forOrderedSeekableByteChannelsReturnCorrectClass() throws IOException {
        File file1 = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        SeekableByteChannel firstChannel = Files.newByteChannel(file1.toPath(), StandardOpenOption.READ);
        File file2 = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z02");
        SeekableByteChannel secondChannel = Files.newByteChannel(file2.toPath(), StandardOpenOption.READ);
        File lastFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.zip");
        SeekableByteChannel lastChannel = Files.newByteChannel(lastFile.toPath(), StandardOpenOption.READ);
        ArrayList<SeekableByteChannel> channels = new ArrayList<SeekableByteChannel>();
        channels.add(firstChannel);
        channels.add(secondChannel);
        SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.forOrderedSeekableByteChannels((SeekableByteChannel)lastChannel, channels);
        Assertions.assertTrue((boolean)(channel instanceof ZipSplitReadOnlySeekableByteChannel));
        channel = ZipSplitReadOnlySeekableByteChannel.forOrderedSeekableByteChannels((SeekableByteChannel[])new SeekableByteChannel[]{firstChannel, secondChannel, lastChannel});
        Assertions.assertTrue((boolean)(channel instanceof ZipSplitReadOnlySeekableByteChannel));
    }

    @Test
    public void forOrderedSeekableByteChannelsReturnsIdentityForSingleElement() throws IOException {
        SeekableInMemoryByteChannel emptyChannel = new SeekableInMemoryByteChannel(ByteUtils.EMPTY_BYTE_ARRAY);
        SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.forOrderedSeekableByteChannels((SeekableByteChannel[])new SeekableByteChannel[]{emptyChannel});
        Assertions.assertSame((Object)emptyChannel, (Object)channel);
    }

    @Test
    public void forOrderedSeekableByteChannelsThrowsOnNullArg() {
        Assertions.assertThrows(NullPointerException.class, () -> ZipSplitReadOnlySeekableByteChannel.forOrderedSeekableByteChannels(null));
    }

    @Test
    public void forPathsOfTwoParametersThrowsOnNullArg() {
        Assertions.assertThrows(NullPointerException.class, () -> ZipSplitReadOnlySeekableByteChannel.forPaths(null, null));
    }

    @Test
    public void forPathsReturnCorrectClass() throws IOException {
        Path firstFile = AbstractTestCase.getPath("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        Path secondFile = AbstractTestCase.getPath("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z02");
        Path lastFile = AbstractTestCase.getPath("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.zip");
        ArrayList<Path> list = new ArrayList<Path>();
        list.add(firstFile);
        list.add(secondFile);
        SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.forPaths((Path)lastFile, list);
        Assertions.assertTrue((boolean)(channel instanceof ZipSplitReadOnlySeekableByteChannel));
        channel = ZipSplitReadOnlySeekableByteChannel.forPaths((Path[])new Path[]{firstFile, secondFile, lastFile});
        Assertions.assertTrue((boolean)(channel instanceof ZipSplitReadOnlySeekableByteChannel));
    }

    @Test
    public void forPathsThrowsOnNullArg() {
        Assertions.assertThrows(NullPointerException.class, () -> ZipSplitReadOnlySeekableByteChannel.forPaths(null));
    }

    private List<SeekableByteChannel> getSplitZipChannels() throws IOException {
        ArrayList<SeekableByteChannel> channels = new ArrayList<SeekableByteChannel>();
        File file1 = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        channels.add(Files.newByteChannel(file1.toPath(), StandardOpenOption.READ));
        File file2 = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z02");
        channels.add(Files.newByteChannel(file2.toPath(), StandardOpenOption.READ));
        File lastFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.zip");
        channels.add(Files.newByteChannel(lastFile.toPath(), StandardOpenOption.READ));
        return channels;
    }

    @Test
    public void positionToSomeZipSplitSegment() throws IOException {
        File firstFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        int firstFileSize = (int)firstFile.length();
        File secondFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z02");
        int secondFileSize = (int)secondFile.length();
        File lastFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.zip");
        int lastFileSize = (int)lastFile.length();
        Random random = new Random();
        int randomDiskNumber = random.nextInt(3);
        int randomOffset = randomDiskNumber < 2 ? random.nextInt(firstFileSize) : random.nextInt(lastFileSize);
        ZipSplitReadOnlySeekableByteChannel channel = (ZipSplitReadOnlySeekableByteChannel)ZipSplitReadOnlySeekableByteChannel.buildFromLastSplitSegment((File)lastFile);
        channel.position((long)randomDiskNumber, (long)randomOffset);
        long expectedPosition = randomOffset;
        expectedPosition += randomDiskNumber > 0 ? (long)firstFileSize : 0L;
        Assertions.assertEquals((long)(expectedPosition += randomDiskNumber > 1 ? (long)secondFileSize : 0L), (long)channel.position());
    }
}

