/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.utils.SkipShieldingInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SkipShieldingInputStreamTest {
    @Test
    public void skipDelegatesToRead() throws IOException {
        try (SkipShieldingInputStream i = new SkipShieldingInputStream(new InputStream(){

            @Override
            public int read() {
                return -1;
            }

            @Override
            public int read(byte[] b, int off, int len) {
                return len;
            }

            @Override
            public long skip(long n) {
                Assertions.fail((String)"skip invoked");
                return -1L;
            }
        });){
            Assertions.assertEquals((long)100L, (long)i.skip(100L));
        }
    }

    @Test
    public void skipHasAnUpperBoundOnRead() throws IOException {
        try (SkipShieldingInputStream i = new SkipShieldingInputStream(new InputStream(){

            @Override
            public int read() {
                return -1;
            }

            @Override
            public int read(byte[] b, int off, int len) {
                return len;
            }

            @Override
            public long skip(long n) {
                Assertions.fail((String)"skip invoked");
                return -1L;
            }
        });){
            Assertions.assertTrue((Integer.MAX_VALUE > i.skip(Long.MAX_VALUE) ? 1 : 0) != 0);
        }
    }

    @Test
    public void skipSwallowsNegativeArguments() throws IOException {
        try (SkipShieldingInputStream i = new SkipShieldingInputStream(new InputStream(){

            @Override
            public int read() {
                return -1;
            }

            @Override
            public int read(byte[] b, int off, int len) {
                Assertions.fail((String)"read invoked");
                return len;
            }

            @Override
            public long skip(long n) {
                Assertions.fail((String)"skip invoked");
                return -1L;
            }
        });){
            Assertions.assertEquals((long)0L, (long)i.skip(Long.MIN_VALUE));
        }
    }
}

