/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.utils.CountingInputStream;
import org.apache.commons.compress.utils.CountingOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CountingStreamTest {
    @Test
    public void input() throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(new byte[]{1, 2, 3, 4});
        try (CountingInputStream i = new CountingInputStream((InputStream)bis);){
            Assertions.assertEquals((int)1, (int)i.read());
            Assertions.assertEquals((long)1L, (long)i.getBytesRead());
            byte[] b = new byte[2];
            i.read(b);
            Assertions.assertEquals((long)3L, (long)i.getBytesRead());
            Assertions.assertArrayEquals((byte[])new byte[]{2, 3}, (byte[])b);
            b = new byte[3];
            i.read(b, 1, 1);
            Assertions.assertArrayEquals((byte[])new byte[]{0, 4, 0}, (byte[])b);
            Assertions.assertEquals((long)4L, (long)i.getBytesRead());
            i.count(-1L);
            Assertions.assertEquals((long)4L, (long)i.getBytesRead());
            i.count(-2L);
            Assertions.assertEquals((long)2L, (long)i.getBytesRead());
        }
    }

    @Test
    public void output() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (CountingOutputStream o = new CountingOutputStream((OutputStream)bos);){
            o.write(1);
            Assertions.assertEquals((long)1L, (long)o.getBytesWritten());
            o.write(new byte[]{2, 3});
            Assertions.assertEquals((long)3L, (long)o.getBytesWritten());
            o.write(new byte[]{2, 3, 4, 5}, 2, 1);
            Assertions.assertEquals((long)4L, (long)o.getBytesWritten());
            o.count(-1L);
            Assertions.assertEquals((long)4L, (long)o.getBytesWritten());
            o.count(-2L);
            Assertions.assertEquals((long)2L, (long)o.getBytesWritten());
        }
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4}, (byte[])bos.toByteArray());
    }
}

