/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.commons.compress.harmony.unpack200.Segment;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SegmentTest {
    InputStream in;
    JarOutputStream out;
    File file;

    @AfterEach
    public void tearDown() throws Exception {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.file.delete();
    }

    @Test
    public void testHelloWorld() throws Exception {
        this.in = Segment.class.getResourceAsStream("/pack200/HelloWorld.pack");
        this.file = File.createTempFile("hello", "world.jar");
        this.file.deleteOnExit();
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        Segment segment = new Segment();
        segment.unpack(this.in, this.out);
        this.out.close();
        this.out = null;
        JarFile jarFile = new JarFile(this.file);
        JarEntry entry = jarFile.getJarEntry("org/apache/harmony/archive/tests/internal/pack200/HelloWorld.class");
        Assertions.assertNotNull((Object)entry);
        InputStream ours = jarFile.getInputStream(entry);
        JarFile jarFile2 = new JarFile(new File(Segment.class.getResource("/pack200/hw.jar").toURI()));
        JarEntry entry2 = jarFile2.getJarEntry("org/apache/harmony/archive/tests/internal/pack200/HelloWorld.class");
        Assertions.assertNotNull((Object)entry2);
        InputStream expected = jarFile2.getInputStream(entry2);
        BufferedReader reader1 = new BufferedReader(new InputStreamReader(ours));
        BufferedReader reader2 = new BufferedReader(new InputStreamReader(expected));
        String line1 = reader1.readLine();
        String line2 = reader2.readLine();
        int i = 1;
        while (line1 != null || line2 != null) {
            Assertions.assertEquals((Object)line2, (Object)line1, (String)"Unpacked class files differ");
            line1 = reader1.readLine();
            line2 = reader2.readLine();
            ++i;
        }
        reader1.close();
        reader2.close();
    }

    @Test
    public void testInterfaceOnly() throws Exception {
        this.in = Segment.class.getResourceAsStream("/pack200/InterfaceOnly.pack");
        this.file = File.createTempFile("Interface", "Only.jar");
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        Segment segment = new Segment();
        segment.unpack(this.in, this.out);
    }

    @Test
    public void testJustResources() throws Exception {
        this.in = Segment.class.getResourceAsStream("/pack200/JustResources.pack");
        this.file = File.createTempFile("just", "resources.jar");
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        Segment segment = new Segment();
        segment.unpack(this.in, this.out);
    }
}

