/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.z;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.z.ZCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ZCompressorInputStreamTest {
    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = AbstractTestCase.getFile("bla.tar.Z");
        byte[] buf = new byte[2];
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ZCompressorInputStream in = new ZCompressorInputStream(is);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read(buf));
            Assertions.assertEquals((int)-1, (int)in.read(buf));
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = AbstractTestCase.getFile("bla.tar.Z");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ZCompressorInputStream in = new ZCompressorInputStream(is);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    @Test
    public void testFailsToCreateZCompressorInputStreamAndThrowsIOException() {
        SequenceInputStream sequenceInputStream = new SequenceInputStream(Collections.emptyEnumeration());
        Assertions.assertThrows(IOException.class, () -> new ZCompressorInputStream((InputStream)sequenceInputStream));
    }
}

