/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.stream.Stream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorOutputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public final class FramedLZ4CompressorRoundtripTest
extends AbstractTestCase {
    public static Stream<Arguments> factory() {
        return Stream.of(Arguments.of((Object[])new Object[]{new FramedLZ4CompressorOutputStream.Parameters(FramedLZ4CompressorOutputStream.BlockSize.K64)}), Arguments.of((Object[])new Object[]{new FramedLZ4CompressorOutputStream.Parameters(FramedLZ4CompressorOutputStream.BlockSize.K256)}), Arguments.of((Object[])new Object[]{new FramedLZ4CompressorOutputStream.Parameters(FramedLZ4CompressorOutputStream.BlockSize.M1)}), Arguments.of((Object[])new Object[]{FramedLZ4CompressorOutputStream.Parameters.DEFAULT}), Arguments.of((Object[])new Object[]{new FramedLZ4CompressorOutputStream.Parameters(FramedLZ4CompressorOutputStream.BlockSize.M4, false, false, false)}), Arguments.of((Object[])new Object[]{new FramedLZ4CompressorOutputStream.Parameters(FramedLZ4CompressorOutputStream.BlockSize.M4, true, true, false)}), Arguments.of((Object[])new Object[]{new FramedLZ4CompressorOutputStream.Parameters(FramedLZ4CompressorOutputStream.BlockSize.K64, true, false, true)}), Arguments.of((Object[])new Object[]{new FramedLZ4CompressorOutputStream.Parameters(FramedLZ4CompressorOutputStream.BlockSize.M4, true, false, false, BlockLZ4CompressorOutputStream.createParameterBuilder().tunedForSpeed().build())}));
    }

    @ParameterizedTest
    @MethodSource(value={"factory"})
    public void biggerFileRoundtrip(FramedLZ4CompressorOutputStream.Parameters params) throws IOException {
        this.roundTripTest("COMPRESS-256.7z", params);
    }

    @ParameterizedTest
    @MethodSource(value={"factory"})
    public void blaTarRoundtrip(FramedLZ4CompressorOutputStream.Parameters params) throws IOException {
        this.roundTripTest("bla.tar", params);
    }

    @ParameterizedTest
    @MethodSource(value={"factory"})
    public void gzippedLoremIpsumRoundtrip(FramedLZ4CompressorOutputStream.Parameters params) throws IOException {
        this.roundTripTest("lorem-ipsum.txt.gz", params);
    }

    private void roundTripTest(String testFile, FramedLZ4CompressorOutputStream.Parameters params) throws IOException {
        byte[] expected;
        File input = FramedLZ4CompressorRoundtripTest.getFile(testFile);
        long start = System.currentTimeMillis();
        File outputSz = new File(this.dir, input.getName() + ".framed.lz4");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            expected = IOUtils.toByteArray((InputStream)is);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (FramedLZ4CompressorOutputStream los = new FramedLZ4CompressorOutputStream((OutputStream)bos, params);){
            IOUtils.copy((InputStream)new ByteArrayInputStream(expected), (OutputStream)los);
        }
        start = System.currentTimeMillis();
        var10_11 = null;
        try (FramedLZ4CompressorInputStream sis = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(bos.toByteArray()));){
            byte[] actual = IOUtils.toByteArray((InputStream)sis);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
        catch (Throwable throwable) {
            var10_11 = throwable;
            throw throwable;
        }
    }
}

