/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.changes;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.changes.Change;
import org.apache.commons.compress.changes.ChangeSet;
import org.apache.commons.compress.changes.ChangeSetPerformer;
import org.apache.commons.compress.changes.ChangeSetResults;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class ChangeSetTestCase
extends AbstractTestCase {
    private void archiveListDelete(String prefix) {
        this.archiveList.removeIf(entry -> entry.equals(prefix));
    }

    private void archiveListDeleteDir(String prefix) {
        this.archiveList.removeIf(entry -> entry.startsWith(prefix + "/"));
    }

    @Test
    public void testAddAllreadyExistingWithReplaceFalse() throws Exception {
        String archivename = "zip";
        Path input = this.createArchive("zip");
        File result = File.createTempFile("test", ".zip");
        result.deleteOnExit();
        try (InputStream is = Files.newInputStream(input, new OpenOption[0]);
             ArchiveInputStream ais = this.factory.createArchiveInputStream("zip", is);
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("zip", Files.newOutputStream(result.toPath(), new OpenOption[0]));){
            ChangeSet changes = new ChangeSet();
            File file1 = ChangeSetTestCase.getFile("test.txt");
            ZipArchiveEntry entry = new ZipArchiveEntry("testdata/test1.xml");
            changes.add((ArchiveEntry)entry, Files.newInputStream(file1.toPath(), new OpenOption[0]), false);
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            ChangeSetResults results = performer.perform(ais, out);
            Assertions.assertTrue((boolean)results.getAddedFromStream().contains("testdata/test1.xml"));
            Assertions.assertTrue((boolean)results.getAddedFromChangeSet().isEmpty());
            Assertions.assertTrue((boolean)results.getDeleted().isEmpty());
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testAddAllreadyExistingWithReplaceTrue() throws Exception {
        String archivename = "zip";
        Path input = this.createArchive("zip");
        File result = File.createTempFile("test", ".zip");
        result.deleteOnExit();
        try (InputStream is = Files.newInputStream(input, new OpenOption[0]);
             ArchiveInputStream ais = this.factory.createArchiveInputStream("zip", is);
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("zip", Files.newOutputStream(result.toPath(), new OpenOption[0]));){
            ChangeSet changes = new ChangeSet();
            File file1 = ChangeSetTestCase.getFile("test.txt");
            ZipArchiveEntry entry = new ZipArchiveEntry("testdata/test1.xml");
            changes.add((ArchiveEntry)entry, Files.newInputStream(file1.toPath(), new OpenOption[0]), true);
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            ChangeSetResults results = performer.perform(ais, out);
            Assertions.assertTrue((boolean)results.getAddedFromChangeSet().contains("testdata/test1.xml"));
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testAddChangeTwice() throws Exception {
        try (InputStream in = ChangeSetTestCase.newInputStream("test.txt");
             InputStream in2 = ChangeSetTestCase.newInputStream("test2.xml");){
            ZipArchiveEntry e = new ZipArchiveEntry("test.txt");
            ZipArchiveEntry e2 = new ZipArchiveEntry("test.txt");
            ChangeSet changes = new ChangeSet();
            changes.add((ArchiveEntry)e, in);
            changes.add((ArchiveEntry)e2, in2);
            Assertions.assertEquals((int)1, (int)changes.getChanges().size());
            Change c = (Change)changes.getChanges().iterator().next();
            Assertions.assertEquals((Object)in2, (Object)c.getInput());
        }
    }

    @Test
    public void testAddChangeTwiceWithoutReplace() throws Exception {
        try (InputStream in = ChangeSetTestCase.newInputStream("test.txt");
             InputStream in2 = ChangeSetTestCase.newInputStream("test2.xml");){
            ZipArchiveEntry e = new ZipArchiveEntry("test.txt");
            ZipArchiveEntry e2 = new ZipArchiveEntry("test.txt");
            ChangeSet changes = new ChangeSet();
            changes.add((ArchiveEntry)e, in, true);
            changes.add((ArchiveEntry)e2, in2, false);
            Assertions.assertEquals((int)1, (int)changes.getChanges().size());
            Change c = (Change)changes.getChanges().iterator().next();
            Assertions.assertEquals((Object)in, (Object)c.getInput());
        }
    }

    @Test
    public void testAddDeleteAdd() throws Exception {
        String archivename = "cpio";
        Path input = this.createArchive("cpio");
        File result = File.createTempFile("test", ".cpio");
        result.deleteOnExit();
        try (InputStream is = Files.newInputStream(input, new OpenOption[0]);
             ArchiveInputStream ais = this.factory.createArchiveInputStream("cpio", is);
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("cpio", Files.newOutputStream(result.toPath(), new OpenOption[0]));){
            ChangeSet changes = new ChangeSet();
            File file1 = ChangeSetTestCase.getFile("test.txt");
            CpioArchiveEntry entry = new CpioArchiveEntry("blub/test.txt");
            changes.add((ArchiveEntry)entry, Files.newInputStream(file1.toPath(), new OpenOption[0]));
            this.archiveList.add("blub/test.txt");
            changes.deleteDir("blub");
            this.archiveListDeleteDir("blub");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testAddDeleteToOneFileArchive() throws Exception {
        String archivename = "cpio";
        Path input = this.createSingleEntryArchive("cpio");
        File result = File.createTempFile("test", ".cpio");
        result.deleteOnExit();
        ChangeSet changes = new ChangeSet();
        try (InputStream is = Files.newInputStream(input, new OpenOption[0]);
             ArchiveInputStream ais = this.factory.createArchiveInputStream("cpio", is);
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("cpio", Files.newOutputStream(result.toPath(), new OpenOption[0]));){
            File file = ChangeSetTestCase.getFile("test.txt");
            ArchiveEntry entry = out.createArchiveEntry(file, "bla/test.txt");
            changes.add(entry, Files.newInputStream(file.toPath(), new OpenOption[0]));
            this.archiveList.add("bla/test.txt");
            changes.delete("test1.xml");
            this.archiveListDelete("test1.xml");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
            is.close();
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testAddMoveDelete() throws Exception {
    }

    @Test
    public void testAddToEmptyArchive() throws Exception {
        String archivename = "zip";
        Path input = this.createEmptyArchive("zip");
        File result = File.createTempFile("test", ".zip");
        result.deleteOnExit();
        ChangeSet changes = new ChangeSet();
        try (InputStream is = Files.newInputStream(input, new OpenOption[0]);
             ArchiveInputStream ais = this.factory.createArchiveInputStream("zip", is);
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("zip", Files.newOutputStream(result.toPath(), new OpenOption[0]));){
            File file1 = ChangeSetTestCase.getFile("test.txt");
            ZipArchiveEntry entry = new ZipArchiveEntry("bla/test.txt");
            changes.add((ArchiveEntry)entry, Files.newInputStream(file1.toPath(), new OpenOption[0]));
            this.archiveList.add("bla/test.txt");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
            is.close();
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testChangeSetResults() throws Exception {
        String archivename = "cpio";
        Path input = this.createArchive("cpio");
        File result = File.createTempFile("test", ".cpio");
        result.deleteOnExit();
        try (InputStream is = Files.newInputStream(input, new OpenOption[0]);
             ArchiveInputStream ais = this.factory.createArchiveInputStream("cpio", is);
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("cpio", Files.newOutputStream(result.toPath(), new OpenOption[0]));){
            ChangeSet changes = new ChangeSet();
            changes.deleteDir("bla");
            this.archiveListDeleteDir("bla");
            File file1 = ChangeSetTestCase.getFile("test.txt");
            ArchiveEntry entry = out.createArchiveEntry(file1, "bla/test.txt");
            changes.add(entry, Files.newInputStream(file1.toPath(), new OpenOption[0]));
            this.archiveList.add("bla/test.txt");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            ChangeSetResults results = performer.perform(ais, out);
            is.close();
            Assertions.assertEquals((int)1, (int)results.getAddedFromChangeSet().size());
            Assertions.assertEquals((Object)"bla/test.txt", results.getAddedFromChangeSet().iterator().next());
            Assertions.assertEquals((int)3, (int)results.getDeleted().size());
            Assertions.assertTrue((boolean)results.getDeleted().contains("bla/test4.xml"));
            Assertions.assertTrue((boolean)results.getDeleted().contains("bla/test5.xml"));
            Assertions.assertTrue((boolean)results.getDeleted().contains("bla/blubber/test6.xml"));
            Assertions.assertTrue((boolean)results.getAddedFromStream().contains("testdata/test1.xml"));
            Assertions.assertTrue((boolean)results.getAddedFromStream().contains("testdata/test2.xml"));
            Assertions.assertTrue((boolean)results.getAddedFromStream().contains("test/test3.xml"));
            Assertions.assertTrue((boolean)results.getAddedFromStream().contains("test.txt"));
            Assertions.assertTrue((boolean)results.getAddedFromStream().contains("something/bla"));
            Assertions.assertTrue((boolean)results.getAddedFromStream().contains("test with spaces.txt"));
            Assertions.assertEquals((int)6, (int)results.getAddedFromStream().size());
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testDeleteAddDelete() throws Exception {
        String archivename = "cpio";
        Path input = this.createArchive("cpio");
        File result = File.createTempFile("test", ".cpio");
        result.deleteOnExit();
        try (InputStream is = Files.newInputStream(input, new OpenOption[0]);
             ArchiveInputStream ais = this.factory.createArchiveInputStream("cpio", is);
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("cpio", Files.newOutputStream(result.toPath(), new OpenOption[0]));){
            ChangeSet changes = new ChangeSet();
            changes.deleteDir("bla");
            File file1 = ChangeSetTestCase.getFile("test.txt");
            CpioArchiveEntry entry = new CpioArchiveEntry("bla/test.txt");
            changes.add((ArchiveEntry)entry, Files.newInputStream(file1.toPath(), new OpenOption[0]));
            this.archiveList.add("bla/test.txt");
            changes.deleteDir("bla");
            this.archiveListDeleteDir("bla");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testDeleteAddToOneFileArchive() throws Exception {
        String archivename = "zip";
        Path input = this.createSingleEntryArchive("zip");
        File result = File.createTempFile("test", ".zip");
        result.deleteOnExit();
        ChangeSet changes = new ChangeSet();
        try (InputStream is = Files.newInputStream(input, new OpenOption[0]);
             ArchiveInputStream ais = this.factory.createArchiveInputStream("zip", is);
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("zip", Files.newOutputStream(result.toPath(), new OpenOption[0]));){
            changes.delete("test1.xml");
            this.archiveListDelete("test1.xml");
            File file = ChangeSetTestCase.getFile("test.txt");
            ArchiveEntry entry = out.createArchiveEntry(file, "bla/test.txt");
            changes.add(entry, Files.newInputStream(file.toPath(), new OpenOption[0]));
            this.archiveList.add("bla/test.txt");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testDeleteDir() throws Exception {
        String archivename = "cpio";
        Path input = this.createArchive("cpio");
        File result = File.createTempFile("test", ".cpio");
        result.deleteOnExit();
        try (InputStream is = Files.newInputStream(input, new OpenOption[0]);
             ArchiveInputStream ais = this.factory.createArchiveInputStream("cpio", is);
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("cpio", Files.newOutputStream(result.toPath(), new OpenOption[0]));){
            ChangeSet changes = new ChangeSet();
            changes.deleteDir("bla");
            this.archiveListDeleteDir("bla");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testDeleteDir2() throws Exception {
        String archivename = "cpio";
        Path input = this.createArchive("cpio");
        File result = File.createTempFile("test", ".cpio");
        result.deleteOnExit();
        try (InputStream is = Files.newInputStream(input, new OpenOption[0]);
             ArchiveInputStream ais = this.factory.createArchiveInputStream("cpio", is);
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("cpio", Files.newOutputStream(result.toPath(), new OpenOption[0]));){
            ChangeSet changes = new ChangeSet();
            changes.deleteDir("la");
            this.archiveListDeleteDir("la");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testDeleteDir3() throws Exception {
        String archivename = "cpio";
        Path input = this.createArchive("cpio");
        File result = File.createTempFile("test", ".cpio");
        result.deleteOnExit();
        try (InputStream is = Files.newInputStream(input, new OpenOption[0]);
             ArchiveInputStream ais = this.factory.createArchiveInputStream("cpio", is);
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("cpio", Files.newOutputStream(result.toPath(), new OpenOption[0]));){
            ChangeSet changes = new ChangeSet();
            changes.deleteDir("test.txt");
            this.archiveListDeleteDir("test.txt");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testDeleteFile() throws Exception {
        String archivename = "cpio";
        Path input = this.createArchive("cpio");
        File result = File.createTempFile("test", ".cpio");
        result.deleteOnExit();
        try (InputStream is = Files.newInputStream(input, new OpenOption[0]);
             ArchiveInputStream ais = this.factory.createArchiveInputStream("cpio", is);
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("cpio", Files.newOutputStream(result.toPath(), new OpenOption[0]));){
            ChangeSet changes = new ChangeSet();
            changes.delete("bla/test5.xml");
            this.archiveListDelete("bla/test5.xml");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testDeleteFile2() throws Exception {
        String archivename = "cpio";
        Path input = this.createArchive("cpio");
        File result = File.createTempFile("test", ".cpio");
        result.deleteOnExit();
        try (InputStream is = Files.newInputStream(input, new OpenOption[0]);
             ArchiveInputStream ais = this.factory.createArchiveInputStream("cpio", is);
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("cpio", Files.newOutputStream(result.toPath(), new OpenOption[0]));){
            ChangeSet changes = new ChangeSet();
            changes.delete("bla");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testDeleteFromAndAddToAr() throws Exception {
        ChangeSet changes = new ChangeSet();
        changes.delete("test2.xml");
        File file1 = ChangeSetTestCase.getFile("test.txt");
        ArArchiveEntry entry = new ArArchiveEntry("test.txt", file1.length());
        changes.add((ArchiveEntry)entry, Files.newInputStream(file1.toPath(), new OpenOption[0]));
        File input = ChangeSetTestCase.getFile("bla.ar");
        InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
        File temp = new File(this.dir, "bla.ar");
        try (ArchiveInputStream ais = this.factory.createArchiveInputStream("ar", is);
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("ar", Files.newOutputStream(temp.toPath(), new OpenOption[0]));){
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        expected.add("test.txt");
        this.checkArchiveContent(temp, expected);
    }

    @Test
    public void testDeleteFromAndAddToJar() throws Exception {
        ChangeSet changes = new ChangeSet();
        changes.delete("test2.xml");
        changes.deleteDir("META-INF");
        changes.delete(".classpath");
        changes.delete(".project");
        File file1 = ChangeSetTestCase.getFile("test.txt");
        JarArchiveEntry entry = new JarArchiveEntry("testdata/test.txt");
        changes.add((ArchiveEntry)entry, Files.newInputStream(file1.toPath(), new OpenOption[0]));
        File input = ChangeSetTestCase.getFile("bla.jar");
        InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
        File temp = new File(this.dir, "bla.jar");
        try (ArchiveInputStream ais = this.factory.createArchiveInputStream("jar", is);
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("jar", Files.newOutputStream(temp.toPath(), new OpenOption[0]));){
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        expected.add("testdata/test.txt");
        this.checkArchiveContent(temp, expected);
    }

    @Test
    public void testDeleteFromAndAddToTar() throws Exception {
        ChangeSet changes = new ChangeSet();
        changes.delete("test2.xml");
        File file1 = ChangeSetTestCase.getFile("test.txt");
        TarArchiveEntry entry = new TarArchiveEntry("testdata/test.txt");
        entry.setModTime(0L);
        entry.setSize(file1.length());
        entry.setUserId(0);
        entry.setGroupId(0);
        entry.setUserName("avalon");
        entry.setGroupName("excalibur");
        entry.setMode(32768);
        changes.add((ArchiveEntry)entry, Files.newInputStream(file1.toPath(), new OpenOption[0]));
        File input = ChangeSetTestCase.getFile("bla.tar");
        File temp = new File(this.dir, "bla.tar");
        try (ArchiveInputStream ais = this.factory.createArchiveInputStream("tar", Files.newInputStream(input.toPath(), new OpenOption[0]));
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("tar", Files.newOutputStream(temp.toPath(), new OpenOption[0]));){
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        expected.add("testdata/test.txt");
        ArchiveInputStream in = this.factory.createArchiveInputStream("tar", Files.newInputStream(temp.toPath(), new OpenOption[0]));
        this.checkArchiveContent(in, expected);
    }

    @Test
    public void testDeleteFromAndAddToZip() throws Exception {
        String archivename = "zip";
        Path input = this.createArchive("zip");
        File result = File.createTempFile("test", ".zip");
        result.deleteOnExit();
        try (ArchiveInputStream ais = this.factory.createArchiveInputStream("zip", Files.newInputStream(input, new OpenOption[0]));
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("zip", Files.newOutputStream(result.toPath(), new OpenOption[0]));){
            ChangeSet changes = new ChangeSet();
            File file1 = ChangeSetTestCase.getFile("test.txt");
            ZipArchiveEntry entry = new ZipArchiveEntry("blub/test.txt");
            changes.add((ArchiveEntry)entry, Files.newInputStream(file1.toPath(), new OpenOption[0]));
            this.archiveList.add("blub/test.txt");
            changes.delete("testdata/test1.xml");
            this.archiveListDelete("testdata/test1.xml");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testDeleteFromAndAddToZipUsingZipFilePerform() throws Exception {
        String archivename = "zip";
        Path input = this.createArchive("zip");
        File result = File.createTempFile("test", ".zip");
        result.deleteOnExit();
        try (ZipFile ais = new ZipFile(input);
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("zip", Files.newOutputStream(result.toPath(), new OpenOption[0]));){
            ChangeSet changes = new ChangeSet();
            File file1 = ChangeSetTestCase.getFile("test.txt");
            ZipArchiveEntry entry = new ZipArchiveEntry("blub/test.txt");
            changes.add((ArchiveEntry)entry, Files.newInputStream(file1.toPath(), new OpenOption[0]));
            this.archiveList.add("blub/test.txt");
            changes.delete("testdata/test1.xml");
            this.archiveListDelete("testdata/test1.xml");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testDeleteFromAr() throws Exception {
        ChangeSet changes = new ChangeSet();
        changes.delete("test2.xml");
        File input = ChangeSetTestCase.getFile("bla.ar");
        File temp = new File(this.dir, "bla.ar");
        try (ArchiveInputStream ais = this.factory.createArchiveInputStream("ar", Files.newInputStream(input.toPath(), new OpenOption[0]));
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("ar", Files.newOutputStream(temp.toPath(), new OpenOption[0]));){
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        this.checkArchiveContent(temp, expected);
    }

    @Test
    public void testDeleteFromJar() throws Exception {
        ChangeSet changes = new ChangeSet();
        changes.delete("test2.xml");
        changes.deleteDir("META-INF");
        changes.delete(".classpath");
        changes.delete(".project");
        File input = ChangeSetTestCase.getFile("bla.jar");
        File temp = new File(this.dir, "bla.jar");
        try (ArchiveInputStream ais = this.factory.createArchiveInputStream("jar", Files.newInputStream(input.toPath(), new OpenOption[0]));
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("jar", Files.newOutputStream(temp.toPath(), new OpenOption[0]));){
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        this.checkArchiveContent(temp, expected);
    }

    @Test
    public void testDeleteFromTar() throws Exception {
        ChangeSet changes = new ChangeSet();
        changes.delete("test2.xml");
        File input = ChangeSetTestCase.getFile("bla.tar");
        InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
        File temp = new File(this.dir, "bla.tar");
        try (ArchiveInputStream ais = this.factory.createArchiveInputStream("tar", is);
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("tar", Files.newOutputStream(temp.toPath(), new OpenOption[0]));){
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        this.checkArchiveContent(temp, expected);
    }

    @Test
    public void testDeleteFromZip() throws Exception {
        ChangeSet changes = new ChangeSet();
        changes.delete("test2.xml");
        File input = ChangeSetTestCase.getFile("bla.zip");
        File temp = File.createTempFile("test", ".zip");
        temp.deleteOnExit();
        try (ArchiveInputStream ais = this.factory.createArchiveInputStream("zip", Files.newInputStream(input.toPath(), new OpenOption[0]));
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("zip", Files.newOutputStream(temp.toPath(), new OpenOption[0]));){
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        this.checkArchiveContent(temp, expected);
    }

    @Test
    public void testDeletePlusAdd() throws Exception {
        String archivename = "cpio";
        Path input = this.createArchive("cpio");
        File result = File.createTempFile("test", ".cpio");
        result.deleteOnExit();
        try (ArchiveInputStream ais = this.factory.createArchiveInputStream("cpio", Files.newInputStream(input, new OpenOption[0]));
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("cpio", Files.newOutputStream(result.toPath(), new OpenOption[0]));){
            ChangeSet changes = new ChangeSet();
            changes.deleteDir("bla");
            this.archiveListDeleteDir("bla");
            File file1 = ChangeSetTestCase.getFile("test.txt");
            ArchiveEntry entry = out.createArchiveEntry(file1, "bla/test.txt");
            changes.add(entry, Files.newInputStream(file1.toPath(), new OpenOption[0]));
            this.archiveList.add("bla/test.txt");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    @Test
    public void testDeletePlusAddSame() throws Exception {
        String archivename = "zip";
        Path input = this.createArchive("zip");
        File result = File.createTempFile("test", ".zip");
        result.deleteOnExit();
        File testtxt = null;
        try (ArchiveInputStream ais = this.factory.createArchiveInputStream("zip", Files.newInputStream(input, new OpenOption[0]));
             ArchiveOutputStream out = this.factory.createArchiveOutputStream("zip", Files.newOutputStream(result.toPath(), new OpenOption[0]));){
            ChangeSet changes = new ChangeSet();
            changes.delete("test/test3.xml");
            this.archiveListDelete("test/test3.xml");
            testtxt = ChangeSetTestCase.getFile("test.txt");
            ArchiveEntry entry = out.createArchiveEntry(testtxt, "test/test3.xml");
            changes.add(entry, Files.newInputStream(testtxt.toPath(), new OpenOption[0]));
            this.archiveList.add("test/test3.xml");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        File check = null;
        try (BufferedInputStream buf = new BufferedInputStream(Files.newInputStream(result.toPath(), new OpenOption[0]));
             ArchiveInputStream in = this.factory.createArchiveInputStream((InputStream)buf);){
            check = this.checkArchiveContent(in, this.archiveList, false);
            File test3xml = new File(check, "result/test/test3.xml");
            Assertions.assertEquals((long)testtxt.length(), (long)test3xml.length());
            try (BufferedReader reader = new BufferedReader(Files.newBufferedReader(test3xml.toPath()));){
                String str;
                while ((str = reader.readLine()) != null) {
                    "111111111111111111111111111000101011".equals(str);
                }
            }
        }
        ChangeSetTestCase.rmdir(check);
    }

    @Test
    public void testRenameAndDelete() throws Exception {
    }
}

