/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.dump;

import java.io.InputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.dump.DumpArchiveEntry;
import org.apache.commons.compress.archivers.dump.DumpArchiveInputStream;
import org.apache.commons.compress.archivers.dump.ShortFileException;
import org.apache.commons.compress.archivers.dump.UnrecognizedFormatException;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DumpArchiveInputStreamTest
extends AbstractTestCase {
    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        byte[] buf = new byte[2];
        try (InputStream in = DumpArchiveInputStreamTest.newInputStream("bla.dump");
             DumpArchiveInputStream archive = new DumpArchiveInputStream(in);){
            DumpArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)-1, (int)archive.read(buf));
            Assertions.assertEquals((int)-1, (int)archive.read(buf));
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        try (InputStream in = DumpArchiveInputStreamTest.newInputStream("bla.dump");
             DumpArchiveInputStream archive = new DumpArchiveInputStream(in);){
            DumpArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)-1, (int)archive.read());
            Assertions.assertEquals((int)-1, (int)archive.read());
        }
    }

    @Test
    public void testConsumesArchiveCompletely() throws Exception {
        try (InputStream is = DumpArchiveInputStreamTest.class.getResourceAsStream("/archive_with_trailer.dump");
             DumpArchiveInputStream dump = new DumpArchiveInputStream(is);){
            while (dump.getNextDumpEntry() != null) {
            }
            byte[] expected = new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 10};
            byte[] actual = new byte[expected.length];
            is.read(actual);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void testNotADumpArchive() throws Exception {
        try (InputStream is = DumpArchiveInputStreamTest.newInputStream("bla.zip");){
            ArchiveException ex = (ArchiveException)Assertions.assertThrows(ArchiveException.class, () -> new DumpArchiveInputStream(is).close(), (String)"expected an exception");
            Assertions.assertTrue((boolean)(ex.getCause() instanceof ShortFileException));
        }
    }

    @Test
    public void testNotADumpArchiveButBigEnough() throws Exception {
        try (InputStream is = DumpArchiveInputStreamTest.newInputStream("zip64support.tar.bz2");){
            ArchiveException ex = (ArchiveException)Assertions.assertThrows(ArchiveException.class, () -> new DumpArchiveInputStream(is).close(), (String)"expected an exception");
            Assertions.assertInstanceOf(UnrecognizedFormatException.class, (Object)ex.getCause());
        }
    }
}

