/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class LongSymLinkTest
extends AbstractTestCase {
    private static final ClassLoader CLASSLOADER = LongSymLinkTest.class.getClassLoader();
    private static final File ARCDIR;
    private static final ArrayList<String> FILELIST;

    public static Stream<Arguments> data() {
        ArrayList<Arguments> params = new ArrayList<Arguments>();
        for (String fileName : ARCDIR.list((dir, name) -> !name.endsWith(".txt"))) {
            params.add(Arguments.of((Object[])new Object[]{new File(ARCDIR, fileName)}));
        }
        return params.stream();
    }

    @BeforeAll
    public static void setUpFileList() throws Exception {
        String line;
        Assertions.assertTrue((boolean)ARCDIR.exists());
        File listing = new File(ARCDIR, "files.txt");
        Assertions.assertTrue((boolean)listing.canRead(), (String)"files.txt is readable");
        BufferedReader br = new BufferedReader(Files.newBufferedReader(listing.toPath()));
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            FILELIST.add(line);
        }
        br.close();
    }

    @Override
    protected String getExpectedString(ArchiveEntry entry) {
        TarArchiveEntry tarEntry;
        if (entry instanceof TarArchiveEntry && (tarEntry = (TarArchiveEntry)entry).isSymbolicLink()) {
            return tarEntry.getName() + " -> " + tarEntry.getLinkName();
        }
        return entry.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testArchive(File file) throws Exception {
        ArrayList expected = (ArrayList)FILELIST.clone();
        String name = file.getName();
        if ("minotaur.jar".equals(name) || "minotaur-0.jar".equals(name)) {
            expected.add("META-INF/");
            expected.add("META-INF/MANIFEST.MF");
        }
        ArchiveInputStream ais = this.factory.createArchiveInputStream((InputStream)new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])));
        if (name.endsWith(".tar")) {
            Assertions.assertTrue((boolean)(ais instanceof TarArchiveInputStream));
        } else if (name.endsWith(".jar") || name.endsWith(".zip")) {
            Assertions.assertTrue((boolean)(ais instanceof ZipArchiveInputStream));
        } else if (name.endsWith(".cpio")) {
            Assertions.assertTrue((boolean)(ais instanceof CpioArchiveInputStream));
            for (int i = 0; i < expected.size(); ++i) {
                String ent = (String)expected.get(i);
                if (!ent.endsWith("/")) continue;
                expected.set(i, ent.substring(0, ent.length() - 1));
            }
        } else if (name.endsWith(".ar")) {
            Assertions.assertTrue((boolean)(ais instanceof ArArchiveInputStream));
            expected.clear();
            for (String ent : FILELIST) {
                if (ent.endsWith("/")) continue;
                int lastSlash = ent.lastIndexOf(47);
                if (lastSlash >= 0) {
                    expected.add(ent.substring(lastSlash + 1));
                    continue;
                }
                expected.add(ent);
            }
        } else {
            Assertions.fail((String)("Unexpected file type: " + name));
        }
        try {
            Assertions.assertDoesNotThrow(() -> this.checkArchiveContent(ais, (List<String>)expected), (String)("Error processing " + file.getName()));
        }
        finally {
            ais.close();
        }
    }

    static {
        FILELIST = new ArrayList();
        try {
            ARCDIR = new File(CLASSLOADER.getResource("longsymlink").toURI());
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }
}

