/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.InputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChainingTestCase
extends AbstractTestCase {
    @Test
    public void testTarBzip2() throws Exception {
        try (TarArchiveInputStream is = new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream(ChainingTestCase.newInputStream("bla.tar.bz2")));){
            TarArchiveEntry entry = (TarArchiveEntry)is.getNextEntry();
            Assertions.assertNotNull((Object)entry);
            Assertions.assertEquals((Object)"test1.xml", (Object)entry.getName());
            Assertions.assertEquals((byte)48, (byte)entry.getLinkFlag());
        }
    }

    @Test
    public void testTarGzip() throws Exception {
        try (TarArchiveInputStream is = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(ChainingTestCase.newInputStream("bla.tgz")));){
            TarArchiveEntry entry = (TarArchiveEntry)is.getNextEntry();
            Assertions.assertNotNull((Object)entry);
            Assertions.assertEquals((Object)"test1.xml", (Object)entry.getName());
            Assertions.assertEquals((byte)48, (byte)entry.getLinkFlag());
        }
    }
}

