/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.util.NoSuchElementException;
import org.apache.commons.compress.utils.ServiceLoaderIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ServiceLoaderIteratorTest {
    @Test
    public void testHasNextReturnsFalse() {
        Class<Object> clasz = Object.class;
        ServiceLoaderIterator serviceLoaderIterator = new ServiceLoaderIterator(clasz);
        boolean result = serviceLoaderIterator.hasNext();
        Assertions.assertFalse((boolean)result);
    }

    @Test
    public void testNextThrowsNoSuchElementException() {
        Class<String> clasz = String.class;
        ServiceLoaderIterator serviceLoaderIterator = new ServiceLoaderIterator(clasz);
        Assertions.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)serviceLoaderIterator.next();
        });
    }

    @Test
    public void testRemoveThrowsUnsupportedOperationException() {
        Class<Integer> clasz = Integer.class;
        ServiceLoaderIterator serviceLoaderIterator = new ServiceLoaderIterator(clasz);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> serviceLoaderIterator.remove());
    }
}

