/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.tests;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.commons.compress.harmony.unpack200.Archive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArchiveTest {
    InputStream in;
    JarOutputStream out;
    File file;

    @AfterEach
    public void tearDown() throws Exception {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.file.delete();
    }

    @Test
    public void testAlternativeConstructor() throws Exception {
        String inputFile = new File(Archive.class.getResource("/pack200/sql.pack.gz").toURI()).getPath();
        this.file = File.createTempFile("sql", ".jar");
        this.file.deleteOnExit();
        String outputFile = this.file.getPath();
        Archive archive = new Archive(inputFile, outputFile);
        archive.unpack();
    }

    @Test
    public void testDeflateHint() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");
        this.file = File.createTempFile("sql", ".jar");
        this.file.deleteOnExit();
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        Archive archive = new Archive(this.in, this.out);
        archive.setDeflateHint(true);
        archive.unpack();
        JarFile jarFile = new JarFile(this.file);
        Assertions.assertEquals((int)8, (int)jarFile.getEntry("bin/test/org/apache/harmony/sql/tests/internal/rowset/CachedRowSetImplTest.class").getMethod());
        this.in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");
        this.file = File.createTempFile("sql", ".jar");
        this.file.deleteOnExit();
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        archive = new Archive(this.in, this.out);
        archive.setDeflateHint(false);
        archive.unpack();
        jarFile = new JarFile(this.file);
        Assertions.assertEquals((int)0, (int)jarFile.getEntry("bin/test/org/apache/harmony/sql/tests/internal/rowset/CachedRowSetImplTest.class").getMethod());
    }

    @Test
    public void testJustResourcesGZip() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/JustResources.pack.gz");
        this.file = File.createTempFile("Just", "ResourcesGz.jar");
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        Archive archive = new Archive(this.in, this.out);
        archive.unpack();
    }

    @Test
    public void testLoggingOptions() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");
        this.file = File.createTempFile("logtest", ".jar");
        this.file.deleteOnExit();
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        Archive archive = new Archive(this.in, this.out);
        File logFile = File.createTempFile("logfile", ".txt");
        logFile.deleteOnExit();
        archive.setLogFile(logFile.getPath());
        archive.unpack();
        FileReader reader = new FileReader(logFile);
        Assertions.assertFalse((boolean)reader.ready());
        reader.close();
        this.in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");
        this.file = File.createTempFile("logtest", ".jar");
        this.file.deleteOnExit();
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        archive = new Archive(this.in, this.out);
        logFile = File.createTempFile("logfile", ".txt");
        logFile.deleteOnExit();
        archive.setLogFile(logFile.getPath());
        archive.setVerbose(true);
        archive.unpack();
        reader = new FileReader(logFile);
        Assertions.assertTrue((boolean)reader.ready());
        reader.close();
        long length = logFile.length();
        this.in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");
        this.file = File.createTempFile("logtest", ".jar");
        this.file.deleteOnExit();
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        archive = new Archive(this.in, this.out);
        archive.setLogFile(logFile.getPath(), true);
        archive.setVerbose(true);
        archive.unpack();
        Assertions.assertTrue((logFile.length() > length ? 1 : 0) != 0);
        this.in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");
        this.file = File.createTempFile("logtest", ".jar");
        this.file.deleteOnExit();
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        archive = new Archive(this.in, this.out);
        archive.setLogFile(logFile.getPath(), false);
        archive.setVerbose(true);
        archive.unpack();
        Assertions.assertTrue((logFile.length() == length ? 1 : 0) != 0);
        this.in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");
        this.file = File.createTempFile("logtest", ".jar");
        this.file.deleteOnExit();
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        archive = new Archive(this.in, this.out);
        logFile = File.createTempFile("logfile", ".txt");
        logFile.deleteOnExit();
        archive.setLogFile(logFile.getPath());
        archive.setQuiet(true);
        archive.unpack();
        reader = new FileReader(logFile);
        Assertions.assertFalse((boolean)reader.ready());
        reader.close();
    }

    @Test
    public void testRemovePackFile() throws Exception {
        File original = new File(Archive.class.getResource("/pack200/sql.pack.gz").toURI());
        File copy = File.createTempFile("sqlcopy", ".pack.gz");
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(original));
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(copy));
        byte[] bytes = new byte[256];
        int read = inputStream.read(bytes);
        while (read > 0) {
            outputStream.write(bytes, 0, read);
            read = inputStream.read(bytes);
        }
        inputStream.close();
        outputStream.close();
        String inputFile = copy.getPath();
        this.file = File.createTempFile("sqlout", ".jar");
        this.file.deleteOnExit();
        String outputFile = this.file.getPath();
        Archive archive = new Archive(inputFile, outputFile);
        archive.setRemovePackFile(true);
        archive.unpack();
        Assertions.assertFalse((boolean)copy.exists());
    }

    @Test
    public void testWithAnnotations() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/annotations.pack.gz");
        this.file = File.createTempFile("annotations", ".jar");
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        Archive archive = new Archive(this.in, this.out);
        archive.unpack();
    }

    @Test
    public void testWithE0() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/simple-E0.pack.gz");
        this.file = File.createTempFile("simple-e0", ".jar");
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        Archive archive = new Archive(this.in, this.out);
        archive.unpack();
    }

    @Test
    public void testWithJNDIE1() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/jndi-e1.pack.gz");
        this.file = File.createTempFile("jndi-e1", ".jar");
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        Archive archive = new Archive(this.in, this.out);
        archive.unpack();
    }

    @Test
    public void testWithLargeClass() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/LargeClass.pack.gz");
        this.file = File.createTempFile("largeClass", ".jar");
        this.file.deleteOnExit();
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        Archive archive = new Archive(this.in, this.out);
        archive.unpack();
    }

    @Test
    public void testWithPack200() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/pack200.pack.gz");
        this.file = File.createTempFile("p200", ".jar");
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        Archive archive = new Archive(this.in, this.out);
        archive.unpack();
    }

    @Test
    public void testWithPack200E1() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/pack200-e1.pack.gz");
        this.file = File.createTempFile("p200-e1", ".jar");
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        Archive archive = new Archive(this.in, this.out);
        archive.unpack();
    }

    @Test
    public void testWithSql() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");
        this.file = File.createTempFile("sql", ".jar");
        this.file.deleteOnExit();
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        Archive archive = new Archive(this.in, this.out);
        archive.unpack();
        JarFile jarFile = new JarFile(this.file);
        File compareFile = new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI());
        JarFile jarFile2 = new JarFile(compareFile);
        long differenceInJarSizes = Math.abs(compareFile.length() - this.file.length());
        Assertions.assertTrue((differenceInJarSizes < 100L ? 1 : 0) != 0, (String)("Expected jar files to be a similar size, difference was " + differenceInJarSizes + " bytes"));
        Enumeration<JarEntry> entries = jarFile.entries();
        Enumeration<JarEntry> entries2 = jarFile2.entries();
        while (entries.hasMoreElements() && entries2.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            Assertions.assertNotNull((Object)entry);
            String name = entry.getName();
            JarEntry entry2 = entries2.nextElement();
            Assertions.assertNotNull((Object)entry2);
            String name2 = entry2.getName();
            Assertions.assertEquals((Object)name, (Object)name2);
            InputStream ours = jarFile.getInputStream(entry);
            InputStream expected = jarFile2.getInputStream(entry2);
            BufferedReader reader1 = new BufferedReader(new InputStreamReader(ours));
            BufferedReader reader2 = new BufferedReader(new InputStreamReader(expected));
            String line1 = reader1.readLine();
            String line2 = reader2.readLine();
            int i = 1;
            while (line1 != null || line2 != null) {
                Assertions.assertEquals((Object)line2, (Object)line1, (String)("Unpacked class files differ for " + name));
                line1 = reader1.readLine();
                line2 = reader2.readLine();
                ++i;
            }
            reader1.close();
            reader2.close();
        }
    }

    @Test
    public void testWithSqlE1() throws Exception {
        this.in = Archive.class.getResourceAsStream("/pack200/sql-e1.pack.gz");
        this.file = File.createTempFile("sql-e1", ".jar");
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        Archive archive = new Archive(this.in, this.out);
        archive.unpack();
    }
}

