/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz77support;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.lz77support.AbstractLZ77CompressorInputStream;
import org.apache.commons.compress.utils.ByteUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AbstractLZ77CompressorInputStreamTest {
    @Test
    public void cantPrefillAfterDataHasBeenRead() throws IOException {
        byte[] data = new byte[]{1, 2, 3, 4};
        try (TestStream s = new TestStream(new ByteArrayInputStream(data));){
            s.literal(3);
            Assertions.assertEquals((int)1, (int)s.read());
            Assertions.assertThrows(IllegalStateException.class, () -> s.prefill(new byte[]{1, 2, 3}));
        }
    }

    @Test
    public void ifPrefillExceedsWindowSizeTheLastBytesAreUsed() throws IOException {
        byte[] data = new byte[2048];
        data[2046] = 3;
        data[2047] = 4;
        try (TestStream s = new TestStream(new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY));){
            s.prefill(data);
            s.startBackReference(2, 4L);
            byte[] r = new byte[4];
            Assertions.assertEquals((int)4, (int)s.read(r));
            Assertions.assertArrayEquals((byte[])new byte[]{3, 4, 3, 4}, (byte[])r);
        }
    }

    @Test
    public void prefillCanBeUsedForBackReferences() throws IOException {
        byte[] data = new byte[]{1, 2, 3, 4};
        try (TestStream s = new TestStream(new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY));){
            s.prefill(data);
            s.startBackReference(2, 4L);
            byte[] r = new byte[4];
            Assertions.assertEquals((int)4, (int)s.read(r));
            Assertions.assertArrayEquals((byte[])new byte[]{3, 4, 3, 4}, (byte[])r);
        }
    }

    private static class TestStream
    extends AbstractLZ77CompressorInputStream {
        private boolean literal;

        TestStream(InputStream in) {
            super(in, 1024);
        }

        void literal(int len) {
            this.startLiteral(len);
            this.literal = true;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.literal) {
                return this.readLiteral(b, off, len);
            }
            return this.readBackReference(b, off, len);
        }
    }
}

