/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class FramedLZ4CompressorInputStreamTest
extends AbstractTestCase {
    private static byte[] duplicate(byte[] from) {
        byte[] to = Arrays.copyOf(from, 2 * from.length);
        System.arraycopy(from, 0, to, from.length, from.length);
        return to;
    }

    @Test
    public void backreferenceAtStartCausesIOException() {
        this.expectIOException("COMPRESS-490/ArrayIndexOutOfBoundsException1.lz4");
    }

    @Test
    public void backreferenceOfSize0CausesIOException() {
        this.expectIOException("COMPRESS-490/ArithmeticException.lz4");
    }

    @Test
    public void backreferenceWithOffsetTooBigCausesIOException() {
        this.expectIOException("COMPRESS-490/ArrayIndexOutOfBoundsException2.lz4");
    }

    private void expectIOException(String fileName) {
        Assertions.assertThrows(IOException.class, () -> {
            try (InputStream is = Files.newInputStream(FramedLZ4CompressorInputStreamTest.getFile(fileName).toPath(), new OpenOption[0]);
                 FramedLZ4CompressorInputStream in = new FramedLZ4CompressorInputStream(is);){
                IOUtils.toByteArray((InputStream)in);
            }
        });
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = FramedLZ4CompressorInputStreamTest.getFile("bla.tar.lz4");
        byte[] buf = new byte[2];
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             FramedLZ4CompressorInputStream in = new FramedLZ4CompressorInputStream(is);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read(buf));
            Assertions.assertEquals((int)-1, (int)in.read(buf));
        }
    }

    @Test
    public void readBlaDumpLz4() throws IOException {
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream(FramedLZ4CompressorInputStreamTest.newInputStream("bla.dump.lz4"));
             InputStream e = FramedLZ4CompressorInputStreamTest.newInputStream("bla.dump");){
            byte[] expected = IOUtils.toByteArray((InputStream)e);
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void readBlaLz4() throws IOException {
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream(FramedLZ4CompressorInputStreamTest.newInputStream("bla.tar.lz4"));
             InputStream e = FramedLZ4CompressorInputStreamTest.newInputStream("bla.tar");){
            byte[] expected = IOUtils.toByteArray((InputStream)e);
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void readBlaLz4ViaFactory() throws Exception {
        try (CompressorInputStream a = new CompressorStreamFactory().createCompressorInputStream(CompressorStreamFactory.getLZ4Framed(), FramedLZ4CompressorInputStreamTest.newInputStream("bla.tar.lz4"));
             InputStream e = FramedLZ4CompressorInputStreamTest.newInputStream("bla.tar");){
            byte[] expected = IOUtils.toByteArray((InputStream)e);
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void readBlaLz4ViaFactoryAutoDetection() throws Exception {
        try (CompressorInputStream a = new CompressorStreamFactory().createCompressorInputStream((InputStream)new BufferedInputStream(FramedLZ4CompressorInputStreamTest.newInputStream("bla.tar.lz4")));
             InputStream e = FramedLZ4CompressorInputStreamTest.newInputStream("bla.tar");){
            byte[] expected = IOUtils.toByteArray((InputStream)e);
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void readBlaLz4ViaFactoryWithDecompressConcatenated() throws Exception {
        try (CompressorInputStream a = new CompressorStreamFactory().createCompressorInputStream(CompressorStreamFactory.getLZ4Framed(), FramedLZ4CompressorInputStreamTest.newInputStream("bla.tar.lz4"), true);
             InputStream e = FramedLZ4CompressorInputStreamTest.newInputStream("bla.tar");){
            byte[] expected = IOUtils.toByteArray((InputStream)e);
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void readBlaLz4WithDecompressConcatenated() throws IOException {
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream(FramedLZ4CompressorInputStreamTest.newInputStream("bla.tar.lz4"), true);
             InputStream e = FramedLZ4CompressorInputStreamTest.newInputStream("bla.tar");){
            byte[] expected = IOUtils.toByteArray((InputStream)e);
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    private void readDoubledBlaLz4(StreamWrapper wrapper, boolean expectDuplicateOutput) throws Exception {
        byte[] singleInput;
        try (InputStream i = FramedLZ4CompressorInputStreamTest.newInputStream("bla.tar.lz4");){
            singleInput = IOUtils.toByteArray((InputStream)i);
        }
        byte[] input = FramedLZ4CompressorInputStreamTest.duplicate(singleInput);
        try (InputStream a = wrapper.wrap(new ByteArrayInputStream(input));
             InputStream e = FramedLZ4CompressorInputStreamTest.newInputStream("bla.tar");){
            byte[] expected = IOUtils.toByteArray((InputStream)e);
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assertions.assertArrayEquals((byte[])(expectDuplicateOutput ? FramedLZ4CompressorInputStreamTest.duplicate(expected) : expected), (byte[])actual);
        }
    }

    @Test
    public void readDoubledBlaLz4ViaFactoryWithDecompressConcatenatedFalse() throws Exception {
        this.readDoubledBlaLz4(in -> new CompressorStreamFactory().createCompressorInputStream(CompressorStreamFactory.getLZ4Framed(), in, false), false);
    }

    @Test
    public void readDoubledBlaLz4ViaFactoryWithDecompressConcatenatedTrue() throws Exception {
        this.readDoubledBlaLz4(in -> new CompressorStreamFactory().createCompressorInputStream(CompressorStreamFactory.getLZ4Framed(), in, true), true);
    }

    @Test
    public void readDoubledBlaLz4ViaFactoryWithoutExplicitDecompressConcatenated() throws Exception {
        this.readDoubledBlaLz4(in -> new CompressorStreamFactory().createCompressorInputStream(CompressorStreamFactory.getLZ4Framed(), in), false);
    }

    @Test
    public void readDoubledBlaLz4WithDecompressConcatenatedFalse() throws Exception {
        this.readDoubledBlaLz4(in -> new FramedLZ4CompressorInputStream(in, false), false);
    }

    @Test
    public void readDoubledBlaLz4WithDecompressConcatenatedTrue() throws Exception {
        this.readDoubledBlaLz4(in -> new FramedLZ4CompressorInputStream(in, true), true);
    }

    @Test
    public void readDoubledBlaLz4WithoutExplicitDecompressConcatenated() throws Exception {
        this.readDoubledBlaLz4(FramedLZ4CompressorInputStream::new, false);
    }

    @Test
    public void readsUncompressedBlocks() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));){
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assertions.assertArrayEquals((byte[])new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33}, (byte[])actual);
        }
    }

    @Test
    public void readsUncompressedBlocksUsingSingleByteRead() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));){
            int h = a.read();
            Assertions.assertEquals((int)72, (int)h);
        }
    }

    @Test
    public void rejectsBlocksWithoutChecksum() {
        byte[] input = new byte[]{4, 34, 77, 24, 112, 112, 114, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33};
        IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> {
            try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));){
                IOUtils.toByteArray((InputStream)a);
            }
        }, (String)"expected exception");
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"block checksum"));
    }

    @Test
    public void rejectsFileWithBadHeaderChecksum() {
        byte[] input = new byte[]{4, 34, 77, 24, 100, 112, 0};
        IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> {
            FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));
            Throwable throwable = null;
            if (a != null) {
                if (throwable != null) {
                    try {
                        a.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    a.close();
                }
            }
        }, (String)"expected exception");
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"header checksum mismatch"));
    }

    @Test
    public void rejectsFileWithInsufficientContentSize() {
        byte[] input = new byte[]{4, 34, 77, 24, 108, 112};
        IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> {
            FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));
            Throwable throwable = null;
            if (a != null) {
                if (throwable != null) {
                    try {
                        a.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    a.close();
                }
            }
        }, (String)"expected exception");
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"content size"));
    }

    @Test
    public void rejectsFileWithoutBlockSizeByte() {
        byte[] input = new byte[]{4, 34, 77, 24, 100};
        IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> {
            FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));
            Throwable throwable = null;
            if (a != null) {
                if (throwable != null) {
                    try {
                        a.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    a.close();
                }
            }
        }, (String)"expected exception");
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"BD byte"));
    }

    @Test
    public void rejectsFileWithoutFrameDescriptor() {
        byte[] input = new byte[]{4, 34, 77, 24};
        IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> {
            FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));
            Throwable throwable = null;
            if (a != null) {
                if (throwable != null) {
                    try {
                        a.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    a.close();
                }
            }
        }, (String)"expected exception");
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"frame flags"));
    }

    @Test
    public void rejectsFileWithoutHeaderChecksum() {
        byte[] input = new byte[]{4, 34, 77, 24, 100, 112};
        IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> {
            FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));
            Throwable throwable = null;
            if (a != null) {
                if (throwable != null) {
                    try {
                        a.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    a.close();
                }
            }
        }, (String)"expected exception");
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"header checksum"));
    }

    @Test
    public void rejectsFileWithWrongVersion() {
        byte[] input = new byte[]{4, 34, 77, 24, 36};
        IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> {
            FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));
            Throwable throwable = null;
            if (a != null) {
                if (throwable != null) {
                    try {
                        a.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    a.close();
                }
            }
        }, (String)"expected exception");
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"version"));
    }

    @Test
    public void rejectsNonLZ4Stream() {
        Assertions.assertThrows(IOException.class, () -> new FramedLZ4CompressorInputStream(FramedLZ4CompressorInputStreamTest.newInputStream("bla.tar")));
    }

    @Test
    public void rejectsSkippableFrameFollowedByJunk() {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0, 80, 42, 77, 24, 2, 0, 0, 0, 1, 2, 1, 34, 77, 24};
        IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> {
            try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input), true);){
                IOUtils.toByteArray((InputStream)a);
            }
        }, (String)"expected exception");
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"garbage"));
    }

    @Test
    public void rejectsSkippableFrameFollowedByTooFewBytes() {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0, 82, 42, 77, 24, 2, 0, 0, 0, 1, 2, 4};
        IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> {
            try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input), true);){
                IOUtils.toByteArray((InputStream)a);
            }
        }, (String)"expected exception");
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"garbage"));
    }

    @Test
    public void rejectsSkippableFrameWithBadSignaturePrefix() {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0, 96, 42, 77, 24};
        IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> {
            try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input), true);){
                IOUtils.toByteArray((InputStream)a);
                Assertions.fail();
            }
        }, (String)"expected exception");
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"garbage"));
    }

    @Test
    public void rejectsSkippableFrameWithBadSignatureTrailer() {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0, 81, 42, 77, 23};
        IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> {
            try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input), true);){
                IOUtils.toByteArray((InputStream)a);
            }
        }, (String)"expected exception");
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"garbage"));
    }

    @Test
    public void rejectsSkippableFrameWithPrematureEnd() {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0, 80, 42, 77, 24, 2, 0, 0, 0, 1};
        IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> {
            try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input), true);){
                IOUtils.toByteArray((InputStream)a);
            }
        }, (String)"expected exception");
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"Premature end of stream while skipping frame"));
    }

    @Test
    public void rejectsSkippableFrameWithPrematureEndInLengthBytes() {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0, 85, 42, 77, 24, 2, 0, 0};
        IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> {
            try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input), true);){
                IOUtils.toByteArray((InputStream)a);
            }
        }, (String)"expected exception");
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"Premature end of data"));
    }

    @Test
    public void rejectsStreamsWithBadContentChecksum() {
        byte[] input = new byte[]{4, 34, 77, 24, 100, 112, -71, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0, 1, 2, 3, 4};
        IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> {
            try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));){
                IOUtils.toByteArray((InputStream)a);
            }
        }, (String)"expected exception");
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"content checksum mismatch"));
    }

    @Test
    public void rejectsStreamsWithoutContentChecksum() {
        byte[] input = new byte[]{4, 34, 77, 24, 100, 112, -71, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0};
        IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> {
            try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));){
                IOUtils.toByteArray((InputStream)a);
            }
        }, (String)"expected exception");
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"content checksum"));
    }

    @Test
    public void rejectsTrailingBytesAfterValidFrame() {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0, 86, 42, 77};
        IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> {
            try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input), true);){
                IOUtils.toByteArray((InputStream)a);
            }
        }, (String)"expected exception");
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"garbage"));
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = FramedLZ4CompressorInputStreamTest.getFile("bla.tar.lz4");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             FramedLZ4CompressorInputStream in = new FramedLZ4CompressorInputStream(is);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    @Test
    public void skipsOverSkippableFrames() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0, 95, 42, 77, 24, 2, 0, 0, 0, 1, 2, 4, 34, 77, 24, 96, 112, 115, 1, 0, 0, -128, 33, 0, 0, 0, 0};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input), true);){
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assertions.assertArrayEquals((byte[])new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 33}, (byte[])actual);
        }
    }

    @Test
    public void skipsOverTrailingSkippableFrames() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0, 81, 42, 77, 24, 2, 0, 0, 0, 1, 2};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input), true);){
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assertions.assertArrayEquals((byte[])new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33}, (byte[])actual);
        }
    }

    @Test
    public void testMatches() throws IOException {
        Assertions.assertFalse((boolean)FramedLZ4CompressorInputStream.matches((byte[])new byte[10], (int)4));
        byte[] b = new byte[12];
        IOUtils.read((File)FramedLZ4CompressorInputStreamTest.getFile("bla.tar.lz4"), (byte[])b);
        Assertions.assertFalse((boolean)FramedLZ4CompressorInputStream.matches((byte[])b, (int)3));
        Assertions.assertTrue((boolean)FramedLZ4CompressorInputStream.matches((byte[])b, (int)4));
        Assertions.assertTrue((boolean)FramedLZ4CompressorInputStream.matches((byte[])b, (int)5));
    }

    static interface StreamWrapper {
        public InputStream wrap(InputStream var1) throws Exception;
    }
}

