/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FactoryTest
extends AbstractTestCase {
    @Test
    public void blockRoundtripViaFactory() throws Exception {
        this.roundtripViaFactory(CompressorStreamFactory.getLZ4Block());
    }

    @Test
    public void frameRoundtripViaFactory() throws Exception {
        this.roundtripViaFactory(CompressorStreamFactory.getLZ4Framed());
    }

    private void roundtripViaFactory(String format) throws Exception {
        Throwable throwable;
        File input = FactoryTest.getFile("bla.tar");
        long start = System.currentTimeMillis();
        File outputSz = new File(this.dir, input.getName() + "." + format + ".lz4");
        try (OutputStream os = Files.newOutputStream(outputSz.toPath(), new OpenOption[0]);){
            throwable = null;
            try (CompressorOutputStream los = new CompressorStreamFactory().createCompressorOutputStream(format, os);){
                Files.copy(input.toPath(), (OutputStream)los);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        start = System.currentTimeMillis();
        var7_6 = null;
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            throwable = null;
            try (CompressorInputStream sis = new CompressorStreamFactory().createCompressorInputStream(format, Files.newInputStream(outputSz.toPath(), new OpenOption[0]));){
                byte[] expected = IOUtils.toByteArray((InputStream)is);
                byte[] actual = IOUtils.toByteArray((InputStream)sis);
                Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            var7_6 = throwable4;
            throw throwable4;
        }
    }
}

