/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.deflate;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeflateCompressorInputStreamTest {
    @Test
    public void availableShouldReturnNonZero() throws IOException {
        File input = AbstractTestCase.getFile("bla.tar.deflatez");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            DeflateCompressorInputStream in = new DeflateCompressorInputStream(is);
            Assertions.assertTrue((in.available() > 0 ? 1 : 0) != 0);
            in.close();
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = AbstractTestCase.getFile("bla.tar.deflatez");
        byte[] buf = new byte[2];
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            DeflateCompressorInputStream in = new DeflateCompressorInputStream(is);
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read(buf));
            Assertions.assertEquals((int)-1, (int)in.read(buf));
            in.close();
        }
    }

    @Test
    public void shouldBeAbleToSkipAByte() throws IOException {
        File input = AbstractTestCase.getFile("bla.tar.deflatez");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            DeflateCompressorInputStream in = new DeflateCompressorInputStream(is);
            Assertions.assertEquals((long)1L, (long)in.skip(1L));
            in.close();
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = AbstractTestCase.getFile("bla.tar.deflatez");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            DeflateCompressorInputStream in = new DeflateCompressorInputStream(is);
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
            in.close();
        }
    }

    @Test
    public void singleByteReadWorksAsExpected() throws IOException {
        File input = AbstractTestCase.getFile("bla.tar.deflatez");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            DeflateCompressorInputStream in = new DeflateCompressorInputStream(is);
            Assertions.assertEquals((int)116, (int)in.read());
            in.close();
        }
    }
}

