/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.lzma.LZMACompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class LZMATestCase
extends AbstractTestCase {
    @Test
    public void lzmaRoundtrip() throws Exception {
        byte[] uncompressed;
        Throwable throwable;
        File input = LZMATestCase.getFile("test1.xml");
        File compressed = new File(this.dir, "test1.xml.xz");
        try (OutputStream out = Files.newOutputStream(compressed.toPath(), new OpenOption[0]);){
            throwable = null;
            try (CompressorOutputStream cos = new CompressorStreamFactory().createCompressorOutputStream("lzma", out);){
                Files.copy(input.toPath(), (OutputStream)cos);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        byte[] orig = Files.readAllBytes(input.toPath());
        throwable = null;
        try (InputStream is = Files.newInputStream(compressed.toPath(), new OpenOption[0]);
             LZMACompressorInputStream in = new LZMACompressorInputStream(is);){
            uncompressed = IOUtils.toByteArray((InputStream)in);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        Assertions.assertArrayEquals((byte[])orig, (byte[])uncompressed);
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = LZMATestCase.getFile("bla.tar.lzma");
        byte[] buf = new byte[2];
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             LZMACompressorInputStream in = new LZMACompressorInputStream(is);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read(buf));
            Assertions.assertEquals((int)-1, (int)in.read(buf));
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = LZMATestCase.getFile("bla.tar.lzma");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             LZMACompressorInputStream in = new LZMACompressorInputStream(is);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    @Test
    public void testLZMAUnarchive() throws Exception {
        File input = LZMATestCase.getFile("bla.tar.lzma");
        File output = new File(this.dir, "bla.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             LZMACompressorInputStream in = new LZMACompressorInputStream(is);){
            Files.copy((InputStream)in, output.toPath(), new CopyOption[0]);
        }
    }

    @Test
    public void testLZMAUnarchiveWithAutodetection() throws Exception {
        File input = LZMATestCase.getFile("bla.tar.lzma");
        File output = new File(this.dir, "bla.tar");
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(input.toPath(), new OpenOption[0]));
             CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream((InputStream)is);){
            Files.copy((InputStream)in, output.toPath(), new CopyOption[0]);
        }
    }
}

