/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Random;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class FramedSnappyTestCase
extends AbstractTestCase {
    @Test
    public void testDefaultExtraction() throws Exception {
        this.testUnarchive(FramedSnappyCompressorInputStream::new);
    }

    @Test
    public void testDefaultExtractionViaFactory() throws Exception {
        this.testUnarchive(is -> new CompressorStreamFactory().createCompressorInputStream("snappy-framed", is));
    }

    @Test
    public void testDefaultExtractionViaFactoryAutodetection() throws Exception {
        this.testUnarchive(is -> new CompressorStreamFactory().createCompressorInputStream(is));
    }

    @Test
    public void testRoundtrip() throws Exception {
        this.testRoundtrip(FramedSnappyTestCase.getFile("test.txt"));
        this.testRoundtrip(FramedSnappyTestCase.getFile("bla.tar"));
        this.testRoundtrip(FramedSnappyTestCase.getFile("COMPRESS-256.7z"));
    }

    private void testRoundtrip(File input) throws Exception {
        Throwable throwable;
        long start = System.currentTimeMillis();
        File outputSz = new File(this.dir, input.getName() + ".sz");
        try (OutputStream os = Files.newOutputStream(outputSz.toPath(), new OpenOption[0]);){
            throwable = null;
            try (CompressorOutputStream sos = new CompressorStreamFactory().createCompressorOutputStream("snappy-framed", os);){
                Files.copy(input.toPath(), (OutputStream)sos);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        var6_5 = null;
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            throwable = null;
            try (CompressorInputStream sis = new CompressorStreamFactory().createCompressorInputStream("snappy-framed", Files.newInputStream(outputSz.toPath(), new OpenOption[0]));){
                byte[] expected = IOUtils.toByteArray((InputStream)is);
                byte[] actual = IOUtils.toByteArray((InputStream)sis);
                Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            var6_5 = throwable4;
            throw throwable4;
        }
    }

    @Test
    public void testRoundtripWithOneBigWrite() throws Exception {
        Throwable throwable;
        Random r = new Random();
        File input = new File(this.dir, "bigChunkTest");
        try (OutputStream fs = Files.newOutputStream(input.toPath(), new OpenOption[0]);){
            for (int i = 0; i < 131072; ++i) {
                fs.write(r.nextInt(256));
            }
        }
        long start = System.currentTimeMillis();
        File outputSz = new File(this.dir, input.getName() + ".sz");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            throwable = null;
            try (OutputStream os = Files.newOutputStream(outputSz.toPath(), new OpenOption[0]);
                 CompressorOutputStream sos2 = new CompressorStreamFactory().createCompressorOutputStream("snappy-framed", os);){
                byte[] b = IOUtils.toByteArray((InputStream)is);
                sos2.write((int)b[0]);
                sos2.write(b, 1, b.length - 1);
            }
            catch (Throwable sos2) {
                throwable = sos2;
                throw sos2;
            }
        }
        is = Files.newInputStream(input.toPath(), new OpenOption[0]);
        var7_13 = null;
        try {
            throwable = null;
            try (CompressorInputStream sis = new CompressorStreamFactory().createCompressorInputStream("snappy-framed", Files.newInputStream(outputSz.toPath(), new OpenOption[0]));){
                byte[] expected = IOUtils.toByteArray((InputStream)is);
                byte[] actual = IOUtils.toByteArray((InputStream)sis);
                Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var7_13 = throwable3;
            throw throwable3;
        }
        finally {
            if (is != null) {
                if (var7_13 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable4) {
                        var7_13.addSuppressed(throwable4);
                    }
                } else {
                    is.close();
                }
            }
        }
    }

    private void testUnarchive(AbstractTestCase.StreamWrapper<CompressorInputStream> wrapper) throws Exception {
        File input = FramedSnappyTestCase.getFile("bla.tar.sz");
        File output = new File(this.dir, "bla.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             CompressorInputStream in = wrapper.wrap(new BufferedInputStream(is));){
            Files.copy((InputStream)in, output.toPath(), new CopyOption[0]);
            Assertions.assertEquals((long)995L, (long)in.getBytesRead());
        }
        File original = FramedSnappyTestCase.getFile("bla.tar");
        try (InputStream written = Files.newInputStream(output.toPath(), new OpenOption[0]);
             InputStream orig = Files.newInputStream(original.toPath(), new OpenOption[0]);){
            Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)written), (byte[])IOUtils.toByteArray((InputStream)orig));
        }
    }
}

