/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.compress.archivers.zip.NioZipEncoding;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NioZipEncodingTest {
    private static final String UMLAUTS = "\u00e4\u00f6\u00fc";
    private static final String RAINBOW_EMOJI = "\ud83c\udf08";

    @Test
    public void partialSurrogatePair() {
        NioZipEncoding e = new NioZipEncoding(StandardCharsets.US_ASCII, false);
        ByteBuffer bb = e.encode("\ud83c");
        int off = bb.arrayOffset();
        byte[] result = Arrays.copyOfRange(bb.array(), off, off + bb.limit() - bb.position());
        Assertions.assertEquals((int)0, (int)result.length);
    }

    @Test
    public void rainbowEmojiToSurrogatePairUTF16() {
        NioZipEncoding e = new NioZipEncoding(StandardCharsets.UTF_16BE, false);
        ByteBuffer bb = e.encode(RAINBOW_EMOJI);
        int off = bb.arrayOffset();
        byte[] result = Arrays.copyOfRange(bb.array(), off, off + bb.limit() - bb.position());
        Assertions.assertArrayEquals((byte[])RAINBOW_EMOJI.getBytes(StandardCharsets.UTF_16BE), (byte[])result);
    }

    @Test
    public void umlautToISO88591() {
        NioZipEncoding e = new NioZipEncoding(StandardCharsets.ISO_8859_1, true);
        ByteBuffer bb = e.encode(UMLAUTS);
        int off = bb.arrayOffset();
        byte[] result = Arrays.copyOfRange(bb.array(), off, off + bb.limit() - bb.position());
        Assertions.assertArrayEquals((byte[])UMLAUTS.getBytes(StandardCharsets.ISO_8859_1), (byte[])result);
    }

    @Test
    public void umlautToUTF16BE() {
        NioZipEncoding e = new NioZipEncoding(StandardCharsets.UTF_16BE, false);
        ByteBuffer bb = e.encode(UMLAUTS);
        int off = bb.arrayOffset();
        byte[] result = Arrays.copyOfRange(bb.array(), off, off + bb.limit() - bb.position());
        Assertions.assertArrayEquals((byte[])UMLAUTS.getBytes(StandardCharsets.UTF_16BE), (byte[])result);
    }

    @Test
    public void umlautToUTF8() {
        NioZipEncoding e = new NioZipEncoding(StandardCharsets.UTF_8, true);
        ByteBuffer bb = e.encode(UMLAUTS);
        int off = bb.arrayOffset();
        byte[] result = Arrays.copyOfRange(bb.array(), off, off + bb.limit() - bb.position());
        Assertions.assertArrayEquals((byte[])UMLAUTS.getBytes(StandardCharsets.UTF_8), (byte[])result);
    }

    @Test
    public void unmappableRainbowEmoji() {
        NioZipEncoding e = new NioZipEncoding(StandardCharsets.US_ASCII, false);
        ByteBuffer bb = e.encode(RAINBOW_EMOJI);
        int off = bb.arrayOffset();
        byte[] result = Arrays.copyOfRange(bb.array(), off, off + bb.limit() - bb.position());
        Assertions.assertEquals((Object)"%UD83C%UDF08", (Object)new String(result, StandardCharsets.US_ASCII));
    }

    @Test
    public void unmappableUmlauts() {
        NioZipEncoding e = new NioZipEncoding(StandardCharsets.US_ASCII, false);
        ByteBuffer bb = e.encode(UMLAUTS);
        int off = bb.arrayOffset();
        byte[] result = Arrays.copyOfRange(bb.array(), off, off + bb.limit() - bb.position());
        Assertions.assertEquals((Object)"%U00E4%U00F6%U00FC", (Object)new String(result, StandardCharsets.US_ASCII));
    }
}

