/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarFile;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TarFileTest
extends AbstractTestCase {
    @Test
    public void archiveWithTrailer() throws IOException {
        try (SeekableByteChannel channel = Files.newByteChannel(TarFileTest.getPath("archive_with_trailer.tar"), new OpenOption[0]);
             TarFile tarfile = new TarFile(channel, 10240, 512, null, false);){
            String tarAppendix = "Hello, world!\n";
            ByteBuffer buffer = ByteBuffer.allocate("Hello, world!\n".length());
            channel.read(buffer);
            Assertions.assertEquals((Object)"Hello, world!\n", (Object)new String(buffer.array()));
        }
    }

    private void datePriorToEpoch(String archive) throws Exception {
        try (TarFile tarFile = new TarFile(TarFileTest.getPath(archive));){
            TarArchiveEntry entry = (TarArchiveEntry)tarFile.getEntries().get(0);
            Assertions.assertEquals((Object)"foo", (Object)entry.getName());
            Assertions.assertEquals((byte)48, (byte)entry.getLinkFlag());
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            cal.set(1969, 11, 31, 23, 59, 59);
            cal.set(14, 0);
            Assertions.assertEquals((Object)cal.getTime(), (Object)entry.getLastModifiedDate());
            Assertions.assertTrue((boolean)entry.isCheckSumOK());
        }
    }

    @Test
    public void datePriorToEpochInGNUFormat() throws Exception {
        this.datePriorToEpoch("preepoch-star.tar");
    }

    @Test
    public void datePriorToEpochInPAXFormat() throws Exception {
        this.datePriorToEpoch("preepoch-posix.tar");
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        byte[] buf = new byte[2];
        try (TarFile tarFile = new TarFile(TarFileTest.getPath("bla.tar"));
             InputStream input = tarFile.getInputStream((TarArchiveEntry)tarFile.getEntries().get(0));){
            IOUtils.toByteArray((InputStream)input);
            Assertions.assertEquals((int)-1, (int)input.read(buf));
            Assertions.assertEquals((int)-1, (int)input.read(buf));
        }
    }

    @Test
    public void readsArchiveCompletely_COMPRESS245() {
        try {
            Path tempTar = this.resultDir.toPath().resolve("COMPRESS-245.tar");
            try (GZIPInputStream gin = new GZIPInputStream(Files.newInputStream(TarFileTest.getPath("COMPRESS-245.tar.gz"), new OpenOption[0]));){
                Files.copy(gin, tempTar, new CopyOption[0]);
            }
            var3_4 = null;
            try (TarFile tarFile = new TarFile(tempTar);){
                Assertions.assertEquals((int)31, (int)tarFile.getEntries().size());
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
        }
        catch (IOException e) {
            Assertions.fail((String)("COMPRESS-245: " + e.getMessage()));
        }
    }

    @Test
    public void rejectsArchivesWithNegativeSizes() throws Exception {
        Assertions.assertThrows(IOException.class, () -> new TarFile(TarFileTest.getFile("COMPRESS-569.tar")));
    }

    @Test
    public void shouldReadBigGid() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);){
            tos.setBigNumberMode(2);
            TarArchiveEntry t = new TarArchiveEntry("name");
            t.setGroupId(0xFFFFFFFEL);
            t.setSize(1L);
            tos.putArchiveEntry((ArchiveEntry)t);
            tos.write(30);
            tos.closeArchiveEntry();
        }
        byte[] data = bos.toByteArray();
        try (TarFile tarFile = new TarFile(data);){
            List entries = tarFile.getEntries();
            Assertions.assertEquals((long)0xFFFFFFFEL, (long)((TarArchiveEntry)entries.get(0)).getLongGroupId());
        }
    }

    @Test
    public void shouldReadGNULongNameEntryWithWrongName() throws Exception {
        try (TarFile tarFile = new TarFile(TarFileTest.getPath("COMPRESS-324.tar"));){
            List entries = tarFile.getEntries();
            Assertions.assertEquals((Object)"1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890.txt", (Object)((TarArchiveEntry)entries.get(0)).getName());
        }
    }

    @Test
    public void shouldThrowAnExceptionOnTruncatedEntries() throws Exception {
        File dir = TarFileTest.mkdir("COMPRESS-279");
        Assertions.assertThrows(IOException.class, () -> new TarFile(TarFileTest.getPath("COMPRESS-279.tar")));
        TarFileTest.rmdir(dir);
    }

    @Test
    public void shouldUseSpecifiedEncodingWhenReadingGNULongNames() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String encoding = "UTF-16";
        String name = "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\u00e4";
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, "UTF-16");){
            tos.setLongFileMode(2);
            TarArchiveEntry t = new TarArchiveEntry("12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\u00e4");
            t.setSize(1L);
            tos.putArchiveEntry((ArchiveEntry)t);
            tos.write(30);
            tos.closeArchiveEntry();
        }
        byte[] data = bos.toByteArray();
        try (TarFile tarFile = new TarFile(data, "UTF-16");){
            List entries = tarFile.getEntries();
            Assertions.assertEquals((int)1, (int)entries.size());
            Assertions.assertEquals((Object)"12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\u00e4", (Object)((TarArchiveEntry)entries.get(0)).getName());
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        try (TarFile tarFile = new TarFile(TarFileTest.getPath("bla.tar"));
             InputStream input = tarFile.getInputStream((TarArchiveEntry)tarFile.getEntries().get(0));){
            IOUtils.toByteArray((InputStream)input);
            Assertions.assertEquals((int)-1, (int)input.read());
            Assertions.assertEquals((int)-1, (int)input.read());
        }
    }

    @Test
    public void skipsDevNumbersWhenEntryIsNoDevice() throws Exception {
        try (TarFile tarFile = new TarFile(TarFileTest.getPath("COMPRESS-417.tar"));){
            List entries = tarFile.getEntries();
            Assertions.assertEquals((int)2, (int)entries.size());
            Assertions.assertEquals((Object)"test1.xml", (Object)((TarArchiveEntry)entries.get(0)).getName());
            Assertions.assertEquals((byte)48, (byte)((TarArchiveEntry)entries.get(0)).getLinkFlag());
            Assertions.assertEquals((Object)"test2.xml", (Object)((TarArchiveEntry)entries.get(1)).getName());
            Assertions.assertEquals((byte)48, (byte)((TarArchiveEntry)entries.get(1)).getLinkFlag());
        }
    }

    @Test
    public void survivesBlankLinesInPaxHeader() throws Exception {
        try (TarFile tarFile = new TarFile(TarFileTest.getPath("COMPRESS-355.tar"));){
            List entries = tarFile.getEntries();
            Assertions.assertEquals((int)1, (int)entries.size());
            Assertions.assertEquals((Object)"package/package.json", (Object)((TarArchiveEntry)entries.get(0)).getName());
            Assertions.assertEquals((byte)48, (byte)((TarArchiveEntry)entries.get(0)).getLinkFlag());
        }
    }

    @Test
    public void survivesPaxHeaderWithNameEndingInSlash() throws Exception {
        try (TarFile tarFile = new TarFile(TarFileTest.getPath("COMPRESS-356.tar"));){
            List entries = tarFile.getEntries();
            Assertions.assertEquals((int)1, (int)entries.size());
            Assertions.assertEquals((Object)"package/package.json", (Object)((TarArchiveEntry)entries.get(0)).getName());
            Assertions.assertEquals((byte)48, (byte)((TarArchiveEntry)entries.get(0)).getLinkFlag());
        }
    }

    @Test
    public void testCompress197() throws IOException {
        TarFile tarFile = new TarFile(TarFileTest.getPath("COMPRESS-197.tar"));
        Throwable throwable = null;
        if (tarFile != null) {
            if (throwable != null) {
                try {
                    tarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                tarFile.close();
            }
        }
    }

    @Test
    public void testCompress558() throws IOException {
        String folderName = "apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/";
        String consumerJavaName = "apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Consumer.java";
        String producerJavaName = "apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Producer.java";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);){
            tos.setLongFileMode(2);
            TarArchiveEntry rootfolder = new TarArchiveEntry("apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/");
            tos.putArchiveEntry((ArchiveEntry)rootfolder);
            TarArchiveEntry consumerJava = new TarArchiveEntry("apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Consumer.java");
            tos.putArchiveEntry((ArchiveEntry)consumerJava);
            TarArchiveEntry producerJava = new TarArchiveEntry("apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Producer.java");
            tos.putArchiveEntry((ArchiveEntry)producerJava);
            tos.closeArchiveEntry();
        }
        byte[] data = bos.toByteArray();
        try (TarFile tarFile = new TarFile(data);){
            List entries = tarFile.getEntries();
            Assertions.assertEquals((Object)"apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/", (Object)((TarArchiveEntry)entries.get(0)).getName());
            Assertions.assertEquals((byte)53, (byte)((TarArchiveEntry)entries.get(0)).getLinkFlag());
            Assertions.assertEquals((Object)"apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Consumer.java", (Object)((TarArchiveEntry)entries.get(1)).getName());
            Assertions.assertEquals((byte)48, (byte)((TarArchiveEntry)entries.get(1)).getLinkFlag());
            Assertions.assertEquals((Object)"apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Producer.java", (Object)((TarArchiveEntry)entries.get(2)).getName());
            Assertions.assertEquals((byte)48, (byte)((TarArchiveEntry)entries.get(2)).getLinkFlag());
        }
    }

    @Test
    public void testDirectoryWithLongNameEndsWithSlash() throws IOException {
        String rootPath = this.dir.getAbsolutePath();
        String dirDirectory = "COMPRESS-509";
        int count = 100;
        File root = new File(rootPath + "/" + "COMPRESS-509");
        root.mkdirs();
        for (int i = 1; i < 100; ++i) {
            StringBuilder subDirBuilder = new StringBuilder();
            for (int j = 0; j < i; ++j) {
                subDirBuilder.append("a");
            }
            String subDir = subDirBuilder.toString();
            File dir = new File(rootPath + "/" + "COMPRESS-509", "/" + subDir);
            dir.mkdir();
            String fileName = "/COMPRESS-509/" + subDir;
            File tarF = new File(rootPath + "/tar" + i + ".tar");
            try (OutputStream dest = Files.newOutputStream(tarF.toPath(), new OpenOption[0]);
                 TarArchiveOutputStream out = new TarArchiveOutputStream((OutputStream)new BufferedOutputStream(dest));){
                out.setBigNumberMode(2);
                out.setLongFileMode(2);
                File file = new File(rootPath, fileName);
                TarArchiveEntry entry = new TarArchiveEntry(file);
                entry.setName(fileName);
                out.putArchiveEntry((ArchiveEntry)entry);
                out.closeArchiveEntry();
                out.flush();
            }
            var12_13 = null;
            try (TarFile tarFile = new TarFile(tarF);){
                for (TarArchiveEntry entry : tarFile.getEntries()) {
                    Assertions.assertTrue((boolean)entry.getName().endsWith("/"), (String)("Entry name: " + entry.getName()));
                }
                continue;
            }
            catch (Throwable throwable) {
                var12_13 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void testParseTarTruncatedInContent() {
        Assertions.assertThrows(IOException.class, () -> new TarFile(TarFileTest.getPath("COMPRESS-544_truncated_in_content.tar")));
    }

    @Test
    public void testParseTarTruncatedInPadding() {
        Assertions.assertThrows(IOException.class, () -> new TarFile(TarFileTest.getPath("COMPRESS-544_truncated_in_padding.tar")));
    }

    @Test
    public void testParseTarWithNonNumberPaxHeaders() {
        Assertions.assertThrows(IOException.class, () -> new TarFile(TarFileTest.getPath("COMPRESS-529.tar")));
    }

    @Test
    public void testParseTarWithSpecialPaxHeaders() {
        Assertions.assertThrows(IOException.class, () -> new TarFile(TarFileTest.getPath("COMPRESS-530.tar")));
    }

    @Test
    public void testThrowException() {
        Assertions.assertThrows(IOException.class, () -> new TarFile(TarFileTest.getPath("COMPRESS-553.tar")));
    }

    @Test
    public void testThrowExceptionWithNullEntry() {
        Assertions.assertThrows(IOException.class, () -> new TarFile(TarFileTest.getPath("COMPRESS-554.tar")));
    }

    @Test
    public void workaroundForBrokenTimeHeader() throws IOException {
        try (TarFile tarFile = new TarFile(TarFileTest.getPath("simple-aix-native-tar.tar"));){
            List entries = tarFile.getEntries();
            Assertions.assertEquals((int)3, (int)entries.size());
            TarArchiveEntry entry = (TarArchiveEntry)entries.get(1);
            Assertions.assertEquals((Object)"sample/link-to-txt-file.lnk", (Object)entry.getName());
            Assertions.assertEquals((byte)50, (byte)entry.getLinkFlag());
            Assertions.assertEquals((Object)new Date(0L), (Object)entry.getLastModifiedDate());
            Assertions.assertTrue((boolean)entry.isSymbolicLink());
            Assertions.assertTrue((boolean)entry.isCheckSumOK());
        }
    }
}

