/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.util.NoSuchElementException;
import org.apache.commons.compress.utils.ServiceLoaderIterator;
import org.junit.Assert;
import org.junit.Test;

public class ServiceLoaderIteratorTest {
    @Test(expected=NoSuchElementException.class)
    public void testNextThrowsNoSuchElementException() {
        Class<String> clasz = String.class;
        ServiceLoaderIterator serviceLoaderIterator = new ServiceLoaderIterator(clasz);
        serviceLoaderIterator.next();
    }

    @Test
    public void testHasNextReturnsFalse() {
        Class<Object> clasz = Object.class;
        ServiceLoaderIterator serviceLoaderIterator = new ServiceLoaderIterator(clasz);
        boolean result = serviceLoaderIterator.hasNext();
        Assert.assertFalse((boolean)result);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveThrowsUnsupportedOperationException() {
        Class<Integer> clasz = Integer.class;
        ServiceLoaderIterator serviceLoaderIterator = new ServiceLoaderIterator(clasz);
        serviceLoaderIterator.remove();
    }
}

