/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.commons.compress.utils.ChecksumVerifyingInputStream;
import org.junit.Assert;
import org.junit.Test;

public class ChecksumVerifyingInputStreamTest {
    @Test(expected=IOException.class)
    public void testReadTakingByteArrayThrowsIOException() throws IOException {
        Adler32 adler32 = new Adler32();
        byte[] byteArray = new byte[3];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        ChecksumVerifyingInputStream checksumVerifyingInputStream = new ChecksumVerifyingInputStream((Checksum)adler32, (InputStream)byteArrayInputStream, -1859L, -68L);
        checksumVerifyingInputStream.read(byteArray);
    }

    @Test(expected=IOException.class)
    public void testReadTakingNoArgumentsThrowsIOException() throws IOException {
        CRC32 cRC32_ = new CRC32();
        byte[] byteArray = new byte[9];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        ChecksumVerifyingInputStream checksumVerifyingInputStream = new ChecksumVerifyingInputStream((Checksum)cRC32_, (InputStream)byteArrayInputStream, 1L, 1L);
        checksumVerifyingInputStream.read();
    }

    @Test
    public void testSkip() throws IOException {
        CRC32 cRC32_ = new CRC32();
        byte[] byteArray = new byte[4];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        ChecksumVerifyingInputStream checksumVerifyingInputStream = new ChecksumVerifyingInputStream((Checksum)cRC32_, (InputStream)byteArrayInputStream, 33L, 2303L);
        int intOne = checksumVerifyingInputStream.read(byteArray);
        long skipReturnValue = checksumVerifyingInputStream.skip(1L);
        Assert.assertEquals((long)558161692L, (long)cRC32_.getValue());
        Assert.assertEquals((long)0L, (long)byteArrayInputStream.available());
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0}, (byte[])byteArray);
        Assert.assertEquals((long)0L, (long)skipReturnValue);
    }
}

