/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import org.apache.commons.compress.utils.BitInputStream;
import org.junit.Assert;
import org.junit.Test;

public class BitInputStreamTest {
    @Test(expected=IOException.class)
    public void shouldNotAllowReadingOfANegativeAmountOfBits() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            bis.readBits(-1);
        }
    }

    @Test(expected=IOException.class)
    public void shouldNotAllowReadingOfMoreThan63BitsAtATime() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            bis.readBits(64);
        }
    }

    @Test
    public void testReading24BitsInLittleEndian() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assert.assertEquals((long)82168L, (long)bis.readBits(24));
        }
    }

    @Test
    public void testReading24BitsInBigEndian() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.BIG_ENDIAN);){
            Assert.assertEquals((long)16269313L, (long)bis.readBits(24));
        }
    }

    @Test
    public void testReading17BitsInLittleEndian() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assert.assertEquals((long)82168L, (long)bis.readBits(17));
        }
    }

    @Test
    public void testReading17BitsInBigEndian() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.BIG_ENDIAN);){
            Assert.assertEquals((long)127104L, (long)bis.readBits(17));
        }
    }

    @Test
    public void testReading30BitsInLittleEndian() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assert.assertEquals((long)788611320L, (long)bis.readBits(30));
        }
    }

    @Test
    public void testReading30BitsInBigEndian() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.BIG_ENDIAN);){
            Assert.assertEquals((long)1041236043L, (long)bis.readBits(30));
        }
    }

    @Test
    public void testReading31BitsInLittleEndian() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assert.assertEquals((long)788611320L, (long)bis.readBits(31));
        }
    }

    @Test
    public void testReading31BitsInBigEndian() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.BIG_ENDIAN);){
            Assert.assertEquals((long)2082472087L, (long)bis.readBits(31));
        }
    }

    @Test
    public void testClearBitCache() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assert.assertEquals((long)8L, (long)bis.readBits(4));
            bis.clearBitCache();
            Assert.assertEquals((long)0L, (long)bis.readBits(1));
        }
    }

    @Test
    public void testEOF() throws IOException {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assert.assertEquals((long)788611320L, (long)bis.readBits(30));
            Assert.assertEquals((long)-1L, (long)bis.readBits(3));
        }
    }

    @Test
    public void littleEndianWithOverflow() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{87, 45, 66, 15, 90, 29, 88, 61, 33, 74});
        try (BitInputStream bin = new BitInputStream((InputStream)in, ByteOrder.LITTLE_ENDIAN);){
            Assert.assertEquals((long)23L, (long)bin.readBits(5));
            Assert.assertEquals((long)714595605644185962L, (long)bin.readBits(63));
            Assert.assertEquals((long)1186L, (long)bin.readBits(12));
            Assert.assertEquals((long)-1L, (long)bin.readBits(1));
        }
    }

    @Test
    public void bigEndianWithOverflow() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{87, 45, 66, 15, 90, 29, 88, 61, 33, 74});
        try (BitInputStream bin = new BitInputStream((InputStream)in, ByteOrder.BIG_ENDIAN);){
            Assert.assertEquals((long)10L, (long)bin.readBits(5));
            Assert.assertEquals((long)8274274654740644818L, (long)bin.readBits(63));
            Assert.assertEquals((long)330L, (long)bin.readBits(12));
            Assert.assertEquals((long)-1L, (long)bin.readBits(1));
        }
    }

    @Test
    public void alignWithByteBoundaryWhenAtBoundary() throws Exception {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assert.assertEquals((long)248L, (long)bis.readBits(8));
            bis.alignWithByteBoundary();
            Assert.assertEquals((long)0L, (long)bis.readBits(4));
        }
    }

    @Test
    public void alignWithByteBoundaryWhenNotAtBoundary() throws Exception {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assert.assertEquals((long)8L, (long)bis.readBits(4));
            Assert.assertEquals((long)4L, (long)bis.bitsCached());
            bis.alignWithByteBoundary();
            Assert.assertEquals((long)0L, (long)bis.bitsCached());
            Assert.assertEquals((long)0L, (long)bis.readBits(4));
        }
    }

    @Test
    public void availableWithoutCache() throws Exception {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assert.assertEquals((long)32L, (long)bis.bitsAvailable());
        }
    }

    @Test
    public void availableWithCache() throws Exception {
        try (BitInputStream bis = new BitInputStream((InputStream)this.getStream(), ByteOrder.LITTLE_ENDIAN);){
            Assert.assertEquals((long)8L, (long)bis.readBits(4));
            Assert.assertEquals((long)28L, (long)bis.bitsAvailable());
        }
    }

    private ByteArrayInputStream getStream() {
        return new ByteArrayInputStream(new byte[]{-8, 64, 1, 47});
    }
}

