/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.tests.bytecode;

import junit.framework.TestCase;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPDouble;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPFloat;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPInteger;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPLong;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPMember;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPString;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPUTF8;
import org.apache.commons.compress.harmony.unpack200.bytecode.SourceFileAttribute;

public class ClassFileEntryTest
extends TestCase {
    public void testUTF8() {
        CPUTF8 u1 = new CPUTF8(new String("thing"), 1);
        CPUTF8 u2 = new CPUTF8(new String("thing"), 1);
        CPUTF8 u3 = new CPUTF8(new String("otherthing"), 2);
        this.checkEquality(u1, u2, "thing", u3);
    }

    private void checkEquality(Object equal1, Object equal2, String toString, Object unequal) {
        ClassFileEntryTest.assertEquals((Object)equal1, (Object)equal2);
        ClassFileEntryTest.assertEquals((int)equal1.hashCode(), (int)equal2.hashCode());
        ClassFileEntryTest.assertTrue((equal1.toString().indexOf(toString) >= 0 ? 1 : 0) != 0);
        ClassFileEntryTest.assertFalse((boolean)equal1.equals(unequal));
        ClassFileEntryTest.assertFalse((boolean)equal2.equals(unequal));
        ClassFileEntryTest.assertFalse((boolean)unequal.equals(equal1));
        ClassFileEntryTest.assertFalse((boolean)unequal.equals(equal2));
    }

    public void testSourceAttribute() {
        SourceFileAttribute sfa1 = new SourceFileAttribute(new CPUTF8(new String("Thing.java"), 1));
        SourceFileAttribute sfa2 = new SourceFileAttribute(new CPUTF8(new String("Thing.java"), 1));
        SourceFileAttribute sfa3 = new SourceFileAttribute(new CPUTF8(new String("OtherThing.java"), 2));
        this.checkEquality(sfa1, sfa2, "Thing.java", sfa3);
    }

    public void testCPInteger() {
        CPInteger cp1 = new CPInteger(new Integer(3), 3);
        CPInteger cp2 = new CPInteger(new Integer(3), 3);
        CPInteger cp3 = new CPInteger(new Integer(5), 5);
        this.checkEquality(cp1, cp2, "3", cp3);
    }

    public void testCPLong() {
        CPLong cp1 = new CPLong(new Long(3L), 3);
        CPLong cp2 = new CPLong(new Long(3L), 3);
        CPLong cp3 = new CPLong(new Long(5L), 5);
        this.checkEquality(cp1, cp2, "3", cp3);
    }

    public void testCPDouble() {
        CPDouble cp1 = new CPDouble(new Double(3.0), 3);
        CPDouble cp2 = new CPDouble(new Double(3.0), 3);
        CPDouble cp3 = new CPDouble(new Double(5.0), 5);
        this.checkEquality(cp1, cp2, "3", cp3);
    }

    public void testCPFloat() {
        CPFloat cp1 = new CPFloat(new Float(3.0f), 3);
        CPFloat cp2 = new CPFloat(new Float(3.0f), 3);
        CPFloat cp3 = new CPFloat(new Float(5.0f), 5);
        this.checkEquality(cp1, cp2, "3", cp3);
    }

    public void testCPString() {
        CPString cp1 = new CPString(new CPUTF8(new String("3"), 3), 3);
        CPString cp2 = new CPString(new CPUTF8(new String("3"), 3), 3);
        CPString cp3 = new CPString(new CPUTF8(new String("5"), 5), 5);
        this.checkEquality(cp1, cp2, "3", cp3);
    }

    public void testCPField() {
        CPMember cp1 = new CPMember(new CPUTF8("Name", 3), new CPUTF8("I", 4), 0L, null);
        CPMember cp2 = new CPMember(new CPUTF8("Name", 3), new CPUTF8("I", 4), 0L, null);
        CPMember cp3 = new CPMember(new CPUTF8("Name", 3), new CPUTF8("Z", 5), 0L, null);
        CPMember cp4 = new CPMember(new CPUTF8("GName", 6), new CPUTF8("I", 4), 0L, null);
        this.checkEquality(cp1, cp2, "Name", cp3);
        this.checkEquality(cp1, cp2, "I", cp4);
    }
}

