/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.tests;

import junit.framework.TestCase;
import org.apache.commons.compress.harmony.unpack200.IMatcher;
import org.apache.commons.compress.harmony.unpack200.SegmentUtils;

public class SegmentUtilsTest
extends TestCase {
    public static final IMatcher even = new MultipleMatches(2);
    public static final IMatcher five = new MultipleMatches(5);

    public void testCountArgs() {
        SegmentUtilsTest.assertEquals((int)0, (int)SegmentUtils.countArgs((String)"()V"));
        SegmentUtilsTest.assertEquals((int)1, (int)SegmentUtils.countArgs((String)"(D)V"));
        SegmentUtilsTest.assertEquals((int)1, (int)SegmentUtils.countArgs((String)"([D)V"));
        SegmentUtilsTest.assertEquals((int)1, (int)SegmentUtils.countArgs((String)"([[D)V"));
        SegmentUtilsTest.assertEquals((int)2, (int)SegmentUtils.countArgs((String)"(DD)V"));
        SegmentUtilsTest.assertEquals((int)3, (int)SegmentUtils.countArgs((String)"(DDD)V"));
        SegmentUtilsTest.assertEquals((int)2, (int)SegmentUtils.countArgs((String)"(Lblah/blah;D)V"));
        SegmentUtilsTest.assertEquals((int)3, (int)SegmentUtils.countArgs((String)"(Lblah/blah;DLbLah;)V"));
    }

    public void testCountInvokeInterfaceArgs() {
        SegmentUtilsTest.assertEquals((int)1, (int)SegmentUtils.countInvokeInterfaceArgs((String)"(Z)V"));
        SegmentUtilsTest.assertEquals((int)2, (int)SegmentUtils.countInvokeInterfaceArgs((String)"(D)V"));
        SegmentUtilsTest.assertEquals((int)2, (int)SegmentUtils.countInvokeInterfaceArgs((String)"(J)V"));
        SegmentUtilsTest.assertEquals((int)1, (int)SegmentUtils.countInvokeInterfaceArgs((String)"([D)V"));
        SegmentUtilsTest.assertEquals((int)1, (int)SegmentUtils.countInvokeInterfaceArgs((String)"([[D)V"));
        SegmentUtilsTest.assertEquals((int)4, (int)SegmentUtils.countInvokeInterfaceArgs((String)"(DD)V"));
        SegmentUtilsTest.assertEquals((int)3, (int)SegmentUtils.countInvokeInterfaceArgs((String)"(Lblah/blah;D)V"));
        SegmentUtilsTest.assertEquals((int)4, (int)SegmentUtils.countInvokeInterfaceArgs((String)"(Lblah/blah;DLbLah;)V"));
        SegmentUtilsTest.assertEquals((int)4, (int)SegmentUtils.countInvokeInterfaceArgs((String)"([Lblah/blah;DLbLah;)V"));
    }

    public void testMatches() {
        long[] oneToTen = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L};
        SegmentUtilsTest.assertEquals((int)6, (int)SegmentUtils.countMatches((long[][])new long[][]{oneToTen, {5L, 6L, 7L}}, (IMatcher)even));
        SegmentUtilsTest.assertEquals((int)5, (int)SegmentUtils.countMatches((long[][])new long[][]{oneToTen}, (IMatcher)even));
        SegmentUtilsTest.assertEquals((int)5, (int)SegmentUtils.countMatches((long[])oneToTen, (IMatcher)even));
        SegmentUtilsTest.assertEquals((int)3, (int)SegmentUtils.countMatches((long[][])new long[][]{oneToTen, {5L, 6L, 7L}}, (IMatcher)five));
        SegmentUtilsTest.assertEquals((int)2, (int)SegmentUtils.countMatches((long[][])new long[][]{oneToTen}, (IMatcher)five));
        SegmentUtilsTest.assertEquals((int)2, (int)SegmentUtils.countMatches((long[])oneToTen, (IMatcher)five));
    }

    private static class MultipleMatches
    implements IMatcher {
        private final int divisor;

        public MultipleMatches(int divisor) {
            this.divisor = divisor;
        }

        public boolean matches(long value) {
            return value % (long)this.divisor == 0L;
        }
    }
}

