/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.tests;

import junit.framework.TestCase;
import org.apache.commons.compress.harmony.unpack200.CpBands;
import org.apache.commons.compress.harmony.unpack200.Segment;
import org.apache.commons.compress.harmony.unpack200.SegmentConstantPool;

public class SegmentConstantPoolTest
extends TestCase {
    String[] testClassArray = new String[]{"Object", "Object", "java/lang/String", "java/lang/String", "Object", "Other"};
    String[] testMethodArray = new String[]{"<init>()", "clone()", "equals()", "<init>", "isNull()", "Other"};

    public void testMatchSpecificPoolEntryIndex_SingleArray() throws Exception {
        MockSegmentConstantPool mockInstance = new MockSegmentConstantPool();
        SegmentConstantPoolTest.assertEquals((int)0, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, "Object", 0));
        SegmentConstantPoolTest.assertEquals((int)1, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, "Object", 1));
        SegmentConstantPoolTest.assertEquals((int)2, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, "java/lang/String", 0));
        SegmentConstantPoolTest.assertEquals((int)3, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, "java/lang/String", 1));
        SegmentConstantPoolTest.assertEquals((int)4, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, "Object", 2));
        SegmentConstantPoolTest.assertEquals((int)5, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, "Other", 0));
        SegmentConstantPoolTest.assertEquals((int)-1, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, "NotThere", 0));
        SegmentConstantPoolTest.assertEquals((int)-1, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, "java/lang/String", 2));
    }

    public void testMatchSpecificPoolEntryIndex_DoubleArray() throws Exception {
        MockSegmentConstantPool mockInstance = new MockSegmentConstantPool();
        SegmentConstantPoolTest.assertEquals((int)0, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, this.testMethodArray, "Object", "^<init>.*", 0));
        SegmentConstantPoolTest.assertEquals((int)2, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, this.testMethodArray, "java/lang/String", ".*", 0));
        SegmentConstantPoolTest.assertEquals((int)3, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, this.testMethodArray, "java/lang/String", "^<init>.*", 0));
        SegmentConstantPoolTest.assertEquals((int)5, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, this.testMethodArray, "Other", ".*", 0));
        SegmentConstantPoolTest.assertEquals((int)-1, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, this.testMethodArray, "NotThere", "^<init>.*", 0));
        SegmentConstantPoolTest.assertEquals((int)-1, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, this.testMethodArray, "java/lang/String", "^<init>.*", 1));
    }

    public void testRegexReplacement() {
        MockSegmentConstantPool mockPool = new MockSegmentConstantPool();
        SegmentConstantPoolTest.assertTrue((boolean)mockPool.regexMatchesVisible(".*", "anything"));
        SegmentConstantPoolTest.assertTrue((boolean)mockPool.regexMatchesVisible(".*", ""));
        SegmentConstantPoolTest.assertTrue((boolean)mockPool.regexMatchesVisible("^<init>.*", "<init>"));
        SegmentConstantPoolTest.assertTrue((boolean)mockPool.regexMatchesVisible("^<init>.*", "<init>stuff"));
        SegmentConstantPoolTest.assertFalse((boolean)mockPool.regexMatchesVisible("^<init>.*", "init>stuff"));
        SegmentConstantPoolTest.assertFalse((boolean)mockPool.regexMatchesVisible("^<init>.*", "<init"));
        SegmentConstantPoolTest.assertFalse((boolean)mockPool.regexMatchesVisible("^<init>.*", ""));
    }

    public class MockSegmentConstantPool
    extends SegmentConstantPool {
        public MockSegmentConstantPool() {
            super(new CpBands(new Segment()));
        }

        public int matchSpecificPoolEntryIndex(String[] classNameArray, String desiredClassName, int desiredIndex) {
            return super.matchSpecificPoolEntryIndex(classNameArray, desiredClassName, desiredIndex);
        }

        public int matchSpecificPoolEntryIndex(String[] classNameArray, String[] methodNameArray, String desiredClassName, String desiredMethodRegex, int desiredIndex) {
            return super.matchSpecificPoolEntryIndex(classNameArray, methodNameArray, desiredClassName, desiredMethodRegex, desiredIndex);
        }

        public boolean regexMatchesVisible(String regexString, String compareString) {
            return SegmentConstantPool.regexMatches((String)regexString, (String)compareString);
        }
    }
}

