/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.tests;

import junit.framework.TestCase;
import org.apache.commons.compress.harmony.unpack200.IcTuple;

public class ICTupleTest
extends TestCase {
    public void testPredictedClassTupleParsing() {
        IcTuple tuple = new IcTuple("orw/SimpleHelloWorld$SimpleHelloWorldInner", 0, null, null, -1, -1, -1, -1);
        ICTupleTest.assertEquals((String)"SimpleHelloWorldInner", (String)tuple.simpleClassName());
        ICTupleTest.assertEquals((String)"orw/SimpleHelloWorld", (String)tuple.outerClassString());
        tuple = new IcTuple("java/util/AbstractList$2$Local", 0, null, null, -1, -1, -1, -1);
        ICTupleTest.assertEquals((String)"Local", (String)tuple.simpleClassName());
        ICTupleTest.assertEquals((String)"java/util/AbstractList$2", (String)tuple.outerClassString());
        tuple = new IcTuple("java/util/AbstractList#2#Local", 0, null, null, -1, -1, -1, -1);
        ICTupleTest.assertEquals((String)"Local", (String)tuple.simpleClassName());
        ICTupleTest.assertEquals((String)"java/util/AbstractList$2", (String)tuple.outerClassString());
        tuple = new IcTuple("java/util/AbstractList$1", 0, null, null, -1, -1, -1, -1);
        ICTupleTest.assertEquals((String)"1", (String)tuple.simpleClassName());
        ICTupleTest.assertEquals((String)"java/util/AbstractList", (String)tuple.outerClassString());
    }

    public void testExplicitClassTupleParsing() {
        IcTuple tuple = new IcTuple("Foo$$2$Local", 65536, null, "$2$Local", -1, -1, -1, -1);
        ICTupleTest.assertEquals((String)"$2$Local", (String)tuple.simpleClassName());
        ICTupleTest.assertEquals((String)"Foo$$2", (String)tuple.outerClassString());
        tuple = new IcTuple("Red$Herring", 65536, "Red$Herring", null, -1, -1, -1, -1);
        ICTupleTest.assertEquals((String)"Herring", (String)tuple.simpleClassName());
        ICTupleTest.assertEquals((String)"Red$Herring", (String)tuple.outerClassString());
        tuple = new IcTuple("X$1$Q", 65536, "X$1", "Q", -1, -1, -1, -1);
        ICTupleTest.assertEquals((String)"Q", (String)tuple.simpleClassName());
        ICTupleTest.assertEquals((String)"X$1", (String)tuple.outerClassString());
    }
}

