/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.tests;

import junit.framework.TestCase;
import org.apache.commons.compress.harmony.pack200.Codec;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.apache.commons.compress.harmony.unpack200.AttributeLayout;
import org.apache.commons.compress.harmony.unpack200.Segment;
import org.apache.commons.compress.harmony.unpack200.SegmentConstantPool;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPUTF8;
import org.apache.commons.compress.harmony.unpack200.bytecode.ClassFileEntry;

public class AttributeLayoutTest
extends TestCase {
    public void testBadData() {
        AttributeLayoutTest.assertTrue((boolean)this.throwsException(null, 0, ""));
        AttributeLayoutTest.assertTrue((boolean)this.throwsException("", 0, ""));
        AttributeLayoutTest.assertTrue((!this.throwsException("name", 0, "") ? 1 : 0) != 0);
        AttributeLayoutTest.assertTrue((!this.throwsException("name", 2, "") ? 1 : 0) != 0);
        AttributeLayoutTest.assertTrue((!this.throwsException("name", 1, "") ? 1 : 0) != 0);
        AttributeLayoutTest.assertTrue((!this.throwsException("name", 3, "") ? 1 : 0) != 0);
        AttributeLayoutTest.assertTrue((boolean)this.throwsException("name", -1, ""));
        AttributeLayoutTest.assertTrue((boolean)this.throwsException("name", 1234, ""));
    }

    public void testLayoutRU() throws Pack200Exception {
        AttributeLayout layout = new AttributeLayout("RU", 0, "RU", 1);
        TestSegment segment = new TestSegment();
        AttributeLayoutTest.assertNull((Object)layout.getValue(-1L, segment.getConstantPool()));
        AttributeLayoutTest.assertEquals((String)"Zero", (String)((CPUTF8)layout.getValue(0L, segment.getConstantPool())).underlyingString());
        AttributeLayoutTest.assertEquals((String)"One", (String)((CPUTF8)layout.getValue(1L, segment.getConstantPool())).underlyingString());
    }

    public void testLayoutRUN() throws Pack200Exception {
        AttributeLayout layout = new AttributeLayout("RUN", 0, "RUN", 1);
        TestSegment segment = new TestSegment();
        AttributeLayoutTest.assertNull((Object)layout.getValue(0L, segment.getConstantPool()));
        AttributeLayoutTest.assertEquals((String)"Zero", (String)((CPUTF8)layout.getValue(1L, segment.getConstantPool())).underlyingString());
        AttributeLayoutTest.assertEquals((String)"One", (String)((CPUTF8)layout.getValue(2L, segment.getConstantPool())).underlyingString());
    }

    public void testLayoutRS() throws Pack200Exception {
        AttributeLayout layout = new AttributeLayout("RS", 0, "RS", 1);
        TestSegment segment = new TestSegment();
        AttributeLayoutTest.assertNull((Object)layout.getValue(-1L, segment.getConstantPool()));
        AttributeLayoutTest.assertEquals((String)"Eins", (String)((CPUTF8)layout.getValue(0L, segment.getConstantPool())).underlyingString());
        AttributeLayoutTest.assertEquals((String)"Zwei", (String)((CPUTF8)layout.getValue(1L, segment.getConstantPool())).underlyingString());
    }

    public void testLayoutRSN() throws Pack200Exception {
        AttributeLayout layout = new AttributeLayout("RSN", 0, "RSN", 1);
        TestSegment segment = new TestSegment();
        AttributeLayoutTest.assertNull((Object)layout.getValue(0L, segment.getConstantPool()));
        AttributeLayoutTest.assertEquals((String)"Eins", (String)((CPUTF8)layout.getValue(1L, segment.getConstantPool())).underlyingString());
        AttributeLayoutTest.assertEquals((String)"Zwei", (String)((CPUTF8)layout.getValue(2L, segment.getConstantPool())).underlyingString());
    }

    public void testGetCodec() throws Pack200Exception {
        AttributeLayout layout = new AttributeLayout("O", 0, "HOBS", 1);
        AttributeLayoutTest.assertEquals((Object)Codec.BRANCH5, (Object)layout.getCodec());
        layout = new AttributeLayout("P", 2, "PIN", 1);
        AttributeLayoutTest.assertEquals((Object)Codec.BCI5, (Object)layout.getCodec());
        layout = new AttributeLayout("S", 1, "HS", 1);
        AttributeLayoutTest.assertEquals((Object)Codec.SIGNED5, (Object)layout.getCodec());
        layout = new AttributeLayout("RS", 3, "RRRS", 1);
        AttributeLayoutTest.assertEquals((Object)Codec.UNSIGNED5, (Object)layout.getCodec());
        layout = new AttributeLayout("KS", 0, "RKS", 1);
        AttributeLayoutTest.assertEquals((Object)Codec.UNSIGNED5, (Object)layout.getCodec());
        layout = new AttributeLayout("B", 0, "TRKSB", 1);
        AttributeLayoutTest.assertEquals((Object)Codec.BYTE1, (Object)layout.getCodec());
    }

    public boolean throwsException(String name, int context, String layout) {
        try {
            new AttributeLayout(name, context, layout, -1);
            return false;
        }
        catch (Pack200Exception e) {
            return true;
        }
    }

    public class TestSegment
    extends Segment {
        public SegmentConstantPool getConstantPool() {
            final ClassFileEntry[][] data = new ClassFileEntry[][]{new ClassFileEntry[0], {this.entry("Zero"), this.entry("One"), this.entry("Two"), this.entry("Three"), this.entry("Four"), this.entry("Five"), this.entry("Six"), this.entry("Seven"), this.entry("Eight"), this.entry("Nine")}, new ClassFileEntry[0], new ClassFileEntry[0], new ClassFileEntry[0], new ClassFileEntry[0], new ClassFileEntry[0], new ClassFileEntry[0], {this.entry("Eins"), this.entry("Zwei"), this.entry("Drei"), this.entry("Vier"), this.entry("Funf"), this.entry("Sechs"), this.entry("Sieben"), this.entry("Acht"), this.entry("Neun")}};
            return new SegmentConstantPool(null){

                public ClassFileEntry getValue(int cp, long index) {
                    if (index == -1L) {
                        return null;
                    }
                    return data[cp][(int)index];
                }
            };
        }

        private ClassFileEntry entry(String string) {
            return new CPUTF8(string);
        }
    }
}

