/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.snappy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorInputStream;
import org.apache.commons.compress.compressors.snappy.FramedSnappyDialect;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public final class FramedSnappyCompressorInputStreamTest
extends AbstractTestCase {
    @Test
    public void testMatches() throws IOException {
        Assert.assertFalse((boolean)FramedSnappyCompressorInputStream.matches((byte[])new byte[10], (int)10));
        byte[] b = new byte[12];
        IOUtils.read((File)FramedSnappyCompressorInputStreamTest.getFile("bla.tar.sz"), (byte[])b);
        Assert.assertFalse((boolean)FramedSnappyCompressorInputStream.matches((byte[])b, (int)9));
        Assert.assertTrue((boolean)FramedSnappyCompressorInputStream.matches((byte[])b, (int)10));
        Assert.assertTrue((boolean)FramedSnappyCompressorInputStream.matches((byte[])b, (int)12));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoremIpsum() throws Exception {
        File outputSz = new File(this.dir, "lorem-ipsum.1");
        File outputGz = new File(this.dir, "lorem-ipsum.2");
        try (InputStream isSz = Files.newInputStream(FramedSnappyCompressorInputStreamTest.getFile("lorem-ipsum.txt.sz").toPath(), new OpenOption[0]);){
            FramedSnappyCompressorInputStream in = new FramedSnappyCompressorInputStream(isSz);
            OutputStream out = null;
            try {
                out = Files.newOutputStream(outputSz.toPath(), new OpenOption[0]);
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                in.close();
            }
            try (InputStream isGz = Files.newInputStream(FramedSnappyCompressorInputStreamTest.getFile("lorem-ipsum.txt.gz").toPath(), new OpenOption[0]);){
                in = new GzipCompressorInputStream(isGz);
                try {
                    out = Files.newOutputStream(outputGz.toPath(), new OpenOption[0]);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                    in.close();
                }
            }
        }
        var4_4 = null;
        try (InputStream sz = Files.newInputStream(outputSz.toPath(), new OpenOption[0]);
             InputStream gz = Files.newInputStream(outputGz.toPath(), new OpenOption[0]);){
            Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)sz), (byte[])IOUtils.toByteArray((InputStream)gz));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testRemainingChunkTypes() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (InputStream isSz = Files.newInputStream(FramedSnappyCompressorInputStreamTest.getFile("mixed.txt.sz").toPath(), new OpenOption[0]);){
            FramedSnappyCompressorInputStream in = new FramedSnappyCompressorInputStream(isSz);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.close();
        }
        Assert.assertArrayEquals((byte[])new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 53, 54, 55, 56, 57, 53, 54, 55, 56, 57, 53, 54, 55, 56, 57, 53, 54, 55, 56, 57, 10, 49, 50, 51, 52, 49, 50, 51, 52}, (byte[])out.toByteArray());
    }

    @Test
    public void testAvailable() throws Exception {
        try (InputStream isSz = Files.newInputStream(FramedSnappyCompressorInputStreamTest.getFile("mixed.txt.sz").toPath(), new OpenOption[0]);){
            FramedSnappyCompressorInputStream in = new FramedSnappyCompressorInputStream(isSz);
            Assert.assertEquals((long)0L, (long)in.available());
            Assert.assertEquals((long)49L, (long)in.read());
            Assert.assertEquals((long)3L, (long)in.available());
            Assert.assertEquals((long)3L, (long)in.read(new byte[5], 0, 3));
            Assert.assertEquals((long)53L, (long)in.read());
            Assert.assertEquals((long)0L, (long)in.available());
            Assert.assertEquals((long)4L, (long)in.read(new byte[5], 0, 4));
            Assert.assertEquals((long)53L, (long)in.read());
            in.close();
        }
    }

    @Test
    public void testUnskippableChunk() {
        byte[] input = new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89, 2, 2, 0, 0, 1, 1};
        try {
            FramedSnappyCompressorInputStream in = new FramedSnappyCompressorInputStream((InputStream)new ByteArrayInputStream(input));
            in.read();
            Assert.fail((String)"expected an exception");
            in.close();
        }
        catch (IOException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("Unskippable chunk"));
        }
    }

    @Test
    public void testChecksumUnmasking() {
        this.testChecksumUnmasking(51031L);
        this.testChecksumUnmasking(4294952791L);
    }

    @Test
    public void readIWAFile() throws Exception {
        try (ZipFile zip = new ZipFile(FramedSnappyCompressorInputStreamTest.getFile("testNumbersNew.numbers"));
             InputStream is = zip.getInputStream(zip.getEntry("Index/Document.iwa"));
             FramedSnappyCompressorInputStream in = new FramedSnappyCompressorInputStream(is, FramedSnappyDialect.IWORK_ARCHIVE);
             OutputStream out = Files.newOutputStream(new File(this.dir, "snappyIWATest.raw").toPath(), new OpenOption[0]);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    @Test
    public void readIWAFileWithBiggerOffset() throws Exception {
        Throwable throwable;
        File o = new File(this.dir, "COMPRESS-358.raw");
        try (InputStream is = Files.newInputStream(FramedSnappyCompressorInputStreamTest.getFile("COMPRESS-358.iwa").toPath(), new OpenOption[0]);){
            throwable = null;
            try (FramedSnappyCompressorInputStream in = new FramedSnappyCompressorInputStream(is, 65536, FramedSnappyDialect.IWORK_ARCHIVE);
                 OutputStream out2 = Files.newOutputStream(o.toPath(), new OpenOption[0]);){
                IOUtils.copy((InputStream)in, (OutputStream)out2);
            }
            catch (Throwable out2) {
                throwable = out2;
                throw out2;
            }
        }
        var3_3 = null;
        try (InputStream a = Files.newInputStream(o.toPath(), new OpenOption[0]);){
            throwable = null;
            try (InputStream e = Files.newInputStream(FramedSnappyCompressorInputStreamTest.getFile("COMPRESS-358.uncompressed").toPath(), new OpenOption[0]);){
                byte[] expected = IOUtils.toByteArray((InputStream)e);
                byte[] actual = IOUtils.toByteArray((InputStream)a);
                Assert.assertArrayEquals((byte[])expected, (byte[])actual);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var3_3 = throwable3;
            throw throwable3;
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = FramedSnappyCompressorInputStreamTest.getFile("bla.tar.sz");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            FramedSnappyCompressorInputStream in = new FramedSnappyCompressorInputStream(is);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read());
            Assert.assertEquals((long)-1L, (long)in.read());
            in.close();
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = FramedSnappyCompressorInputStreamTest.getFile("bla.tar.sz");
        byte[] buf = new byte[2];
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            FramedSnappyCompressorInputStream in = new FramedSnappyCompressorInputStream(is);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            in.close();
        }
    }

    private void testChecksumUnmasking(long x) {
        Assert.assertEquals((Object)Long.toHexString(x), (Object)Long.toHexString(FramedSnappyCompressorInputStream.unmask((long)this.mask(x))));
    }

    private long mask(long x) {
        return (x >>> 15 | x << 17) + 2726488792L & 0xFFFFFFFFL;
    }
}

