/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz77support;

import org.apache.commons.compress.compressors.lz77support.Parameters;
import org.junit.Assert;
import org.junit.Test;

public class ParametersTest {
    @Test
    public void defaultConstructor() {
        Parameters p = ParametersTest.newParameters(128);
        Assert.assertEquals((long)128L, (long)p.getWindowSize());
        Assert.assertEquals((long)3L, (long)p.getMinBackReferenceLength());
        Assert.assertEquals((long)127L, (long)p.getMaxBackReferenceLength());
        Assert.assertEquals((long)127L, (long)p.getMaxOffset());
        Assert.assertEquals((long)128L, (long)p.getMaxLiteralLength());
    }

    @Test
    public void minBackReferenceLengthIsAtLeastThree() {
        Parameters p = ParametersTest.newParameters(128, 2, 3, 4, 5);
        Assert.assertEquals((long)3L, (long)p.getMinBackReferenceLength());
    }

    @Test
    public void maxBackReferenceLengthIsMinBackReferenceLengthWhenSmallerThanMinBackReferenceLength() {
        Parameters p = ParametersTest.newParameters(128, 2, 2, 4, 5);
        Assert.assertEquals((long)3L, (long)p.getMaxBackReferenceLength());
    }

    @Test
    public void maxBackReferenceLengthIsMinBackReferenceLengthWhenSmallerThanMinBackReferenceLengthReversedInvocationOrder() {
        Parameters p = Parameters.builder((int)128).withMaxBackReferenceLength(2).withMinBackReferenceLength(2).withMaxOffset(4).withMaxLiteralLength(5).build();
        Assert.assertEquals((long)3L, (long)p.getMaxBackReferenceLength());
    }

    @Test
    public void maxBackReferenceLengthIsMinBackReferenceLengthIfBothAreEqual() {
        Parameters p = ParametersTest.newParameters(128, 2, 3, 4, 5);
        Assert.assertEquals((long)3L, (long)p.getMaxBackReferenceLength());
    }

    @Test
    public void maxOffsetIsWindowSizeMinus1IfSetTo0() {
        Parameters p = ParametersTest.newParameters(128, 2, 3, 0, 5);
        Assert.assertEquals((long)127L, (long)p.getMaxOffset());
    }

    @Test
    public void maxOffsetIsWindowSizeMinus1IfSetToANegativeValue() {
        Parameters p = ParametersTest.newParameters(128, 2, 3, -1, 5);
        Assert.assertEquals((long)127L, (long)p.getMaxOffset());
    }

    @Test
    public void maxOffsetIsWindowSizeMinus1IfBiggerThanWindowSize() {
        Parameters p = ParametersTest.newParameters(128, 2, 3, 129, 5);
        Assert.assertEquals((long)127L, (long)p.getMaxOffset());
    }

    @Test
    public void maxLiteralLengthIsWindowSizeIfSetTo0() {
        Parameters p = ParametersTest.newParameters(128, 2, 3, 4, 0);
        Assert.assertEquals((long)128L, (long)p.getMaxLiteralLength());
    }

    @Test
    public void maxLiteralLengthIsWindowSizeIfSetToANegativeValue() {
        Parameters p = ParametersTest.newParameters(128, 2, 3, 0, -1);
        Assert.assertEquals((long)128L, (long)p.getMaxLiteralLength());
    }

    @Test
    public void maxLiteralLengthIsWindowSizeIfSetToAValueTooBigToHoldInSlidingWindow() {
        Parameters p = ParametersTest.newParameters(128, 2, 3, 0, 259);
        Assert.assertEquals((long)128L, (long)p.getMaxLiteralLength());
    }

    @Test
    public void allParametersUsuallyTakeTheirSpecifiedValues() {
        Parameters p = ParametersTest.newParameters(256, 4, 5, 6, 7);
        Assert.assertEquals((long)256L, (long)p.getWindowSize());
        Assert.assertEquals((long)4L, (long)p.getMinBackReferenceLength());
        Assert.assertEquals((long)5L, (long)p.getMaxBackReferenceLength());
        Assert.assertEquals((long)6L, (long)p.getMaxOffset());
        Assert.assertEquals((long)7L, (long)p.getMaxLiteralLength());
    }

    @Test(expected=IllegalArgumentException.class)
    public void windowSizeMustNotBeSmallerThanMinBackReferenceLength() {
        ParametersTest.newParameters(128, 200, 300, 400, 500);
    }

    @Test(expected=IllegalArgumentException.class)
    public void windowSizeMustBeAPowerOfTwo() {
        ParametersTest.newParameters(100, 200, 300, 400, 500);
    }

    private static Parameters newParameters(int windowSize) {
        return Parameters.builder((int)windowSize).build();
    }

    private static Parameters newParameters(int windowSize, int minBackReferenceLength, int maxBackReferenceLength, int maxOffset, int maxLiteralLength) {
        return Parameters.builder((int)windowSize).withMinBackReferenceLength(minBackReferenceLength).withMaxBackReferenceLength(maxBackReferenceLength).withMaxOffset(maxOffset).withMaxLiteralLength(maxLiteralLength).build();
    }
}

