/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public final class XZTestCase
extends AbstractTestCase {
    @Test
    public void testXZCreation() throws Exception {
        long max = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
        System.out.println("XZTestCase: HeapMax=" + max + " bytes " + (double)max / 1048576.0 + " MB");
        File input = XZTestCase.getFile("test1.xml");
        File output = new File(this.dir, "test1.xml.xz");
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             CompressorOutputStream cos = new CompressorStreamFactory().createCompressorOutputStream("xz", out);){
            IOUtils.copy((InputStream)Files.newInputStream(input.toPath(), new OpenOption[0]), (OutputStream)cos);
        }
    }

    @Test
    public void testXZUnarchive() throws Exception {
        File input = XZTestCase.getFile("bla.tar.xz");
        File output = new File(this.dir, "bla.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("xz", is);
             OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    @Test
    public void testConcatenatedStreamsReadFirstOnly() throws Exception {
        File input = XZTestCase.getFile("multiple.xz");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("xz", is);){
            Assert.assertEquals((long)97L, (long)in.read());
            Assert.assertEquals((long)-1L, (long)in.read());
        }
    }

    @Test
    public void testConcatenatedStreamsReadFully() throws Exception {
        File input = XZTestCase.getFile("multiple.xz");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             XZCompressorInputStream in = new XZCompressorInputStream(is, true);){
            Assert.assertEquals((long)97L, (long)in.read());
            Assert.assertEquals((long)98L, (long)in.read());
            Assert.assertEquals((long)0L, (long)in.available());
            Assert.assertEquals((long)-1L, (long)in.read());
        }
    }
}

