/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.lzma.LZMACompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public final class LZMATestCase
extends AbstractTestCase {
    @Test
    public void lzmaRoundtrip() throws Exception {
        byte[] uncompressed;
        byte[] orig;
        Throwable throwable;
        Object cos;
        File input = LZMATestCase.getFile("test1.xml");
        File compressed = new File(this.dir, "test1.xml.xz");
        try (OutputStream out = Files.newOutputStream(compressed.toPath(), new OpenOption[0]);){
            cos = new CompressorStreamFactory().createCompressorOutputStream("lzma", out);
            throwable = null;
            try {
                IOUtils.copy((InputStream)Files.newInputStream(input.toPath(), new OpenOption[0]), (OutputStream)cos);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cos != null) {
                    if (throwable != null) {
                        try {
                            cos.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        cos.close();
                    }
                }
            }
        }
        InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
        cos = null;
        try {
            orig = IOUtils.toByteArray((InputStream)is);
        }
        catch (Throwable throwable4) {
            cos = throwable4;
            throw throwable4;
        }
        finally {
            if (is != null) {
                if (cos != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable5) {
                        ((Throwable)cos).addSuppressed(throwable5);
                    }
                } else {
                    is.close();
                }
            }
        }
        throwable = null;
        try (InputStream is2 = Files.newInputStream(compressed.toPath(), new OpenOption[0]);
             LZMACompressorInputStream in = new LZMACompressorInputStream(is2);){
            uncompressed = IOUtils.toByteArray((InputStream)in);
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        Assert.assertArrayEquals((byte[])orig, (byte[])uncompressed);
    }

    @Test
    public void testLZMAUnarchive() throws Exception {
        File input = LZMATestCase.getFile("bla.tar.lzma");
        File output = new File(this.dir, "bla.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            LZMACompressorInputStream in = new LZMACompressorInputStream(is);
            this.copy((InputStream)in, output);
        }
    }

    @Test
    public void testLZMAUnarchiveWithAutodetection() throws Exception {
        File input = LZMATestCase.getFile("bla.tar.lzma");
        File output = new File(this.dir, "bla.tar");
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(input.toPath(), new OpenOption[0]));){
            CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream((InputStream)is);
            this.copy((InputStream)in, output);
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = LZMATestCase.getFile("bla.tar.lzma");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            LZMACompressorInputStream in = new LZMACompressorInputStream(is);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read());
            Assert.assertEquals((long)-1L, (long)in.read());
            in.close();
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = LZMATestCase.getFile("bla.tar.lzma");
        byte[] buf = new byte[2];
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            LZMACompressorInputStream in = new LZMACompressorInputStream(is);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(InputStream in, File output) throws IOException {
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            in.close();
        }
    }
}

