/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorOutputStream;
import org.apache.commons.compress.compressors.deflate.DeflateParameters;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Test;

public final class DeflateTestCase
extends AbstractTestCase {
    @Test
    public void testDeflateCreation() throws Exception {
        File input = DeflateTestCase.getFile("test1.xml");
        File output = new File(this.dir, "test1.xml.deflatez");
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             CompressorOutputStream cos = new CompressorStreamFactory().createCompressorOutputStream("deflate", out);){
            IOUtils.copy((InputStream)Files.newInputStream(input.toPath(), new OpenOption[0]), (OutputStream)cos);
        }
    }

    @Test
    public void testRawDeflateCreation() throws Exception {
        File input = DeflateTestCase.getFile("test1.xml");
        File output = new File(this.dir, "test1.xml.deflate");
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);){
            DeflateParameters params = new DeflateParameters();
            params.setWithZlibHeader(false);
            try (DeflateCompressorOutputStream cos = new DeflateCompressorOutputStream(out, params);){
                IOUtils.copy((InputStream)Files.newInputStream(input.toPath(), new OpenOption[0]), (OutputStream)cos);
            }
        }
    }

    @Test
    public void testDeflateUnarchive() throws Exception {
        File input = DeflateTestCase.getFile("bla.tar.deflatez");
        File output = new File(this.dir, "bla.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("deflate", is);
             OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    @Test
    public void testRawDeflateUnarchive() throws Exception {
        File input = DeflateTestCase.getFile("bla.tar.deflate");
        File output = new File(this.dir, "bla.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            DeflateParameters params = new DeflateParameters();
            params.setWithZlibHeader(false);
            try (DeflateCompressorInputStream in = new DeflateCompressorInputStream(is, params);
                 OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
    }
}

