/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompressorStreamFactoryRoundtripTest {
    private final String compressorName;

    @Parameterized.Parameters(name="{0}")
    public static String[] data() {
        return new String[]{"bzip2", "deflate", "gz", "xz"};
    }

    public CompressorStreamFactoryRoundtripTest(String compressorName) {
        this.compressorName = compressorName;
    }

    @Test
    public void testCompressorStreamFactoryRoundtrip() throws Exception {
        CompressorStreamFactory factory = new CompressorStreamFactory();
        ByteArrayOutputStream compressedOs = new ByteArrayOutputStream();
        CompressorOutputStream compressorOutputStream = factory.createCompressorOutputStream(this.compressorName, (OutputStream)compressedOs);
        String fixture = "The quick brown fox jumps over the lazy dog";
        compressorOutputStream.write("The quick brown fox jumps over the lazy dog".getBytes(StandardCharsets.UTF_8));
        compressorOutputStream.flush();
        compressorOutputStream.close();
        ByteArrayInputStream is = new ByteArrayInputStream(compressedOs.toByteArray());
        CompressorInputStream compressorInputStream = factory.createCompressorInputStream(this.compressorName, (InputStream)is, false);
        ByteArrayOutputStream decompressedOs = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)compressorInputStream, (OutputStream)decompressedOs);
        compressorInputStream.close();
        decompressedOs.flush();
        decompressedOs.close();
        Assert.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)decompressedOs.toString("UTF-8"));
    }
}

