/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.zip.ZipException;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.X5455_ExtendedTimestamp;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class X5455_ExtendedTimestampTest {
    private static final ZipShort X5455 = new ZipShort(21589);
    private static final ZipLong ZERO_TIME = new ZipLong(0);
    private static final ZipLong MAX_TIME_SECONDS = new ZipLong(Integer.MAX_VALUE);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd/HH:mm:ss Z");
    private X5455_ExtendedTimestamp xf;
    private File tmpDir;

    @Before
    public void before() {
        this.xf = new X5455_ExtendedTimestamp();
    }

    @After
    public void removeTempFiles() {
        if (this.tmpDir != null) {
            AbstractTestCase.rmdir(this.tmpDir);
        }
    }

    @Test
    public void testSampleFile() throws Exception {
        File archive = AbstractTestCase.getFile("COMPRESS-210_unix_time_zip_test.zip");
        try (ZipFile zf = new ZipFile(archive);){
            Enumeration en = zf.getEntries();
            block14: while (en.hasMoreElements()) {
                int year;
                ZipArchiveEntry zae = (ZipArchiveEntry)en.nextElement();
                if (zae.isDirectory()) continue;
                String name = zae.getName();
                int x = name.lastIndexOf(47);
                String yearString = name.substring(x + 1);
                try {
                    year = Integer.parseInt(yearString);
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
                X5455_ExtendedTimestamp xf = (X5455_ExtendedTimestamp)zae.getExtraField(X5455);
                Date rawZ = zae.getLastModifiedDate();
                Date m = xf.getModifyJavaTime();
                boolean zipTimeUsesExtendedTimestampCorrectly = rawZ.equals(m);
                boolean zipTimeUsesExtendedTimestampButUnsigned = year > 2037 && rawZ.getSeconds() == 1;
                boolean zipTimeUsesExtendedTimestamp = zipTimeUsesExtendedTimestampCorrectly || zipTimeUsesExtendedTimestampButUnsigned;
                Date z = zipTimeUsesExtendedTimestamp ? rawZ : X5455_ExtendedTimestampTest.adjustFromGMTToExpectedOffset(rawZ);
                Date a = xf.getAccessJavaTime();
                String zipTime = DATE_FORMAT.format(z);
                String modTime = DATE_FORMAT.format(m);
                String accTime = DATE_FORMAT.format(a);
                switch (year) {
                    case 2109: {
                        if (zipTimeUsesExtendedTimestamp) continue block14;
                        Assert.assertEquals((Object)"1981-01-01/00:00:02 +0000", (Object)zipTime);
                        continue block14;
                    }
                }
                if (!zipTimeUsesExtendedTimestamp) {
                    if (year < 1980) {
                        Assert.assertEquals((Object)"1980-01-01/08:00:00 +0000", (Object)zipTime);
                    } else {
                        Assert.assertEquals((Object)(year + "-01-01/00:00:02 +0000"), (Object)zipTime);
                    }
                }
                if (year >= 2038) continue;
                Assert.assertEquals((Object)(year + "-01-01/00:00:01 +0000"), (Object)modTime);
                Assert.assertEquals((Object)(year + "-01-01/00:00:03 +0000"), (Object)accTime);
            }
        }
    }

    @Test
    public void testMisc() throws Exception {
        Assert.assertNotEquals((Object)this.xf, (Object)new Object());
        Assert.assertTrue((boolean)this.xf.toString().startsWith("0x5455 Zip Extra Field"));
        Assert.assertFalse((boolean)this.xf.toString().contains(" Modify:"));
        Assert.assertFalse((boolean)this.xf.toString().contains(" Access:"));
        Assert.assertFalse((boolean)this.xf.toString().contains(" Create:"));
        Object o = this.xf.clone();
        Assert.assertEquals((long)o.hashCode(), (long)this.xf.hashCode());
        Assert.assertEquals((Object)this.xf, (Object)o);
        this.xf.setModifyJavaTime(new Date(1111L));
        this.xf.setAccessJavaTime(new Date(2222L));
        this.xf.setCreateJavaTime(new Date(3333L));
        this.xf.setFlags((byte)7);
        Assert.assertNotEquals((Object)this.xf, (Object)o);
        Assert.assertTrue((boolean)this.xf.toString().startsWith("0x5455 Zip Extra Field"));
        Assert.assertTrue((boolean)this.xf.toString().contains(" Modify:"));
        Assert.assertTrue((boolean)this.xf.toString().contains(" Access:"));
        Assert.assertTrue((boolean)this.xf.toString().contains(" Create:"));
        o = this.xf.clone();
        Assert.assertEquals((long)o.hashCode(), (long)this.xf.hashCode());
        Assert.assertEquals((Object)this.xf, (Object)o);
    }

    @Test
    public void testGettersSetters() {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.set(1, 2000);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long timeMillis = cal.getTimeInMillis();
        ZipLong time = new ZipLong(timeMillis / 1000L);
        try {
            this.xf.setModifyJavaTime(new Date(1000L * (MAX_TIME_SECONDS.getValue() + 1L)));
            Assert.fail((String)"Time too big for 32 bits!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.xf.setModifyTime(time);
        Assert.assertEquals((Object)time, (Object)this.xf.getModifyTime());
        Date xfModifyJavaTime = this.xf.getModifyJavaTime();
        Assert.assertEquals((long)timeMillis, (long)xfModifyJavaTime.getTime());
        this.xf.setModifyJavaTime(new Date(timeMillis));
        Assert.assertEquals((Object)time, (Object)this.xf.getModifyTime());
        Assert.assertEquals((long)timeMillis, (long)this.xf.getModifyJavaTime().getTime());
        this.xf.setModifyJavaTime(new Date(timeMillis + 123L));
        Assert.assertEquals((Object)time, (Object)this.xf.getModifyTime());
        Assert.assertEquals((long)timeMillis, (long)this.xf.getModifyJavaTime().getTime());
        this.xf.setModifyTime(null);
        Assert.assertNull((Object)this.xf.getModifyJavaTime());
        this.xf.setModifyJavaTime(null);
        Assert.assertNull((Object)this.xf.getModifyTime());
        this.xf.setAccessTime(time);
        Assert.assertEquals((Object)time, (Object)this.xf.getAccessTime());
        Assert.assertEquals((long)timeMillis, (long)this.xf.getAccessJavaTime().getTime());
        this.xf.setAccessJavaTime(new Date(timeMillis));
        Assert.assertEquals((Object)time, (Object)this.xf.getAccessTime());
        Assert.assertEquals((long)timeMillis, (long)this.xf.getAccessJavaTime().getTime());
        this.xf.setAccessJavaTime(new Date(timeMillis + 123L));
        Assert.assertEquals((Object)time, (Object)this.xf.getAccessTime());
        Assert.assertEquals((long)timeMillis, (long)this.xf.getAccessJavaTime().getTime());
        this.xf.setAccessTime(null);
        Assert.assertNull((Object)this.xf.getAccessJavaTime());
        this.xf.setAccessJavaTime(null);
        Assert.assertNull((Object)this.xf.getAccessTime());
        this.xf.setCreateTime(time);
        Assert.assertEquals((Object)time, (Object)this.xf.getCreateTime());
        Assert.assertEquals((long)timeMillis, (long)this.xf.getCreateJavaTime().getTime());
        this.xf.setCreateJavaTime(new Date(timeMillis));
        Assert.assertEquals((Object)time, (Object)this.xf.getCreateTime());
        Assert.assertEquals((long)timeMillis, (long)this.xf.getCreateJavaTime().getTime());
        this.xf.setCreateJavaTime(new Date(timeMillis + 123L));
        Assert.assertEquals((Object)time, (Object)this.xf.getCreateTime());
        Assert.assertEquals((long)timeMillis, (long)this.xf.getCreateJavaTime().getTime());
        this.xf.setCreateTime(null);
        Assert.assertNull((Object)this.xf.getCreateJavaTime());
        this.xf.setCreateJavaTime(null);
        Assert.assertNull((Object)this.xf.getCreateTime());
        this.xf.setModifyTime(time);
        this.xf.setAccessTime(time);
        this.xf.setCreateTime(time);
        this.xf.setFlags((byte)0);
        Assert.assertEquals((long)0L, (long)this.xf.getFlags());
        Assert.assertFalse((boolean)this.xf.isBit0_modifyTimePresent());
        Assert.assertFalse((boolean)this.xf.isBit1_accessTimePresent());
        Assert.assertFalse((boolean)this.xf.isBit2_createTimePresent());
        Assert.assertEquals((long)1L, (long)this.xf.getLocalFileDataLength().getValue());
        Assert.assertEquals((long)1L, (long)this.xf.getCentralDirectoryLength().getValue());
        this.xf.setFlags((byte)1);
        Assert.assertEquals((long)1L, (long)this.xf.getFlags());
        Assert.assertTrue((boolean)this.xf.isBit0_modifyTimePresent());
        Assert.assertFalse((boolean)this.xf.isBit1_accessTimePresent());
        Assert.assertFalse((boolean)this.xf.isBit2_createTimePresent());
        Assert.assertEquals((long)5L, (long)this.xf.getLocalFileDataLength().getValue());
        Assert.assertEquals((long)5L, (long)this.xf.getCentralDirectoryLength().getValue());
        this.xf.setFlags((byte)2);
        Assert.assertEquals((long)2L, (long)this.xf.getFlags());
        Assert.assertFalse((boolean)this.xf.isBit0_modifyTimePresent());
        Assert.assertTrue((boolean)this.xf.isBit1_accessTimePresent());
        Assert.assertFalse((boolean)this.xf.isBit2_createTimePresent());
        Assert.assertEquals((long)5L, (long)this.xf.getLocalFileDataLength().getValue());
        Assert.assertEquals((long)1L, (long)this.xf.getCentralDirectoryLength().getValue());
        this.xf.setFlags((byte)4);
        Assert.assertEquals((long)4L, (long)this.xf.getFlags());
        Assert.assertFalse((boolean)this.xf.isBit0_modifyTimePresent());
        Assert.assertFalse((boolean)this.xf.isBit1_accessTimePresent());
        Assert.assertTrue((boolean)this.xf.isBit2_createTimePresent());
        Assert.assertEquals((long)5L, (long)this.xf.getLocalFileDataLength().getValue());
        Assert.assertEquals((long)1L, (long)this.xf.getCentralDirectoryLength().getValue());
        this.xf.setFlags((byte)7);
        Assert.assertEquals((long)7L, (long)this.xf.getFlags());
        Assert.assertTrue((boolean)this.xf.isBit0_modifyTimePresent());
        Assert.assertTrue((boolean)this.xf.isBit1_accessTimePresent());
        Assert.assertTrue((boolean)this.xf.isBit2_createTimePresent());
        Assert.assertEquals((long)13L, (long)this.xf.getLocalFileDataLength().getValue());
        Assert.assertEquals((long)5L, (long)this.xf.getCentralDirectoryLength().getValue());
        this.xf.setFlags((byte)-1);
        Assert.assertEquals((long)-1L, (long)this.xf.getFlags());
        Assert.assertTrue((boolean)this.xf.isBit0_modifyTimePresent());
        Assert.assertTrue((boolean)this.xf.isBit1_accessTimePresent());
        Assert.assertTrue((boolean)this.xf.isBit2_createTimePresent());
        Assert.assertEquals((long)13L, (long)this.xf.getLocalFileDataLength().getValue());
        Assert.assertEquals((long)5L, (long)this.xf.getCentralDirectoryLength().getValue());
    }

    @Test
    public void testGetHeaderId() {
        Assert.assertEquals((Object)X5455, (Object)this.xf.getHeaderId());
    }

    @Test
    public void testParseReparse() throws ZipException {
        byte[] NULL_FLAGS = new byte[]{0};
        byte[] AC_CENTRAL = new byte[]{2};
        byte[] CR_CENTRAL = new byte[]{4};
        byte[] MOD_ZERO = new byte[]{1, 0, 0, 0, 0};
        byte[] MOD_MAX = new byte[]{1, -1, -1, -1, 127};
        byte[] AC_ZERO = new byte[]{2, 0, 0, 0, 0};
        byte[] AC_MAX = new byte[]{2, -1, -1, -1, 127};
        byte[] CR_ZERO = new byte[]{4, 0, 0, 0, 0};
        byte[] CR_MAX = new byte[]{4, -1, -1, -1, 127};
        byte[] MOD_AC_ZERO = new byte[]{3, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] MOD_AC_MAX = new byte[]{3, -1, -1, -1, 127, -1, -1, -1, 127};
        byte[] MOD_AC_CR_ZERO = new byte[]{7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] MOD_AC_CR_MAX = new byte[]{7, -1, -1, -1, 127, -1, -1, -1, 127, -1, -1, -1, 127};
        this.parseReparse(null, NULL_FLAGS, NULL_FLAGS);
        this.parseReparse(ZERO_TIME, MOD_ZERO, MOD_ZERO);
        this.parseReparse(MAX_TIME_SECONDS, MOD_MAX, MOD_MAX);
        this.parseReparse(ZERO_TIME, AC_ZERO, AC_CENTRAL);
        this.parseReparse(MAX_TIME_SECONDS, AC_MAX, AC_CENTRAL);
        this.parseReparse(ZERO_TIME, CR_ZERO, CR_CENTRAL);
        this.parseReparse(MAX_TIME_SECONDS, CR_MAX, CR_CENTRAL);
        this.parseReparse(ZERO_TIME, MOD_AC_ZERO, MOD_ZERO);
        this.parseReparse(MAX_TIME_SECONDS, MOD_AC_MAX, MOD_MAX);
        this.parseReparse(ZERO_TIME, MOD_AC_CR_ZERO, MOD_ZERO);
        this.parseReparse(MAX_TIME_SECONDS, MOD_AC_CR_MAX, MOD_MAX);
        this.parseReparse((byte)15, MAX_TIME_SECONDS, (byte)7, MOD_AC_CR_MAX, MOD_MAX);
        this.parseReparse((byte)31, MAX_TIME_SECONDS, (byte)7, MOD_AC_CR_MAX, MOD_MAX);
        this.parseReparse((byte)63, MAX_TIME_SECONDS, (byte)7, MOD_AC_CR_MAX, MOD_MAX);
        this.parseReparse((byte)71, MAX_TIME_SECONDS, (byte)7, MOD_AC_CR_MAX, MOD_MAX);
        this.parseReparse((byte)127, MAX_TIME_SECONDS, (byte)7, MOD_AC_CR_MAX, MOD_MAX);
        this.parseReparse((byte)-1, MAX_TIME_SECONDS, (byte)7, MOD_AC_CR_MAX, MOD_MAX);
    }

    @Test
    public void testWriteReadRoundtrip() throws IOException {
        this.tmpDir = AbstractTestCase.mkdir("X5455");
        File output = new File(this.tmpDir, "write_rewrite.zip");
        Date d = new Date(97, 8, 24, 15, 10, 2);
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             ZipArchiveOutputStream os = new ZipArchiveOutputStream(out);){
            ZipArchiveEntry ze = new ZipArchiveEntry("foo");
            this.xf.setModifyJavaTime(d);
            this.xf.setFlags((byte)1);
            ze.addExtraField((ZipExtraField)this.xf);
            os.putArchiveEntry((ArchiveEntry)ze);
            os.closeArchiveEntry();
        }
        var4_4 = null;
        try (ZipFile zf = new ZipFile(output);){
            ZipArchiveEntry ze = zf.getEntry("foo");
            X5455_ExtendedTimestamp ext = (X5455_ExtendedTimestamp)ze.getExtraField(X5455);
            Assert.assertNotNull((Object)ext);
            Assert.assertTrue((boolean)ext.isBit0_modifyTimePresent());
            Assert.assertEquals((Object)d, (Object)ext.getModifyJavaTime());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testBitsAreSetWithTime() {
        this.xf.setModifyJavaTime(new Date(1111L));
        Assert.assertTrue((boolean)this.xf.isBit0_modifyTimePresent());
        Assert.assertEquals((long)1L, (long)this.xf.getFlags());
        this.xf.setAccessJavaTime(new Date(2222L));
        Assert.assertTrue((boolean)this.xf.isBit1_accessTimePresent());
        Assert.assertEquals((long)3L, (long)this.xf.getFlags());
        this.xf.setCreateJavaTime(new Date(3333L));
        Assert.assertTrue((boolean)this.xf.isBit2_createTimePresent());
        Assert.assertEquals((long)7L, (long)this.xf.getFlags());
        this.xf.setModifyJavaTime(null);
        Assert.assertFalse((boolean)this.xf.isBit0_modifyTimePresent());
        Assert.assertEquals((long)6L, (long)this.xf.getFlags());
        this.xf.setAccessJavaTime(null);
        Assert.assertFalse((boolean)this.xf.isBit1_accessTimePresent());
        Assert.assertEquals((long)4L, (long)this.xf.getFlags());
        this.xf.setCreateJavaTime(null);
        Assert.assertFalse((boolean)this.xf.isBit2_createTimePresent());
        Assert.assertEquals((long)0L, (long)this.xf.getFlags());
    }

    @Test
    public void resetsFlagsWhenLocalFileArrayIsTooShort() throws Exception {
        byte[] local = new byte[]{7};
        this.xf.parseFromLocalFileData(local, 0, 1);
        Assert.assertArrayEquals((byte[])new byte[1], (byte[])this.xf.getLocalFileDataData());
    }

    private void parseReparse(ZipLong time, byte[] expectedLocal, byte[] almostExpectedCentral) throws ZipException {
        this.parseReparse(expectedLocal[0], time, expectedLocal[0], expectedLocal, almostExpectedCentral);
    }

    private void parseReparse(byte providedFlags, ZipLong time, byte expectedFlags, byte[] expectedLocal, byte[] almostExpectedCentral) throws ZipException {
        byte[] expectedCentral = new byte[almostExpectedCentral.length];
        System.arraycopy(almostExpectedCentral, 0, expectedCentral, 0, almostExpectedCentral.length);
        expectedCentral[0] = expectedFlags;
        this.xf.setModifyTime(time);
        this.xf.setAccessTime(time);
        this.xf.setCreateTime(time);
        this.xf.setFlags(providedFlags);
        byte[] result = this.xf.getLocalFileDataData();
        Assert.assertArrayEquals((byte[])expectedLocal, (byte[])result);
        this.xf.parseFromLocalFileData(result, 0, result.length);
        Assert.assertEquals((long)expectedFlags, (long)this.xf.getFlags());
        if (X5455_ExtendedTimestampTest.isFlagSet(expectedFlags, (byte)1)) {
            Assert.assertTrue((boolean)this.xf.isBit0_modifyTimePresent());
            Assert.assertEquals((Object)time, (Object)this.xf.getModifyTime());
        }
        if (X5455_ExtendedTimestampTest.isFlagSet(expectedFlags, (byte)2)) {
            Assert.assertTrue((boolean)this.xf.isBit1_accessTimePresent());
            Assert.assertEquals((Object)time, (Object)this.xf.getAccessTime());
        }
        if (X5455_ExtendedTimestampTest.isFlagSet(expectedFlags, (byte)4)) {
            Assert.assertTrue((boolean)this.xf.isBit2_createTimePresent());
            Assert.assertEquals((Object)time, (Object)this.xf.getCreateTime());
        }
        this.xf.setModifyTime(time);
        this.xf.setAccessTime(time);
        this.xf.setCreateTime(time);
        this.xf.setFlags(providedFlags);
        result = this.xf.getCentralDirectoryData();
        Assert.assertArrayEquals((byte[])expectedCentral, (byte[])result);
        this.xf.parseFromCentralDirectoryData(result, 0, result.length);
        Assert.assertEquals((long)expectedFlags, (long)this.xf.getFlags());
        if (X5455_ExtendedTimestampTest.isFlagSet(expectedFlags, (byte)1)) {
            Assert.assertTrue((boolean)this.xf.isBit0_modifyTimePresent());
            Assert.assertEquals((Object)time, (Object)this.xf.getModifyTime());
        }
    }

    private static boolean isFlagSet(byte data, byte flag) {
        return (data & flag) == flag;
    }

    private static Date adjustFromGMTToExpectedOffset(Date from) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(from);
        cal.add(14, cal.get(15));
        if (cal.getTimeZone().inDaylightTime(from)) {
            cal.add(14, cal.get(16));
        }
        cal.add(10, 8);
        return cal.getTime();
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

