/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ExplodingInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.utils.BoundedInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class ExplodeSupportTest {
    private void testArchiveWithImplodeCompression(String filename, String entryName) throws IOException {
        ZipFile zip = new ZipFile(new File(filename));
        ZipArchiveEntry entry = (ZipArchiveEntry)zip.getEntries().nextElement();
        Assert.assertEquals((String)"entry name", (Object)entryName, (Object)entry.getName());
        Assert.assertTrue((String)"entry can't be read", (boolean)zip.canReadEntryData(entry));
        Assert.assertEquals((String)"method", (long)ZipMethod.IMPLODING.getCode(), (long)entry.getMethod());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CheckedOutputStream out = new CheckedOutputStream(bout, new CRC32());
        IOUtils.copy((InputStream)zip.getInputStream(entry), (OutputStream)out);
        out.flush();
        Assert.assertEquals((String)"CRC32", (long)entry.getCrc(), (long)out.getChecksum().getValue());
        zip.close();
    }

    @Test
    public void testArchiveWithImplodeCompression4K2Trees() throws IOException {
        this.testArchiveWithImplodeCompression("target/test-classes/imploding-4Kdict-2trees.zip", "HEADER.TXT");
    }

    @Test
    public void testArchiveWithImplodeCompression8K3Trees() throws IOException {
        this.testArchiveWithImplodeCompression("target/test-classes/imploding-8Kdict-3trees.zip", "LICENSE.TXT");
    }

    @Test
    public void testTikaTestArchive() throws IOException {
        this.testArchiveWithImplodeCompression("target/test-classes/moby-imploded.zip", "README");
    }

    private void testZipStreamWithImplodeCompression(String filename, String entryName) throws IOException {
        ZipArchiveInputStream zin = new ZipArchiveInputStream(Files.newInputStream(new File(filename).toPath(), new OpenOption[0]));
        ZipArchiveEntry entry = zin.getNextZipEntry();
        Assert.assertEquals((String)"entry name", (Object)entryName, (Object)entry.getName());
        Assert.assertTrue((String)"entry can't be read", (boolean)zin.canReadEntryData((ArchiveEntry)entry));
        Assert.assertEquals((String)"method", (long)ZipMethod.IMPLODING.getCode(), (long)entry.getMethod());
        BoundedInputStream bio = new BoundedInputStream((InputStream)zin, entry.getSize());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CheckedOutputStream out = new CheckedOutputStream(bout, new CRC32());
        IOUtils.copy((InputStream)bio, (OutputStream)out);
        out.flush();
        Assert.assertEquals((String)"CRC32", (long)entry.getCrc(), (long)out.getChecksum().getValue());
    }

    @Test
    public void testZipStreamWithImplodeCompression4K2Trees() throws IOException {
        this.testZipStreamWithImplodeCompression("target/test-classes/imploding-4Kdict-2trees.zip", "HEADER.TXT");
    }

    @Test
    public void testZipStreamWithImplodeCompression8K3Trees() throws IOException {
        this.testZipStreamWithImplodeCompression("target/test-classes/imploding-8Kdict-3trees.zip", "LICENSE.TXT");
    }

    @Test
    public void testTikaTestStream() throws IOException {
        this.testZipStreamWithImplodeCompression("target/test-classes/moby-imploded.zip", "README");
    }

    @Test
    public void testConstructorThrowsExceptions() {
        ExplodingInputStream eis2;
        try {
            eis2 = new ExplodingInputStream(4095, 2, (InputStream)new ByteArrayInputStream(new byte[0]));
            Assert.fail((String)"should have failed with illegal argument exception");
        }
        catch (IllegalArgumentException eis2) {
            // empty catch block
        }
        try {
            eis2 = new ExplodingInputStream(4096, 4, (InputStream)new ByteArrayInputStream(new byte[0]));
            Assert.fail((String)"should have failed with illegal argument exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

