/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.compress.archivers.zip.BitStream;
import org.apache.commons.compress.utils.ByteUtils;
import org.junit.Assert;
import org.junit.Test;

public class BitStreamTest {
    @Test
    public void testEmptyStream() throws Exception {
        BitStream stream = new BitStream((InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY));
        Assert.assertEquals((String)"next bit", (long)-1L, (long)stream.nextBit());
        Assert.assertEquals((String)"next bit", (long)-1L, (long)stream.nextBit());
        Assert.assertEquals((String)"next bit", (long)-1L, (long)stream.nextBit());
        stream.close();
    }

    @Test
    public void testStream() throws Exception {
        BitStream stream = new BitStream((InputStream)new ByteArrayInputStream(new byte[]{-22, 3}));
        Assert.assertEquals((String)"bit 0", (long)0L, (long)stream.nextBit());
        Assert.assertEquals((String)"bit 1", (long)1L, (long)stream.nextBit());
        Assert.assertEquals((String)"bit 2", (long)0L, (long)stream.nextBit());
        Assert.assertEquals((String)"bit 3", (long)1L, (long)stream.nextBit());
        Assert.assertEquals((String)"bit 4", (long)0L, (long)stream.nextBit());
        Assert.assertEquals((String)"bit 5", (long)1L, (long)stream.nextBit());
        Assert.assertEquals((String)"bit 6", (long)1L, (long)stream.nextBit());
        Assert.assertEquals((String)"bit 7", (long)1L, (long)stream.nextBit());
        Assert.assertEquals((String)"bit 8", (long)1L, (long)stream.nextBit());
        Assert.assertEquals((String)"bit 9", (long)1L, (long)stream.nextBit());
        Assert.assertEquals((String)"bit 10", (long)0L, (long)stream.nextBit());
        Assert.assertEquals((String)"bit 11", (long)0L, (long)stream.nextBit());
        Assert.assertEquals((String)"bit 12", (long)0L, (long)stream.nextBit());
        Assert.assertEquals((String)"bit 13", (long)0L, (long)stream.nextBit());
        Assert.assertEquals((String)"bit 14", (long)0L, (long)stream.nextBit());
        Assert.assertEquals((String)"bit 15", (long)0L, (long)stream.nextBit());
        Assert.assertEquals((String)"next bit", (long)-1L, (long)stream.nextBit());
        stream.close();
    }

    @Test
    public void testNextByteFromEmptyStream() throws Exception {
        BitStream stream = new BitStream((InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY));
        Assert.assertEquals((String)"next byte", (long)-1L, (long)stream.nextByte());
        Assert.assertEquals((String)"next byte", (long)-1L, (long)stream.nextByte());
        stream.close();
    }

    @Test
    public void testReadAlignedBytes() throws Exception {
        BitStream stream = new BitStream((InputStream)new ByteArrayInputStream(new byte[]{-22, 53}));
        Assert.assertEquals((String)"next byte", (long)234L, (long)stream.nextByte());
        Assert.assertEquals((String)"next byte", (long)53L, (long)stream.nextByte());
        Assert.assertEquals((String)"next byte", (long)-1L, (long)stream.nextByte());
        stream.close();
    }

    @Test
    public void testNextByte() throws Exception {
        BitStream stream = new BitStream((InputStream)new ByteArrayInputStream(new byte[]{-22, 53}));
        Assert.assertEquals((String)"bit 0", (long)0L, (long)stream.nextBit());
        Assert.assertEquals((String)"bit 1", (long)1L, (long)stream.nextBit());
        Assert.assertEquals((String)"bit 2", (long)0L, (long)stream.nextBit());
        Assert.assertEquals((String)"bit 3", (long)1L, (long)stream.nextBit());
        Assert.assertEquals((String)"next byte", (long)94L, (long)stream.nextByte());
        Assert.assertEquals((String)"next byte", (long)-1L, (long)stream.nextByte());
        stream.close();
    }
}

