/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class TarArchiveInputStreamTest
extends AbstractTestCase {
    @Test
    public void workaroundForBrokenTimeHeader() throws Exception {
        try (TarArchiveInputStream in = new TarArchiveInputStream(Files.newInputStream(TarArchiveInputStreamTest.getFile("simple-aix-native-tar.tar").toPath(), new OpenOption[0]));){
            TarArchiveEntry tae = in.getNextTarEntry();
            tae = in.getNextTarEntry();
            Assert.assertEquals((Object)"sample/link-to-txt-file.lnk", (Object)tae.getName());
            Assert.assertEquals((Object)new Date(0L), (Object)tae.getLastModifiedDate());
            Assert.assertTrue((boolean)tae.isSymbolicLink());
            Assert.assertTrue((boolean)tae.isCheckSumOK());
        }
    }

    @Test
    public void datePriorToEpochInGNUFormat() throws Exception {
        this.datePriorToEpoch("preepoch-star.tar");
    }

    @Test
    public void datePriorToEpochInPAXFormat() throws Exception {
        this.datePriorToEpoch("preepoch-posix.tar");
    }

    private void datePriorToEpoch(String archive) throws Exception {
        try (TarArchiveInputStream in = new TarArchiveInputStream(Files.newInputStream(TarArchiveInputStreamTest.getFile(archive).toPath(), new OpenOption[0]));){
            TarArchiveEntry tae = in.getNextTarEntry();
            Assert.assertEquals((Object)"foo", (Object)tae.getName());
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            cal.set(1969, 11, 31, 23, 59, 59);
            cal.set(14, 0);
            Assert.assertEquals((Object)cal.getTime(), (Object)tae.getLastModifiedDate());
            Assert.assertTrue((boolean)tae.isCheckSumOK());
        }
    }

    @Test
    public void testCompress197() throws Exception {
        try (TarArchiveInputStream tar = this.getTestStream("/COMPRESS-197.tar");){
            TarArchiveEntry entry = tar.getNextTarEntry();
            while (entry != null) {
                entry = tar.getNextTarEntry();
            }
        }
        catch (IOException e) {
            Assert.fail((String)("COMPRESS-197: " + e.getMessage()));
        }
    }

    @Test
    public void shouldUseSpecifiedEncodingWhenReadingGNULongNames() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String encoding = "UTF-16";
        String name = "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\u00e4";
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, "UTF-16");
        tos.setLongFileMode(2);
        TarArchiveEntry t = new TarArchiveEntry("12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\u00e4");
        t.setSize(1L);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.write(30);
        tos.closeArchiveEntry();
        tos.close();
        byte[] data = bos.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)bis, "UTF-16");
        t = tis.getNextTarEntry();
        Assert.assertEquals((Object)"12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\u00e4", (Object)t.getName());
        tis.close();
    }

    @Test
    public void shouldConsumeArchiveCompletely() throws Exception {
        InputStream is = TarArchiveInputStreamTest.class.getResourceAsStream("/archive_with_trailer.tar");
        TarArchiveInputStream tar = new TarArchiveInputStream(is);
        while (tar.getNextTarEntry() != null) {
        }
        byte[] expected = new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 10};
        byte[] actual = new byte[expected.length];
        is.read(actual);
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        tar.close();
    }

    @Test
    public void readsArchiveCompletely_COMPRESS245() throws Exception {
        try (InputStream is = TarArchiveInputStreamTest.class.getResourceAsStream("/COMPRESS-245.tar.gz");){
            GZIPInputStream gin = new GZIPInputStream(is);
            TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)gin);
            int count = 0;
            TarArchiveEntry entry = tar.getNextTarEntry();
            while (entry != null) {
                ++count;
                entry = tar.getNextTarEntry();
            }
            Assert.assertEquals((long)31L, (long)count);
            tar.close();
        }
        catch (IOException e) {
            Assert.fail((String)("COMPRESS-245: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IOException.class)
    public void shouldThrowAnExceptionOnTruncatedEntries() throws Exception {
        File dir = TarArchiveInputStreamTest.mkdir("COMPRESS-279");
        TarArchiveInputStream is = this.getTestStream("/COMPRESS-279.tar");
        OutputStream out = null;
        try {
            TarArchiveEntry entry = is.getNextTarEntry();
            int count = 0;
            while (entry != null) {
                out = Files.newOutputStream(new File(dir, String.valueOf(count)).toPath(), new OpenOption[0]);
                IOUtils.copy((InputStream)is, (OutputStream)out);
                out.close();
                out = null;
                ++count;
                entry = is.getNextTarEntry();
            }
        }
        finally {
            is.close();
            if (out != null) {
                out.close();
            }
            TarArchiveInputStreamTest.rmdir(dir);
        }
    }

    @Test
    public void shouldReadBigGid() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);
        tos.setBigNumberMode(2);
        TarArchiveEntry t = new TarArchiveEntry("name");
        t.setGroupId(0xFFFFFFFEL);
        t.setSize(1L);
        tos.putArchiveEntry((ArchiveEntry)t);
        tos.write(30);
        tos.closeArchiveEntry();
        tos.close();
        byte[] data = bos.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)bis);
        t = tis.getNextTarEntry();
        Assert.assertEquals((long)0xFFFFFFFEL, (long)t.getLongGroupId());
        tis.close();
    }

    @Test
    public void shouldReadGNULongNameEntryWithWrongName() throws Exception {
        try (TarArchiveInputStream is = this.getTestStream("/COMPRESS-324.tar");){
            TarArchiveEntry entry = is.getNextTarEntry();
            Assert.assertEquals((Object)"1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890.txt", (Object)entry.getName());
        }
    }

    @Test
    public void survivesBlankLinesInPaxHeader() throws Exception {
        try (TarArchiveInputStream is = this.getTestStream("/COMPRESS-355.tar");){
            TarArchiveEntry entry = is.getNextTarEntry();
            Assert.assertEquals((Object)"package/package.json", (Object)entry.getName());
            Assert.assertNull((Object)is.getNextTarEntry());
        }
    }

    @Test
    public void survivesPaxHeaderWithNameEndingInSlash() throws Exception {
        try (TarArchiveInputStream is = this.getTestStream("/COMPRESS-356.tar");){
            TarArchiveEntry entry = is.getNextTarEntry();
            Assert.assertEquals((Object)"package/package.json", (Object)entry.getName());
            Assert.assertNull((Object)is.getNextTarEntry());
        }
    }

    @Test
    public void testGetAndSetOfPaxEntry() throws Exception {
        try (TarArchiveInputStream is = this.getTestStream("/COMPRESS-356.tar");){
            TarArchiveEntry entry = is.getNextTarEntry();
            Assert.assertEquals((Object)"package/package.json", (Object)entry.getName());
            Assert.assertEquals((Object)is.getCurrentEntry(), (Object)entry);
            TarArchiveEntry weaselEntry = new TarArchiveEntry(entry.getName());
            weaselEntry.setSize(entry.getSize());
            is.setCurrentEntry(weaselEntry);
            Assert.assertEquals((Object)entry, (Object)is.getCurrentEntry());
            Assert.assertNotSame((Object)entry, (Object)is.getCurrentEntry());
            Assert.assertSame((Object)weaselEntry, (Object)is.getCurrentEntry());
            try {
                is.setCurrentEntry(null);
                is.read();
                Assert.fail((String)"should abort because current entry is nulled");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            is.setCurrentEntry(entry);
            is.read();
        }
    }

    @Test
    public void skipsDevNumbersWhenEntryIsNoDevice() throws Exception {
        try (TarArchiveInputStream is = this.getTestStream("/COMPRESS-417.tar");){
            Assert.assertEquals((Object)"test1.xml", (Object)is.getNextTarEntry().getName());
            Assert.assertEquals((Object)"test2.xml", (Object)is.getNextTarEntry().getName());
            Assert.assertNull((Object)is.getNextTarEntry());
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        try (InputStream in = Files.newInputStream(TarArchiveInputStreamTest.getFile("bla.tar").toPath(), new OpenOption[0]);
             TarArchiveInputStream archive = new TarArchiveInputStream(in);){
            ArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assert.assertEquals((long)-1L, (long)archive.read());
            Assert.assertEquals((long)-1L, (long)archive.read());
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        byte[] buf = new byte[2];
        try (InputStream in = Files.newInputStream(TarArchiveInputStreamTest.getFile("bla.tar").toPath(), new OpenOption[0]);
             TarArchiveInputStream archive = new TarArchiveInputStream(in);){
            ArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assert.assertEquals((long)-1L, (long)archive.read(buf));
            Assert.assertEquals((long)-1L, (long)archive.read(buf));
        }
    }

    @Test
    public void testDirectoryWithLongNameEndsWithSlash() throws IOException, ArchiveException {
        String rootPath = this.dir.getAbsolutePath();
        String dirDirectory = "COMPRESS-509";
        int count = 100;
        File root = new File(rootPath + "/" + "COMPRESS-509");
        root.mkdirs();
        for (int i = 1; i < 100; ++i) {
            TarArchiveEntry outEntry;
            String subDir = "";
            for (int j = 0; j < i; ++j) {
                subDir = subDir + "a";
            }
            File dir = new File(rootPath + "/" + "COMPRESS-509", "/" + subDir);
            dir.mkdir();
            String fileName = "/COMPRESS-509/" + subDir;
            File tarF = new File(rootPath + "/tar" + i + ".tar");
            OutputStream dest = Files.newOutputStream(tarF.toPath(), new OpenOption[0]);
            TarArchiveOutputStream out = new TarArchiveOutputStream((OutputStream)new BufferedOutputStream(dest));
            out.setBigNumberMode(1);
            out.setLongFileMode(2);
            File file = new File(rootPath, fileName);
            TarArchiveEntry entry = new TarArchiveEntry(file);
            entry.setName(fileName);
            out.putArchiveEntry((ArchiveEntry)entry);
            out.closeArchiveEntry();
            out.flush();
            out.close();
            InputStream is = Files.newInputStream(tarF.toPath(), new OpenOption[0]);
            TarArchiveInputStream debInputStream = (TarArchiveInputStream)ArchiveStreamFactory.DEFAULT.createArchiveInputStream("tar", is);
            while ((outEntry = (TarArchiveEntry)debInputStream.getNextEntry()) != null) {
                Assert.assertTrue((boolean)outEntry.getName().endsWith("/"));
            }
            debInputStream.close();
        }
    }

    @Test(expected=IOException.class)
    public void testParseTarWithSpecialPaxHeaders() throws IOException {
        try (InputStream in = Files.newInputStream(TarArchiveInputStreamTest.getFile("COMPRESS-530.tar").toPath(), new OpenOption[0]);
             TarArchiveInputStream archive = new TarArchiveInputStream(in);){
            archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
        }
    }

    @Test(expected=IOException.class)
    public void testParseTarWithNonNumberPaxHeaders() throws IOException {
        try (InputStream in = Files.newInputStream(TarArchiveInputStreamTest.getFile("COMPRESS-529.tar").toPath(), new OpenOption[0]);
             TarArchiveInputStream archive = new TarArchiveInputStream(in);){
            archive.getNextEntry();
        }
    }

    @Test(expected=IOException.class)
    public void testParseTarTruncatedInPadding() throws IOException {
        try (InputStream in = Files.newInputStream(TarArchiveInputStreamTest.getFile("COMPRESS-544_truncated_in_padding.tar").toPath(), new OpenOption[0]);
             TarArchiveInputStream archive = new TarArchiveInputStream(in);){
            while (archive.getNextTarEntry() != null) {
            }
        }
    }

    @Test(expected=IOException.class)
    public void testParseTarTruncatedInContent() throws IOException {
        try (InputStream in = Files.newInputStream(TarArchiveInputStreamTest.getFile("COMPRESS-544_truncated_in_content.tar").toPath(), new OpenOption[0]);
             TarArchiveInputStream archive = new TarArchiveInputStream(in);){
            while (archive.getNextTarEntry() != null) {
            }
        }
    }

    @Test(expected=IOException.class)
    public void testThrowExceptionWithNullEntry() throws IOException {
        try (InputStream in = Files.newInputStream(TarArchiveInputStreamTest.getFile("COMPRESS-554.tar").toPath(), new OpenOption[0]);
             TarArchiveInputStream archive = new TarArchiveInputStream(in);){
            while (archive.getNextTarEntry() != null) {
            }
        }
    }

    @Test(expected=IOException.class)
    public void testThrowException() throws IOException {
        try (InputStream in = Files.newInputStream(TarArchiveInputStreamTest.getFile("COMPRESS-553.tar").toPath(), new OpenOption[0]);
             TarArchiveInputStream archive = new TarArchiveInputStream(in);){
            while (archive.getNextTarEntry() != null) {
            }
        }
    }

    @Test
    public void testCompress558() throws IOException {
        String folderName = "apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/";
        String consumerJavaName = "apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Consumer.java";
        String producerJavaName = "apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Producer.java";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);){
            tos.setLongFileMode(2);
            TarArchiveEntry rootfolder = new TarArchiveEntry("apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/");
            tos.putArchiveEntry((ArchiveEntry)rootfolder);
            TarArchiveEntry consumerJava = new TarArchiveEntry("apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Consumer.java");
            tos.putArchiveEntry((ArchiveEntry)consumerJava);
            TarArchiveEntry producerJava = new TarArchiveEntry("apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Producer.java");
            tos.putArchiveEntry((ArchiveEntry)producerJava);
            tos.closeArchiveEntry();
        }
        byte[] data = bos.toByteArray();
        try (ByteArrayInputStream bis = new ByteArrayInputStream(data);
             TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)bis);){
            Assert.assertEquals((Object)"apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/", (Object)tis.getNextTarEntry().getName());
            Assert.assertEquals((Object)"apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Consumer.java", (Object)tis.getNextTarEntry().getName());
            Assert.assertEquals((Object)"apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Producer.java", (Object)tis.getNextTarEntry().getName());
        }
    }

    @Test(expected=IOException.class)
    public void rejectsArchivesWithNegativeSizes() throws Exception {
        try (InputStream in = Files.newInputStream(TarArchiveInputStreamTest.getFile("COMPRESS-569.tar").toPath(), new OpenOption[0]);
             TarArchiveInputStream archive = new TarArchiveInputStream(in);){
            while (archive.getNextTarEntry() != null) {
            }
        }
    }

    private TarArchiveInputStream getTestStream(String name) {
        return new TarArchiveInputStream(TarArchiveInputStreamTest.class.getResourceAsStream(name));
    }
}

