/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.junit.Assert;
import org.junit.Test;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZ;

public class SevenZOutputFileTest
extends AbstractTestCase {
    private static final boolean XZ_BCJ_IS_BUGGY;
    private File output;

    @Override
    public void tearDown() throws Exception {
        if (this.output != null && !this.output.delete()) {
            this.output.deleteOnExit();
        }
        super.tearDown();
    }

    @Test
    public void testDirectoriesAndEmptyFiles() throws Exception {
        SevenZArchiveEntry entry;
        this.output = new File(this.dir, "empties.7z");
        Date accessDate = new Date();
        Calendar cal = Calendar.getInstance();
        cal.add(10, -1);
        Date creationDate = cal.getTime();
        try (SevenZOutputFile outArchive = new SevenZOutputFile(this.output);){
            entry = outArchive.createArchiveEntry(this.dir, "foo/");
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.closeArchiveEntry();
            entry = new SevenZArchiveEntry();
            entry.setName("foo/bar");
            entry.setCreationDate(creationDate);
            entry.setAccessDate(accessDate);
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.write(ByteUtils.EMPTY_BYTE_ARRAY);
            outArchive.closeArchiveEntry();
            entry = new SevenZArchiveEntry();
            entry.setName("foo/bar/boo0");
            entry.setCreationDate(creationDate);
            entry.setAccessDate(accessDate);
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.write((InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY));
            outArchive.closeArchiveEntry();
            entry = new SevenZArchiveEntry();
            entry.setName("foo/bar/boo1");
            entry.setCreationDate(creationDate);
            entry.setAccessDate(accessDate);
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.write((InputStream)new ByteArrayInputStream(new byte[]{97}));
            outArchive.closeArchiveEntry();
            entry = new SevenZArchiveEntry();
            entry.setName("foo/bar/boo10000");
            entry.setCreationDate(creationDate);
            entry.setAccessDate(accessDate);
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.write((InputStream)new ByteArrayInputStream(new byte[10000]));
            outArchive.closeArchiveEntry();
            entry = new SevenZArchiveEntry();
            entry.setName("foo/bar/test.txt");
            entry.setCreationDate(creationDate);
            entry.setAccessDate(accessDate);
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.write(Paths.get("src/test/resources/test.txt", new String[0]), new OpenOption[0]);
            outArchive.closeArchiveEntry();
            entry = new SevenZArchiveEntry();
            entry.setName("xyzzy");
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.write(0);
            outArchive.closeArchiveEntry();
            entry = outArchive.createArchiveEntry(this.dir, "baz/");
            entry.setAntiItem(true);
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.closeArchiveEntry();
            entry = outArchive.createArchiveEntry(this.dir.toPath(), "baz2/", new LinkOption[0]);
            entry.setAntiItem(true);
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.closeArchiveEntry();
            entry = new SevenZArchiveEntry();
            entry.setName("dada");
            entry.setHasWindowsAttributes(true);
            entry.setWindowsAttributes(17);
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.write(5);
            outArchive.write(42);
            outArchive.closeArchiveEntry();
            outArchive.finish();
        }
        var5_5 = null;
        try (SevenZFile archive = new SevenZFile(this.output);){
            entry = archive.getNextEntry();
            assert (entry != null);
            Assert.assertEquals((Object)"foo/", (Object)entry.getName());
            Assert.assertTrue((boolean)entry.isDirectory());
            Assert.assertFalse((boolean)entry.isAntiItem());
            entry = archive.getNextEntry();
            assert (entry != null);
            Assert.assertEquals((Object)"foo/bar", (Object)entry.getName());
            Assert.assertFalse((boolean)entry.isDirectory());
            Assert.assertFalse((boolean)entry.isAntiItem());
            Assert.assertEquals((long)0L, (long)entry.getSize());
            Assert.assertFalse((boolean)entry.getHasLastModifiedDate());
            Assert.assertEquals((Object)accessDate, (Object)entry.getAccessDate());
            Assert.assertEquals((Object)creationDate, (Object)entry.getCreationDate());
            entry = archive.getNextEntry();
            assert (entry != null);
            Assert.assertEquals((Object)"foo/bar/boo0", (Object)entry.getName());
            Assert.assertFalse((boolean)entry.isDirectory());
            Assert.assertFalse((boolean)entry.isAntiItem());
            Assert.assertEquals((long)0L, (long)entry.getSize());
            Assert.assertFalse((boolean)entry.getHasLastModifiedDate());
            Assert.assertEquals((Object)accessDate, (Object)entry.getAccessDate());
            Assert.assertEquals((Object)creationDate, (Object)entry.getCreationDate());
            entry = archive.getNextEntry();
            assert (entry != null);
            Assert.assertEquals((Object)"foo/bar/boo1", (Object)entry.getName());
            Assert.assertFalse((boolean)entry.isDirectory());
            Assert.assertFalse((boolean)entry.isAntiItem());
            Assert.assertEquals((long)1L, (long)entry.getSize());
            Assert.assertFalse((boolean)entry.getHasLastModifiedDate());
            Assert.assertEquals((Object)accessDate, (Object)entry.getAccessDate());
            Assert.assertEquals((Object)creationDate, (Object)entry.getCreationDate());
            entry = archive.getNextEntry();
            assert (entry != null);
            Assert.assertEquals((Object)"foo/bar/boo10000", (Object)entry.getName());
            Assert.assertFalse((boolean)entry.isDirectory());
            Assert.assertFalse((boolean)entry.isAntiItem());
            Assert.assertEquals((long)10000L, (long)entry.getSize());
            Assert.assertFalse((boolean)entry.getHasLastModifiedDate());
            Assert.assertEquals((Object)accessDate, (Object)entry.getAccessDate());
            Assert.assertEquals((Object)creationDate, (Object)entry.getCreationDate());
            entry = archive.getNextEntry();
            assert (entry != null);
            Assert.assertEquals((Object)"foo/bar/test.txt", (Object)entry.getName());
            Assert.assertFalse((boolean)entry.isDirectory());
            Assert.assertFalse((boolean)entry.isAntiItem());
            Assert.assertEquals((long)Files.size(Paths.get("src/test/resources/test.txt", new String[0])), (long)entry.getSize());
            Assert.assertFalse((boolean)entry.getHasLastModifiedDate());
            Assert.assertEquals((Object)accessDate, (Object)entry.getAccessDate());
            Assert.assertEquals((Object)creationDate, (Object)entry.getCreationDate());
            entry = archive.getNextEntry();
            assert (entry != null);
            Assert.assertEquals((Object)"xyzzy", (Object)entry.getName());
            Assert.assertEquals((long)1L, (long)entry.getSize());
            Assert.assertFalse((boolean)entry.getHasAccessDate());
            Assert.assertFalse((boolean)entry.getHasCreationDate());
            Assert.assertEquals((long)0L, (long)archive.read());
            entry = archive.getNextEntry();
            assert (entry != null);
            Assert.assertEquals((Object)"baz/", (Object)entry.getName());
            Assert.assertTrue((boolean)entry.isDirectory());
            Assert.assertTrue((boolean)entry.isAntiItem());
            entry = archive.getNextEntry();
            assert (entry != null);
            Assert.assertEquals((Object)"baz2/", (Object)entry.getName());
            Assert.assertTrue((boolean)entry.isDirectory());
            Assert.assertTrue((boolean)entry.isAntiItem());
            entry = archive.getNextEntry();
            assert (entry != null);
            Assert.assertEquals((Object)"dada", (Object)entry.getName());
            Assert.assertEquals((long)2L, (long)entry.getSize());
            byte[] content = new byte[2];
            Assert.assertEquals((long)2L, (long)archive.read(content));
            Assert.assertEquals((long)5L, (long)content[0]);
            Assert.assertEquals((long)42L, (long)content[1]);
            Assert.assertEquals((long)17L, (long)entry.getWindowsAttributes());
            assert (archive.getNextEntry() == null);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testDirectoriesOnly() throws Exception {
        SevenZArchiveEntry entry;
        this.output = new File(this.dir, "dirs.7z");
        try (SevenZOutputFile outArchive = new SevenZOutputFile(this.output);){
            entry = new SevenZArchiveEntry();
            entry.setName("foo/");
            entry.setDirectory(true);
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.closeArchiveEntry();
        }
        var2_2 = null;
        try (SevenZFile archive = new SevenZFile(this.output);){
            entry = archive.getNextEntry();
            assert (entry != null);
            Assert.assertEquals((Object)"foo/", (Object)entry.getName());
            Assert.assertTrue((boolean)entry.isDirectory());
            Assert.assertFalse((boolean)entry.isAntiItem());
            assert (archive.getNextEntry() == null);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testCantFinishTwice() throws Exception {
        this.output = new File(this.dir, "finish.7z");
        try (SevenZOutputFile outArchive = new SevenZOutputFile(this.output);){
            outArchive.finish();
            outArchive.finish();
            Assert.fail((String)"shouldn't be able to call finish twice");
        }
        catch (IOException ex) {
            Assert.assertEquals((Object)"This archive has already been finished", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSixEmptyFiles() throws Exception {
        this.testCompress252(6, 0);
    }

    @Test
    public void testSixFilesSomeNotEmpty() throws Exception {
        this.testCompress252(6, 2);
    }

    @Test
    public void testSevenEmptyFiles() throws Exception {
        this.testCompress252(7, 0);
    }

    @Test
    public void testSevenFilesSomeNotEmpty() throws Exception {
        this.testCompress252(7, 2);
    }

    @Test
    public void testEightEmptyFiles() throws Exception {
        this.testCompress252(8, 0);
    }

    @Test
    public void testEightFilesSomeNotEmpty() throws Exception {
        this.testCompress252(8, 2);
    }

    @Test
    public void testNineEmptyFiles() throws Exception {
        this.testCompress252(9, 0);
    }

    @Test
    public void testNineFilesSomeNotEmpty() throws Exception {
        this.testCompress252(9, 2);
    }

    @Test
    public void testTwentyNineEmptyFiles() throws Exception {
        this.testCompress252(29, 0);
    }

    @Test
    public void testTwentyNineFilesSomeNotEmpty() throws Exception {
        this.testCompress252(29, 7);
    }

    @Test
    public void testCopyRoundtrip() throws Exception {
        this.testRoundTrip(SevenZMethod.COPY);
    }

    @Test
    public void testBzip2Roundtrip() throws Exception {
        this.testRoundTrip(SevenZMethod.BZIP2);
    }

    @Test
    public void testLzma2Roundtrip() throws Exception {
        this.testRoundTrip(SevenZMethod.LZMA2);
    }

    @Test
    public void testDeflateRoundtrip() throws Exception {
        this.testRoundTrip(SevenZMethod.DEFLATE);
    }

    @Test
    public void testBCJX86Roundtrip() throws Exception {
        if (XZ_BCJ_IS_BUGGY) {
            return;
        }
        this.testFilterRoundTrip(new SevenZMethodConfiguration(SevenZMethod.BCJ_X86_FILTER));
    }

    @Test
    public void testBCJARMRoundtrip() throws Exception {
        if (XZ_BCJ_IS_BUGGY) {
            return;
        }
        this.testFilterRoundTrip(new SevenZMethodConfiguration(SevenZMethod.BCJ_ARM_FILTER));
    }

    @Test
    public void testBCJARMThumbRoundtrip() throws Exception {
        if (XZ_BCJ_IS_BUGGY) {
            return;
        }
        this.testFilterRoundTrip(new SevenZMethodConfiguration(SevenZMethod.BCJ_ARM_THUMB_FILTER));
    }

    @Test
    public void testBCJIA64Roundtrip() throws Exception {
        if (XZ_BCJ_IS_BUGGY) {
            return;
        }
        this.testFilterRoundTrip(new SevenZMethodConfiguration(SevenZMethod.BCJ_IA64_FILTER));
    }

    @Test
    public void testBCJPPCRoundtrip() throws Exception {
        if (XZ_BCJ_IS_BUGGY) {
            return;
        }
        this.testFilterRoundTrip(new SevenZMethodConfiguration(SevenZMethod.BCJ_PPC_FILTER));
    }

    @Test
    public void testBCJSparcRoundtrip() throws Exception {
        if (XZ_BCJ_IS_BUGGY) {
            return;
        }
        this.testFilterRoundTrip(new SevenZMethodConfiguration(SevenZMethod.BCJ_SPARC_FILTER));
    }

    @Test
    public void testDeltaRoundtrip() throws Exception {
        this.testFilterRoundTrip(new SevenZMethodConfiguration(SevenZMethod.DELTA_FILTER));
    }

    @Test
    public void testStackOfContentCompressions() throws Exception {
        this.output = new File(this.dir, "multiple-methods.7z");
        ArrayList<SevenZMethodConfiguration> methods = new ArrayList<SevenZMethodConfiguration>();
        methods.add(new SevenZMethodConfiguration(SevenZMethod.LZMA2));
        methods.add(new SevenZMethodConfiguration(SevenZMethod.COPY));
        methods.add(new SevenZMethodConfiguration(SevenZMethod.DEFLATE));
        methods.add(new SevenZMethodConfiguration(SevenZMethod.BZIP2));
        this.createAndReadBack(this.output, methods);
    }

    @Test
    public void testStackOfContentCompressionsInMemory() throws Exception {
        ArrayList<SevenZMethodConfiguration> methods = new ArrayList<SevenZMethodConfiguration>();
        methods.add(new SevenZMethodConfiguration(SevenZMethod.LZMA2));
        methods.add(new SevenZMethodConfiguration(SevenZMethod.COPY));
        methods.add(new SevenZMethodConfiguration(SevenZMethod.DEFLATE));
        methods.add(new SevenZMethodConfiguration(SevenZMethod.BZIP2));
        this.createAndReadBack(new SeekableInMemoryByteChannel(), methods);
    }

    @Test
    public void testDeflateWithConfiguration() throws Exception {
        this.output = new File(this.dir, "deflate-options.7z");
        this.createAndReadBack(this.output, Collections.singletonList(new SevenZMethodConfiguration(SevenZMethod.DEFLATE, (Object)1)));
    }

    @Test
    public void testBzip2WithConfiguration() throws Exception {
        this.output = new File(this.dir, "bzip2-options.7z");
        this.createAndReadBack(this.output, Collections.singletonList(new SevenZMethodConfiguration(SevenZMethod.BZIP2, (Object)4)));
    }

    @Test
    public void testLzmaWithIntConfiguration() throws Exception {
        this.output = new File(this.dir, "lzma-options.7z");
        this.createAndReadBack(this.output, Collections.singletonList(new SevenZMethodConfiguration(SevenZMethod.LZMA, (Object)0x100000)));
    }

    @Test
    public void testLzmaWithOptionsConfiguration() throws Exception {
        this.output = new File(this.dir, "lzma-options2.7z");
        LZMA2Options opts = new LZMA2Options(1);
        this.createAndReadBack(this.output, Collections.singletonList(new SevenZMethodConfiguration(SevenZMethod.LZMA, (Object)opts)));
    }

    @Test
    public void testLzma2WithIntConfiguration() throws Exception {
        this.output = new File(this.dir, "lzma2-options.7z");
        this.createAndReadBack(this.output, Collections.singletonList(new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)0x100000)));
    }

    @Test
    public void testLzma2WithOptionsConfiguration() throws Exception {
        this.output = new File(this.dir, "lzma2-options2.7z");
        LZMA2Options opts = new LZMA2Options(1);
        this.createAndReadBack(this.output, Collections.singletonList(new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)opts)));
    }

    @Test
    public void testArchiveWithMixedMethods() throws Exception {
        this.output = new File(this.dir, "mixed-methods.7z");
        try (SevenZOutputFile outArchive = new SevenZOutputFile(this.output);){
            this.addFile(outArchive, 0, true);
            this.addFile(outArchive, 1, true, Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.BZIP2)));
        }
        var2_2 = null;
        try (SevenZFile archive = new SevenZFile(this.output);){
            Assert.assertEquals((Object)Boolean.TRUE, (Object)this.verifyFile(archive, 0, Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.LZMA2))));
            Assert.assertEquals((Object)Boolean.TRUE, (Object)this.verifyFile(archive, 1, Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.BZIP2))));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    private void testCompress252(int numberOfFiles, int numberOfNonEmptyFiles) throws Exception {
        int nonEmptyModulus = numberOfNonEmptyFiles != 0 ? numberOfFiles / numberOfNonEmptyFiles : numberOfFiles + 1;
        int nonEmptyFilesAdded = 0;
        this.output = new File(this.dir, "COMPRESS252-" + numberOfFiles + "-" + numberOfNonEmptyFiles + ".7z");
        try (SevenZOutputFile archive = new SevenZOutputFile(this.output);){
            this.addDir(archive);
            for (int i = 0; i < numberOfFiles; ++i) {
                this.addFile(archive, i, (i + 1) % nonEmptyModulus == 0 && nonEmptyFilesAdded++ < numberOfNonEmptyFiles);
            }
        }
        this.verifyCompress252(this.output, numberOfFiles, numberOfNonEmptyFiles);
    }

    private void verifyCompress252(File output, int numberOfFiles, int numberOfNonEmptyFiles) throws Exception {
        int filesFound = 0;
        int nonEmptyFilesFound = 0;
        try (SevenZFile archive = new SevenZFile(output);){
            this.verifyDir(archive);
            Boolean b = this.verifyFile(archive, filesFound++);
            while (b != null) {
                if (Boolean.TRUE.equals(b)) {
                    ++nonEmptyFilesFound;
                }
                b = this.verifyFile(archive, filesFound++);
            }
        }
        Assert.assertEquals((long)(numberOfFiles + 1), (long)filesFound);
        Assert.assertEquals((long)numberOfNonEmptyFiles, (long)nonEmptyFilesFound);
    }

    private void addDir(SevenZOutputFile archive) throws Exception {
        SevenZArchiveEntry entry = archive.createArchiveEntry(this.dir, "foo/");
        archive.putArchiveEntry((ArchiveEntry)entry);
        archive.closeArchiveEntry();
    }

    private void verifyDir(SevenZFile archive) throws Exception {
        SevenZArchiveEntry entry = archive.getNextEntry();
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)"foo/", (Object)entry.getName());
        Assert.assertTrue((boolean)entry.isDirectory());
    }

    private void addFile(SevenZOutputFile archive, int index, boolean nonEmpty) throws Exception {
        this.addFile(archive, index, nonEmpty, null);
    }

    private void addFile(SevenZOutputFile archive, int index, boolean nonEmpty, Iterable<SevenZMethodConfiguration> methods) throws Exception {
        byte[] byArray;
        SevenZArchiveEntry entry = new SevenZArchiveEntry();
        entry.setName("foo/" + index + ".txt");
        entry.setContentMethods(methods);
        archive.putArchiveEntry((ArchiveEntry)entry);
        if (nonEmpty) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 65;
        } else {
            byArray = new byte[]{};
        }
        archive.write(byArray);
        archive.closeArchiveEntry();
    }

    private Boolean verifyFile(SevenZFile archive, int index) throws Exception {
        return this.verifyFile(archive, index, null);
    }

    private Boolean verifyFile(SevenZFile archive, int index, Iterable<SevenZMethodConfiguration> methods) throws Exception {
        SevenZArchiveEntry entry = archive.getNextEntry();
        if (entry == null) {
            return null;
        }
        Assert.assertEquals((Object)("foo/" + index + ".txt"), (Object)entry.getName());
        Assert.assertFalse((boolean)entry.isDirectory());
        if (entry.getSize() == 0L) {
            return Boolean.FALSE;
        }
        Assert.assertEquals((long)1L, (long)entry.getSize());
        Assert.assertEquals((long)65L, (long)archive.read());
        Assert.assertEquals((long)-1L, (long)archive.read());
        if (methods != null) {
            SevenZOutputFileTest.assertContentMethodsEquals(methods, entry.getContentMethods());
        }
        return Boolean.TRUE;
    }

    private void testRoundTrip(SevenZMethod method) throws Exception {
        this.output = new File(this.dir, method + "-roundtrip.7z");
        ArrayList<SevenZMethodConfiguration> methods = new ArrayList<SevenZMethodConfiguration>();
        methods.add(new SevenZMethodConfiguration(method));
        this.createAndReadBack(this.output, methods);
    }

    private void testFilterRoundTrip(SevenZMethodConfiguration method) throws Exception {
        this.output = new File(this.dir, method.getMethod() + "-roundtrip.7z");
        ArrayList<SevenZMethodConfiguration> methods = new ArrayList<SevenZMethodConfiguration>();
        methods.add(method);
        methods.add(new SevenZMethodConfiguration(SevenZMethod.LZMA2));
        this.createAndReadBack(this.output, methods);
    }

    private void createAndReadBack(File output, Iterable<SevenZMethodConfiguration> methods) throws Exception {
        try (SevenZOutputFile outArchive = new SevenZOutputFile(output);){
            outArchive.setContentMethods(methods);
            this.addFile(outArchive, 0, true);
        }
        var4_4 = null;
        try (SevenZFile archive = new SevenZFile(output);){
            Assert.assertEquals((Object)Boolean.TRUE, (Object)this.verifyFile(archive, 0, methods));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    private void createAndReadBack(SeekableInMemoryByteChannel output, Iterable<SevenZMethodConfiguration> methods) throws Exception {
        try (SevenZOutputFile outArchive = new SevenZOutputFile((SeekableByteChannel)output);){
            outArchive.setContentMethods(methods);
            this.addFile(outArchive, 0, true);
        }
        var4_4 = null;
        try (SevenZFile archive = new SevenZFile((SeekableByteChannel)new SeekableInMemoryByteChannel(output.array()), "in memory");){
            Assert.assertEquals((Object)Boolean.TRUE, (Object)this.verifyFile(archive, 0, methods));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    private static void assertContentMethodsEquals(Iterable<? extends SevenZMethodConfiguration> expected, Iterable<? extends SevenZMethodConfiguration> actual) {
        Assert.assertNotNull(actual);
        Iterator<? extends SevenZMethodConfiguration> expectedIter = expected.iterator();
        Iterator<? extends SevenZMethodConfiguration> actualIter = actual.iterator();
        while (expectedIter.hasNext()) {
            Assert.assertTrue((boolean)actualIter.hasNext());
            SevenZMethodConfiguration expConfig = expectedIter.next();
            SevenZMethodConfiguration actConfig = actualIter.next();
            Assert.assertEquals((Object)expConfig.getMethod(), (Object)actConfig.getMethod());
        }
        Assert.assertFalse((boolean)actualIter.hasNext());
    }

    static {
        String version = XZ.class.getPackage().getImplementationVersion();
        boolean bl = XZ_BCJ_IS_BUGGY = version != null && version.equals("1.4");
        if (XZ_BCJ_IS_BUGGY) {
            System.out.println("XZ version is " + version + " - skipping BCJ tests");
        }
    }
}

