/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.examples;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.StreamingNotSupportedException;
import org.apache.commons.compress.archivers.examples.Expander;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.apache.commons.compress.archivers.tar.TarFile;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ExpanderTest
extends AbstractTestCase {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private File archive;

    @Test
    public void sevenZTwoFileVersion() throws IOException, ArchiveException {
        this.setup7z();
        new Expander().expand("7z", this.archive, this.resultDir);
        this.verifyTargetDir();
    }

    @Test
    public void sevenZTwoFileVersionWithAutoDetection() throws IOException, ArchiveException {
        this.setup7z();
        new Expander().expand(this.archive, this.resultDir);
        this.verifyTargetDir();
    }

    @Test(expected=StreamingNotSupportedException.class)
    public void sevenZInputStreamVersion() throws IOException, ArchiveException {
        this.setup7z();
        try (BufferedInputStream i = new BufferedInputStream(Files.newInputStream(this.archive.toPath(), new OpenOption[0]));){
            new Expander().expand("7z", (InputStream)i, this.resultDir);
        }
    }

    @Test(expected=StreamingNotSupportedException.class)
    public void sevenZInputStreamVersionWithAutoDetection() throws IOException, ArchiveException {
        this.setup7z();
        try (BufferedInputStream i = new BufferedInputStream(Files.newInputStream(this.archive.toPath(), new OpenOption[0]));){
            new Expander().expand((InputStream)i, this.resultDir);
        }
    }

    @Test
    public void sevenZChannelVersion() throws IOException, ArchiveException {
        this.setup7z();
        try (FileChannel c = FileChannel.open(this.archive.toPath(), StandardOpenOption.READ);){
            new Expander().expand("7z", (SeekableByteChannel)c, this.resultDir);
        }
        this.verifyTargetDir();
    }

    @Test
    public void sevenZFileVersion() throws IOException, ArchiveException {
        this.setup7z();
        try (SevenZFile f = new SevenZFile(this.archive);){
            new Expander().expand(f, this.resultDir);
        }
        this.verifyTargetDir();
    }

    @Test
    public void zipFileVersion() throws IOException, ArchiveException {
        this.setupZip();
        try (ZipFile f = new ZipFile(this.archive);){
            new Expander().expand(f, this.resultDir);
        }
        this.verifyTargetDir();
    }

    @Test
    public void fileCantEscapeViaAbsolutePath() throws IOException, ArchiveException {
        this.setupZip("/tmp/foo");
        try (ZipFile f = new ZipFile(this.archive);){
            new Expander().expand(f, this.resultDir);
        }
        this.assertHelloWorld("tmp/foo", "1");
    }

    @Test
    public void fileCantEscapeDoubleDotPath() throws IOException, ArchiveException {
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("Expanding ../foo would create file outside of");
        this.setupZip("../foo");
        try (ZipFile f = new ZipFile(this.archive);){
            new Expander().expand(f, this.resultDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fileCantEscapeDoubleDotPathWithSimilarSibling() throws IOException, ArchiveException {
        String sibling = this.resultDir.getName() + "x";
        File s = new File(this.resultDir.getParentFile(), sibling);
        Assume.assumeFalse((boolean)s.exists());
        s.mkdirs();
        Assume.assumeTrue((boolean)s.exists());
        s.deleteOnExit();
        try {
            this.thrown.expect(IOException.class);
            this.thrown.expectMessage("Expanding ../" + sibling + "/a would create file outside of");
            this.setupZip("../" + sibling + "/a");
            try (ZipFile f = new ZipFile(this.archive);){
                new Expander().expand(f, this.resultDir);
            }
        }
        finally {
            ExpanderTest.tryHardToDelete(s);
        }
    }

    @Test
    public void tarFileVersion() throws IOException, ArchiveException {
        this.setupTar();
        try (TarFile f = new TarFile(this.archive);){
            new Expander().expand(f, this.resultDir);
        }
        this.verifyTargetDir();
    }

    private void setup7z() throws IOException, ArchiveException {
        this.archive = new File(this.dir, "test.7z");
        File dummy = new File(this.dir, "x");
        try (OutputStream o = Files.newOutputStream(dummy.toPath(), new OpenOption[0]);){
            o.write(new byte[14]);
        }
        var3_3 = null;
        try (SevenZOutputFile aos = new SevenZOutputFile(this.archive);){
            aos.putArchiveEntry((ArchiveEntry)aos.createArchiveEntry(this.dir, "a"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry((ArchiveEntry)aos.createArchiveEntry(this.dir, "a/b"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry((ArchiveEntry)aos.createArchiveEntry(this.dir, "a/b/c"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry((ArchiveEntry)aos.createArchiveEntry(dummy, "a/b/d.txt"));
            aos.write("Hello, world 1".getBytes(StandardCharsets.UTF_8));
            aos.closeArchiveEntry();
            aos.putArchiveEntry((ArchiveEntry)aos.createArchiveEntry(dummy, "a/b/c/e.txt"));
            aos.write("Hello, world 2".getBytes(StandardCharsets.UTF_8));
            aos.closeArchiveEntry();
            aos.finish();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    private void setupZip() throws IOException, ArchiveException {
        this.archive = new File(this.dir, "test.zip");
        File dummy = new File(this.dir, "x");
        try (OutputStream o = Files.newOutputStream(dummy.toPath(), new OpenOption[0]);){
            o.write(new byte[14]);
        }
        var3_3 = null;
        try (ArchiveOutputStream aos = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("zip", Files.newOutputStream(this.archive.toPath(), new OpenOption[0]));){
            aos.putArchiveEntry(aos.createArchiveEntry(this.dir, "a"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(this.dir, "a/b"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(this.dir, "a/b/c"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(dummy, "a/b/d.txt"));
            aos.write("Hello, world 1".getBytes(StandardCharsets.UTF_8));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(dummy, "a/b/c/e.txt"));
            aos.write("Hello, world 2".getBytes(StandardCharsets.UTF_8));
            aos.closeArchiveEntry();
            aos.finish();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    private void setupTar() throws IOException, ArchiveException {
        this.archive = new File(this.dir, "test.tar");
        File dummy = new File(this.dir, "x");
        try (OutputStream o = Files.newOutputStream(dummy.toPath(), new OpenOption[0]);){
            o.write(new byte[14]);
        }
        var3_3 = null;
        try (ArchiveOutputStream aos = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("tar", Files.newOutputStream(this.archive.toPath(), new OpenOption[0]));){
            aos.putArchiveEntry(aos.createArchiveEntry(this.dir, "a"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(this.dir, "a/b"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(this.dir, "a/b/c"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(dummy, "a/b/d.txt"));
            aos.write("Hello, world 1".getBytes(StandardCharsets.UTF_8));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(dummy, "a/b/c/e.txt"));
            aos.write("Hello, world 2".getBytes(StandardCharsets.UTF_8));
            aos.closeArchiveEntry();
            aos.finish();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    private void setupZip(String entry) throws IOException, ArchiveException {
        this.archive = new File(this.dir, "test.zip");
        File dummy = new File(this.dir, "x");
        try (OutputStream o = Files.newOutputStream(dummy.toPath(), new OpenOption[0]);){
            o.write(new byte[14]);
        }
        var4_4 = null;
        try (ArchiveOutputStream aos = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("zip", Files.newOutputStream(this.archive.toPath(), new OpenOption[0]));){
            aos.putArchiveEntry(aos.createArchiveEntry(dummy, entry));
            aos.write("Hello, world 1".getBytes(StandardCharsets.UTF_8));
            aos.closeArchiveEntry();
            aos.finish();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    private void verifyTargetDir() throws IOException {
        Assert.assertTrue((String)"a has not been created", (boolean)new File(this.resultDir, "a").isDirectory());
        Assert.assertTrue((String)"a/b has not been created", (boolean)new File(this.resultDir, "a/b").isDirectory());
        Assert.assertTrue((String)"a/b/c has not been created", (boolean)new File(this.resultDir, "a/b/c").isDirectory());
        this.assertHelloWorld("a/b/d.txt", "1");
        this.assertHelloWorld("a/b/c/e.txt", "2");
    }

    private void assertHelloWorld(String fileName, String suffix) throws IOException {
        Assert.assertTrue((String)(fileName + " does not exist"), (boolean)new File(this.resultDir, fileName).isFile());
        byte[] expected = ("Hello, world " + suffix).getBytes(StandardCharsets.UTF_8);
        try (InputStream is = Files.newInputStream(new File(this.resultDir, fileName).toPath(), new OpenOption[0]);){
            byte[] actual = IOUtils.toByteArray((InputStream)is);
            Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }
}

