/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.cpio;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class CpioArchiveInputStreamTest
extends AbstractTestCase {
    @Test
    public void testCpioUnarchive() throws Exception {
        StringBuilder expected = new StringBuilder();
        expected.append("./test1.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>./test2.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>\n");
        StringBuilder result = new StringBuilder();
        try (CpioArchiveInputStream in = new CpioArchiveInputStream(Files.newInputStream(CpioArchiveInputStreamTest.getFile("bla.cpio").toPath(), new OpenOption[0]));){
            CpioArchiveEntry entry;
            while ((entry = (CpioArchiveEntry)in.getNextEntry()) != null) {
                int tmp;
                result.append(entry.getName());
                while ((tmp = in.read()) != -1) {
                    result.append((char)tmp);
                }
            }
        }
        Assert.assertEquals((Object)result.toString(), (Object)expected.toString());
    }

    @Test
    public void testCpioUnarchiveCreatedByRedlineRpm() throws Exception {
        int count = 0;
        try (CpioArchiveInputStream in = new CpioArchiveInputStream(Files.newInputStream(CpioArchiveInputStreamTest.getFile("redline.cpio").toPath(), new OpenOption[0]));){
            CpioArchiveEntry entry = null;
            while ((entry = (CpioArchiveEntry)in.getNextEntry()) != null) {
                ++count;
                Assert.assertNotNull((Object)entry);
            }
        }
        Assert.assertEquals((long)count, (long)1L);
    }

    @Test
    public void testCpioUnarchiveMultibyteCharName() throws Exception {
        int count = 0;
        try (CpioArchiveInputStream in = new CpioArchiveInputStream(Files.newInputStream(CpioArchiveInputStreamTest.getFile("COMPRESS-459.cpio").toPath(), new OpenOption[0]), "UTF-8");){
            CpioArchiveEntry entry = null;
            while ((entry = (CpioArchiveEntry)in.getNextEntry()) != null) {
                ++count;
                Assert.assertNotNull((Object)entry);
            }
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        try (InputStream in = Files.newInputStream(CpioArchiveInputStreamTest.getFile("bla.cpio").toPath(), new OpenOption[0]);
             CpioArchiveInputStream archive = new CpioArchiveInputStream(in);){
            ArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assert.assertEquals((long)-1L, (long)archive.read());
            Assert.assertEquals((long)-1L, (long)archive.read());
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        byte[] buf = new byte[2];
        try (InputStream in = Files.newInputStream(CpioArchiveInputStreamTest.getFile("bla.cpio").toPath(), new OpenOption[0]);
             CpioArchiveInputStream archive = new CpioArchiveInputStream(in);){
            ArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assert.assertEquals((long)-1L, (long)archive.read(buf));
            Assert.assertEquals((long)-1L, (long)archive.read(buf));
        }
    }
}

