/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.MockEvilInputStream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.StreamingNotSupportedException;
import org.apache.commons.compress.archivers.arj.ArjArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.dump.DumpArchiveInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.utils.ByteUtils;
import org.junit.Assert;
import org.junit.Test;

public class ArchiveStreamFactoryTest {
    private static final String UNKNOWN = "??";
    private static final ArchiveStreamFactory FACTORY = ArchiveStreamFactory.DEFAULT;
    private static final ArchiveStreamFactory FACTORY_UTF8 = new ArchiveStreamFactory("UTF-8");
    private static final ArchiveStreamFactory FACTORY_ASCII = new ArchiveStreamFactory("ASCII");
    private static final ArchiveStreamFactory FACTORY_SET_UTF8 = ArchiveStreamFactoryTest.getFactory("UTF-8");
    private static final ArchiveStreamFactory FACTORY_SET_ASCII = ArchiveStreamFactoryTest.getFactory("ASCII");
    private static final String ARJ_DEFAULT;
    private static final String DUMP_DEFAULT;
    private static final String ZIP_DEFAULT;
    private static final String CPIO_DEFAULT;
    private static final String TAR_DEFAULT;
    private static final String JAR_DEFAULT;
    static final TestData[] TESTS;

    @Test
    public void shortTextFilesAreNoTARs() {
        try {
            ArchiveStreamFactory.DEFAULT.createArchiveInputStream((InputStream)new ByteArrayInputStream("This certainly is not a tar archive, really, no kidding".getBytes()));
            Assert.fail((String)"created an input stream for a non-archive");
        }
        catch (ArchiveException ae) {
            Assert.assertTrue((boolean)ae.getMessage().startsWith("No Archiver found"));
        }
    }

    @Test
    public void aiffFilesAreNoTARs() throws Exception {
        try (InputStream fis = Files.newInputStream(new File("src/test/resources/testAIFF.aif").toPath(), new OpenOption[0]);){
            try (BufferedInputStream is = new BufferedInputStream(fis);){
                ArchiveStreamFactory.DEFAULT.createArchiveInputStream((InputStream)is);
                Assert.fail((String)"created an input stream for a non-archive");
            }
            catch (ArchiveException ae) {
                Assert.assertTrue((boolean)ae.getMessage().startsWith("No Archiver found"));
            }
        }
    }

    @Test
    public void testCOMPRESS209() throws Exception {
        try (InputStream fis = Files.newInputStream(new File("src/test/resources/testCompress209.doc").toPath(), new OpenOption[0]);){
            try (BufferedInputStream bis = new BufferedInputStream(fis);){
                ArchiveStreamFactory.DEFAULT.createArchiveInputStream((InputStream)bis);
                Assert.fail((String)"created an input stream for a non-archive");
            }
            catch (ArchiveException ae) {
                Assert.assertTrue((boolean)ae.getMessage().startsWith("No Archiver found"));
            }
        }
    }

    @Test(expected=StreamingNotSupportedException.class)
    public void cantRead7zFromStream() throws Exception {
        ArchiveStreamFactory.DEFAULT.createArchiveInputStream("7z", (InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY));
    }

    @Test(expected=StreamingNotSupportedException.class)
    public void cantWrite7zToStream() throws Exception {
        ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("7z", (OutputStream)new ByteArrayOutputStream());
    }

    @Test
    public void detectsAndThrowsFor7z() throws Exception {
        try (InputStream fis = Files.newInputStream(new File("src/test/resources/bla.7z").toPath(), new OpenOption[0]);){
            try (BufferedInputStream bis = new BufferedInputStream(fis);){
                ArchiveStreamFactory.DEFAULT.createArchiveInputStream((InputStream)bis);
                Assert.fail((String)"Expected a StreamingNotSupportedException");
            }
            catch (StreamingNotSupportedException ex) {
                Assert.assertEquals((Object)"7z", (Object)ex.getFormat());
            }
        }
    }

    @Test
    public void skipsPK00Prefix() throws Exception {
        try (InputStream fis = Files.newInputStream(new File("src/test/resources/COMPRESS-208.zip").toPath(), new OpenOption[0]);
             BufferedInputStream bis = new BufferedInputStream(fis);
             ArchiveInputStream ais = ArchiveStreamFactory.DEFAULT.createArchiveInputStream((InputStream)bis);){
            Assert.assertTrue((boolean)(ais instanceof ZipArchiveInputStream));
        }
    }

    @Test
    public void testEncodingCtor() {
        ArchiveStreamFactory fac = new ArchiveStreamFactory();
        Assert.assertNull((Object)fac.getEntryEncoding());
        fac = new ArchiveStreamFactory(null);
        Assert.assertNull((Object)fac.getEntryEncoding());
        fac = new ArchiveStreamFactory("UTF-8");
        Assert.assertEquals((Object)"UTF-8", (Object)fac.getEntryEncoding());
    }

    @Test
    public void testEncodingDeprecated() {
        ArchiveStreamFactory fac = new ArchiveStreamFactory();
        Assert.assertNull((Object)fac.getEntryEncoding());
        fac.setEntryEncoding("UTF-8");
        Assert.assertEquals((Object)"UTF-8", (Object)fac.getEntryEncoding());
        fac.setEntryEncoding("US_ASCII");
        Assert.assertEquals((Object)"US_ASCII", (Object)fac.getEntryEncoding());
        fac = new ArchiveStreamFactory("UTF-8");
        Assert.assertEquals((Object)"UTF-8", (Object)fac.getEntryEncoding());
        try {
            fac.setEntryEncoding("US_ASCII");
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    static ArchiveStreamFactory getFactory(String entryEncoding) {
        ArchiveStreamFactory fac = new ArchiveStreamFactory();
        fac.setEntryEncoding(entryEncoding);
        return fac;
    }

    @Test
    public void testDetect() throws Exception {
        for (String extension : new String[]{"ar", "arj", "cpio", "dump", "7z", "tar", "zip"}) {
            Assert.assertEquals((Object)extension, (Object)this.detect("bla." + extension));
        }
        try {
            ArchiveStreamFactory.detect((InputStream)new BufferedInputStream(new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY)));
            Assert.fail((String)"shouldn't be able to detect empty stream");
        }
        catch (ArchiveException e) {
            Assert.assertEquals((Object)"No Archiver found for the stream signature", (Object)e.getMessage());
        }
        try {
            ArchiveStreamFactory.detect(null);
            Assert.fail((String)"shouldn't be able to detect null stream");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Stream must not be null.", (Object)e.getMessage());
        }
        try {
            ArchiveStreamFactory.detect((InputStream)new BufferedInputStream(new MockEvilInputStream()));
            Assert.fail((String)"Expected ArchiveException");
        }
        catch (ArchiveException e) {
            Assert.assertEquals((Object)"IOException while reading signature.", (Object)e.getMessage());
        }
    }

    private String detect(String resource) throws IOException, ArchiveException {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(AbstractTestCase.getFile(resource).toPath(), new OpenOption[0]));){
            String string = ArchiveStreamFactory.detect((InputStream)in);
            return string;
        }
    }

    @Test
    public void testEncodingInputStreamAutodetect() throws Exception {
        int failed = 0;
        for (int i = 1; i <= TESTS.length; ++i) {
            TestData test = TESTS[i - 1];
            try (ArchiveInputStream ais = this.getInputStreamFor(test.testFile, test.fac);){
                String field = ArchiveStreamFactoryTest.getField(ais, test.fieldName);
                if (ArchiveStreamFactoryTest.eq(test.expectedEncoding, field)) continue;
                System.out.println("Failed test " + i + ". expected: " + test.expectedEncoding + " actual: " + field + " type: " + test.type);
                ++failed;
                continue;
            }
        }
        if (failed > 0) {
            Assert.fail((String)("Tests failed: " + failed + " out of " + TESTS.length));
        }
    }

    @Test
    public void testEncodingInputStream() throws Exception {
        int failed = 0;
        for (int i = 1; i <= TESTS.length; ++i) {
            TestData test = TESTS[i - 1];
            try (ArchiveInputStream ais = this.getInputStreamFor(test.type, test.testFile, test.fac);){
                String field = ArchiveStreamFactoryTest.getField(ais, test.fieldName);
                if (ArchiveStreamFactoryTest.eq(test.expectedEncoding, field)) continue;
                System.out.println("Failed test " + i + ". expected: " + test.expectedEncoding + " actual: " + field + " type: " + test.type);
                ++failed;
                continue;
            }
        }
        if (failed > 0) {
            Assert.fail((String)("Tests failed: " + failed + " out of " + TESTS.length));
        }
    }

    @Test
    public void testEncodingOutputStream() throws Exception {
        int failed = 0;
        for (int i = 1; i <= TESTS.length; ++i) {
            TestData test = TESTS[i - 1];
            if (!test.hasOutputStream) continue;
            try (ArchiveOutputStream ais = this.getOutputStreamFor(test.type, test.fac);){
                String field = ArchiveStreamFactoryTest.getField(ais, test.fieldName);
                if (ArchiveStreamFactoryTest.eq(test.expectedEncoding, field)) continue;
                System.out.println("Failed test " + i + ". expected: " + test.expectedEncoding + " actual: " + field + " type: " + test.type);
                ++failed;
                continue;
            }
        }
        if (failed > 0) {
            Assert.fail((String)("Tests failed: " + failed + " out of " + TESTS.length));
        }
    }

    private static boolean eq(String exp, String act) {
        if (exp == null) {
            return act == null;
        }
        return exp.equals(act);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getField(Object instance, String name) {
        Field fld;
        Class<?> cls = instance.getClass();
        try {
            fld = cls.getDeclaredField(name);
        }
        catch (NoSuchFieldException nsfe) {
            try {
                fld = cls.getSuperclass().getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                System.out.println("Cannot find " + name + " in class " + instance.getClass().getSimpleName());
                return UNKNOWN;
            }
        }
        boolean isAccessible = fld.isAccessible();
        try {
            Object object;
            if (!isAccessible) {
                fld.setAccessible(true);
            }
            if ((object = fld.get(instance)) instanceof String || object == null) {
                String string = (String)object;
                return string;
            }
            System.out.println("Wrong type: " + object.getClass().getCanonicalName() + " for " + name + " in class " + instance.getClass().getSimpleName());
            String string = UNKNOWN;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = UNKNOWN;
            return string;
        }
        finally {
            if (!isAccessible) {
                fld.setAccessible(isAccessible);
            }
        }
    }

    private ArchiveInputStream getInputStreamFor(String resource, ArchiveStreamFactory factory) throws IOException, ArchiveException {
        return factory.createArchiveInputStream((InputStream)new BufferedInputStream(Files.newInputStream(AbstractTestCase.getFile(resource).toPath(), new OpenOption[0])));
    }

    private ArchiveInputStream getInputStreamFor(String type, String resource, ArchiveStreamFactory factory) throws IOException, ArchiveException {
        return factory.createArchiveInputStream(type, (InputStream)new BufferedInputStream(Files.newInputStream(AbstractTestCase.getFile(resource).toPath(), new OpenOption[0])));
    }

    private ArchiveOutputStream getOutputStreamFor(String type, ArchiveStreamFactory factory) throws ArchiveException {
        return factory.createArchiveOutputStream(type, (OutputStream)new ByteArrayOutputStream());
    }

    static {
        ZIP_DEFAULT = ArchiveStreamFactoryTest.getField(new ZipArchiveInputStream(null), "encoding");
        CPIO_DEFAULT = ArchiveStreamFactoryTest.getField(new CpioArchiveInputStream(null), "encoding");
        TAR_DEFAULT = ArchiveStreamFactoryTest.getField(new TarArchiveInputStream(null), "encoding");
        JAR_DEFAULT = ArchiveStreamFactoryTest.getField(new JarArchiveInputStream(null), "encoding");
        String dflt = UNKNOWN;
        try {
            dflt = ArchiveStreamFactoryTest.getField(new ArjArchiveInputStream(Files.newInputStream(AbstractTestCase.getFile("bla.arj").toPath(), new OpenOption[0])), "charsetName");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ARJ_DEFAULT = dflt;
        dflt = UNKNOWN;
        try {
            dflt = ArchiveStreamFactoryTest.getField(new DumpArchiveInputStream(Files.newInputStream(AbstractTestCase.getFile("bla.dump").toPath(), new OpenOption[0])), "encoding");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DUMP_DEFAULT = dflt;
        TESTS = new TestData[]{new TestData("bla.arj", "arj", false, ARJ_DEFAULT, FACTORY, "charsetName"), new TestData("bla.arj", "arj", false, "UTF-8", FACTORY_UTF8, "charsetName"), new TestData("bla.arj", "arj", false, "ASCII", FACTORY_ASCII, "charsetName"), new TestData("bla.arj", "arj", false, "UTF-8", FACTORY_SET_UTF8, "charsetName"), new TestData("bla.arj", "arj", false, "ASCII", FACTORY_SET_ASCII, "charsetName"), new TestData("bla.cpio", "cpio", true, CPIO_DEFAULT, FACTORY, "encoding"), new TestData("bla.cpio", "cpio", true, "UTF-8", FACTORY_UTF8, "encoding"), new TestData("bla.cpio", "cpio", true, "ASCII", FACTORY_ASCII, "encoding"), new TestData("bla.cpio", "cpio", true, "UTF-8", FACTORY_SET_UTF8, "encoding"), new TestData("bla.cpio", "cpio", true, "ASCII", FACTORY_SET_ASCII, "encoding"), new TestData("bla.dump", "dump", false, DUMP_DEFAULT, FACTORY, "encoding"), new TestData("bla.dump", "dump", false, "UTF-8", FACTORY_UTF8, "encoding"), new TestData("bla.dump", "dump", false, "ASCII", FACTORY_ASCII, "encoding"), new TestData("bla.dump", "dump", false, "UTF-8", FACTORY_SET_UTF8, "encoding"), new TestData("bla.dump", "dump", false, "ASCII", FACTORY_SET_ASCII, "encoding"), new TestData("bla.tar", "tar", true, TAR_DEFAULT, FACTORY, "encoding"), new TestData("bla.tar", "tar", true, "UTF-8", FACTORY_UTF8, "encoding"), new TestData("bla.tar", "tar", true, "ASCII", FACTORY_ASCII, "encoding"), new TestData("bla.tar", "tar", true, "UTF-8", FACTORY_SET_UTF8, "encoding"), new TestData("bla.tar", "tar", true, "ASCII", FACTORY_SET_ASCII, "encoding"), new TestData("bla.jar", "jar", true, JAR_DEFAULT, FACTORY, "encoding"), new TestData("bla.jar", "jar", true, "UTF-8", FACTORY_UTF8, "encoding"), new TestData("bla.jar", "jar", true, "ASCII", FACTORY_ASCII, "encoding"), new TestData("bla.jar", "jar", true, "UTF-8", FACTORY_SET_UTF8, "encoding"), new TestData("bla.jar", "jar", true, "ASCII", FACTORY_SET_ASCII, "encoding"), new TestData("bla.zip", "zip", true, ZIP_DEFAULT, FACTORY, "encoding"), new TestData("bla.zip", "zip", true, "UTF-8", FACTORY_UTF8, "encoding"), new TestData("bla.zip", "zip", true, "ASCII", FACTORY_ASCII, "encoding"), new TestData("bla.zip", "zip", true, "UTF-8", FACTORY_SET_UTF8, "encoding"), new TestData("bla.zip", "zip", true, "ASCII", FACTORY_SET_ASCII, "encoding")};
    }

    static class TestData {
        final String testFile;
        final String expectedEncoding;
        final ArchiveStreamFactory fac;
        final String fieldName;
        final String type;
        final boolean hasOutputStream;

        TestData(String testFile, String type, boolean hasOut, String expectedEncoding, ArchiveStreamFactory fac, String fieldName) {
            this.testFile = testFile;
            this.expectedEncoding = expectedEncoding;
            this.fac = fac;
            this.fieldName = fieldName;
            this.type = type;
            this.hasOutputStream = hasOut;
        }

        public String toString() {
            return "TestData [testFile=" + this.testFile + ", expectedEncoding=" + this.expectedEncoding + ", fac=" + this.fac + ", fieldName=" + this.fieldName + ", type=" + this.type + ", hasOutputStream=" + this.hasOutputStream + "]";
        }
    }
}

