/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import org.apache.commons.collections4.bloomfilter.BitMaps;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BitMapsTest {
    private void assertMod(long dividend, int divisor) {
        Assertions.assertTrue((divisor > 0 && divisor <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Incorrect usage. Divisor must be strictly positive.");
        Assertions.assertEquals((int)((int)Long.remainderUnsigned(dividend, divisor)), (int)BitMaps.mod((long)dividend, (int)divisor), () -> String.format("failure with dividend=%s and divisor=%s.", dividend, divisor));
    }

    @Test
    public final void testContains() {
        long[] ary;
        long[] bitMaps = new long[1];
        for (int i = 0; i < 64; ++i) {
            bitMaps[0] = 0L;
            BitMaps.set((long[])bitMaps, (int)i);
            for (int j = 0; j < 64; ++j) {
                if (j == i) {
                    Assertions.assertTrue((boolean)BitMaps.contains((long[])bitMaps, (int)j), (String)String.format("Failed at index: %d for %d", i, j));
                    continue;
                }
                Assertions.assertFalse((boolean)BitMaps.contains((long[])bitMaps, (int)j), (String)String.format("Failed at index %d for %d", i, j));
            }
        }
        long[] aryT = ary = new long[1];
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> BitMaps.contains((long[])aryT, (int)-1));
        Assertions.assertFalse((boolean)BitMaps.contains((long[])ary, (int)0));
        ary[0] = 1L;
        Assertions.assertTrue((boolean)BitMaps.contains((long[])ary, (int)0));
        Assertions.assertFalse((boolean)BitMaps.contains((long[])ary, (int)63));
        ary[0] = Long.MIN_VALUE;
        Assertions.assertTrue((boolean)BitMaps.contains((long[])ary, (int)63));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> BitMaps.contains((long[])aryT, (int)64));
        ary = new long[2];
        Assertions.assertFalse((boolean)BitMaps.contains((long[])ary, (int)64));
        ary[1] = 1L;
        Assertions.assertTrue((boolean)BitMaps.contains((long[])ary, (int)64));
    }

    @Test
    public final void testGetLongBit() {
        Assertions.assertEquals((long)1L, (long)BitMaps.getLongBit((int)0));
        Assertions.assertEquals((long)Long.MIN_VALUE, (long)BitMaps.getLongBit((int)63));
        Assertions.assertEquals((long)1L, (long)BitMaps.getLongBit((int)64));
        Assertions.assertEquals((long)Long.MIN_VALUE, (long)BitMaps.getLongBit((int)127));
        Assertions.assertEquals((long)1L, (long)BitMaps.getLongBit((int)128));
    }

    @Test
    public final void testGetLongIndex() {
        Assertions.assertEquals((int)0, (int)BitMaps.getLongIndex((int)0));
        Assertions.assertEquals((int)0, (int)BitMaps.getLongIndex((int)63));
        Assertions.assertEquals((int)1, (int)BitMaps.getLongIndex((int)64));
        Assertions.assertEquals((int)1, (int)BitMaps.getLongIndex((int)127));
        Assertions.assertEquals((int)2, (int)BitMaps.getLongIndex((int)128));
    }

    @Test
    public void testMod() {
        for (long dividend : new long[]{0L, -1L, -2L, -3L, -6378683L, -23567468136887892L, Long.MIN_VALUE, 345L, 678686L, 67868768686878924L, Long.MAX_VALUE, 0x7FFFFFFFFFFFFFFEL}) {
            for (int divisor : new int[]{1, 2, 3, 5, 13, Integer.MAX_VALUE, 0x7FFFFFFE}) {
                this.assertMod(dividend, divisor);
            }
        }
    }

    @Test
    public void testModEdgeCases() {
        for (long dividend : new long[]{0L, -1L, 1L, Long.MAX_VALUE}) {
            Assertions.assertThrows(ArithmeticException.class, () -> BitMaps.mod((long)dividend, (int)0));
        }
        Assertions.assertNotEquals((int)Math.floorMod(5, -1), (int)BitMaps.mod((long)5L, (int)-1));
    }

    @Test
    public final void testNumberOfBitMaps() {
        int i;
        Assertions.assertEquals((int)0, (int)BitMaps.numberOfBitMaps((int)0), (String)"Number of bits 0");
        for (i = 1; i < 65; ++i) {
            Assertions.assertEquals((int)1, (int)BitMaps.numberOfBitMaps((int)i), (String)String.format("Number of bits %d", i));
        }
        for (i = 65; i < 129; ++i) {
            Assertions.assertEquals((int)2, (int)BitMaps.numberOfBitMaps((int)i), (String)String.format("Number of bits %d", i));
        }
        Assertions.assertEquals((int)3, (int)BitMaps.numberOfBitMaps((int)129), (String)"Number of bits 129");
    }

    @Test
    public final void testSet() {
        long[] bitMaps = new long[BitMaps.numberOfBitMaps((int)129)];
        for (int i = 0; i < 129; ++i) {
            BitMaps.set((long[])bitMaps, (int)i);
            Assertions.assertTrue((boolean)BitMaps.contains((long[])bitMaps, (int)i), (String)String.format("Failed at index: %d", i));
        }
        Assertions.assertEquals((long)-1L, (long)bitMaps[0]);
        Assertions.assertEquals((long)-1L, (long)bitMaps[1]);
        Assertions.assertEquals((long)1L, (long)bitMaps[2]);
    }
}

