/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.HashMap;
import org.apache.commons.collections4.BoundedMap;
import org.apache.commons.collections4.KeyValue;
import org.apache.commons.collections4.OrderedMap;
import org.apache.commons.collections4.map.AbstractOrderedMapTest;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.apache.commons.collections4.map.SingletonMap;
import org.apache.commons.collections4.map.UnmodifiableOrderedMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SingletonMapTest<K, V>
extends AbstractOrderedMapTest<K, V> {
    private static final Integer ONE = 1;
    private static final Integer TWO = 2;
    private static final String TEN = "10";

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public V[] getNewSampleValues() {
        return new Object[]{TEN};
    }

    @Override
    public K[] getSampleKeys() {
        return new Object[]{ONE};
    }

    @Override
    public V[] getSampleValues() {
        return new Object[]{TWO};
    }

    @Override
    public boolean isPutAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public SingletonMap<K, V> makeFullMap() {
        return new SingletonMap((Object)ONE, (Object)TWO);
    }

    @Override
    public OrderedMap<K, V> makeObject() {
        return UnmodifiableOrderedMap.unmodifiableOrderedMap((OrderedMap)ListOrderedMap.listOrderedMap(new HashMap()));
    }

    @Test
    public void testBoundedMap() {
        SingletonMap<K, V> map = this.makeFullMap();
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertTrue((boolean)map.isFull());
        Assertions.assertEquals((int)1, (int)map.maxSize());
        Assertions.assertInstanceOf(BoundedMap.class, map);
    }

    @Test
    public void testClone() {
        SingletonMap<K, V> map = this.makeFullMap();
        Assertions.assertEquals((int)1, (int)map.size());
        SingletonMap cloned = map.clone();
        Assertions.assertEquals((int)1, (int)cloned.size());
        Assertions.assertTrue((boolean)cloned.containsKey((Object)ONE));
        Assertions.assertTrue((boolean)cloned.containsValue((Object)TWO));
    }

    @Test
    public void testKeyValue() {
        SingletonMap<K, V> map = this.makeFullMap();
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((Object)ONE, (Object)map.getKey());
        Assertions.assertEquals((Object)TWO, (Object)map.getValue());
        Assertions.assertInstanceOf(KeyValue.class, map);
    }
}

