/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.list.AbstractListTest;
import org.apache.commons.collections4.map.AbstractOrderedMapTest;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class ListOrderedMapTest<K, V>
extends AbstractOrderedMapTest<K, V> {
    public BulkTest bulkTestKeyListView() {
        return new TestKeyListView();
    }

    public BulkTest bulkTestValueListView() {
        return new TestValueListView();
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public ListOrderedMap<K, V> getMap() {
        return (ListOrderedMap)super.getMap();
    }

    @Override
    public ListOrderedMap<K, V> makeFullMap() {
        return (ListOrderedMap)super.makeFullMap();
    }

    @Override
    public ListOrderedMap<K, V> makeObject() {
        return ListOrderedMap.listOrderedMap(new HashMap());
    }

    @Test
    public void testCOLLECTIONS_474_nonNullValues() {
        Object key1 = new Object();
        Object key2 = new Object();
        HashMap<Object, String> hmap = new HashMap<Object, String>();
        hmap.put(key1, "1");
        hmap.put(key2, "2");
        Assertions.assertEquals((int)2, (int)hmap.size(), (String)"Should have two elements");
        ListOrderedMap listMap = new ListOrderedMap();
        listMap.put(key1, (Object)"3");
        listMap.put(key2, (Object)"4");
        Assertions.assertEquals((int)2, (int)listMap.size(), (String)"Should have two elements");
        listMap.putAll(2, hmap);
    }

    @Test
    public void testCOLLECTIONS_474_nullValues() {
        Object key1 = new Object();
        Object key2 = new Object();
        HashMap hmap = new HashMap();
        hmap.put(key1, null);
        hmap.put(key2, null);
        Assertions.assertEquals((int)2, (int)hmap.size(), (String)"Should have two elements");
        ListOrderedMap listMap = new ListOrderedMap();
        listMap.put(key1, null);
        listMap.put(key2, null);
        Assertions.assertEquals((int)2, (int)listMap.size(), (String)"Should have two elements");
        listMap.putAll(2, hmap);
    }

    @Test
    public void testGetByIndex() {
        this.resetEmpty();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.getMap().get(0));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.getMap().get(-1));
        this.resetFull();
        ListOrderedMap lom = this.getMap();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.getMap().get(-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> lom.get(lom.size()));
        int i = 0;
        OrderedMapIterator it = lom.mapIterator();
        while (it.hasNext()) {
            Assertions.assertSame((Object)it.next(), (Object)lom.get(i));
            ++i;
        }
    }

    @Test
    public void testGetValueByIndex() {
        this.resetEmpty();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.getMap().getValue(0));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.getMap().getValue(-1));
        this.resetFull();
        ListOrderedMap lom = this.getMap();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.getMap().getValue(-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> lom.getValue(lom.size()));
        int i = 0;
        OrderedMapIterator it = lom.mapIterator();
        while (it.hasNext()) {
            it.next();
            Assertions.assertSame((Object)it.getValue(), (Object)lom.getValue(i));
            ++i;
        }
    }

    @Test
    public void testIndexOf() {
        this.resetEmpty();
        ListOrderedMap<K, V> lom = this.getMap();
        Assertions.assertEquals((int)-1, (int)lom.indexOf(this.getOtherKeys()));
        this.resetFull();
        lom = this.getMap();
        ArrayList<Object> list = new ArrayList<Object>();
        OrderedMapIterator it = lom.mapIterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        for (int i = 0; i < list.size(); ++i) {
            Assertions.assertEquals((int)i, (int)lom.indexOf(list.get(i)));
        }
    }

    @Test
    public void testPut_intObjectObject() {
        ListOrderedMap lom;
        this.resetEmpty();
        ListOrderedMap finalLom = lom = this.getMap();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(IndexOutOfBoundsException.class, () -> finalLom.put(1, (Object)"testInsert1", (Object)"testInsert1v"), (String)"should not be able to insert at pos 1 in empty Map"), () -> Assertions.assertThrows(IndexOutOfBoundsException.class, () -> finalLom.put(-1, (Object)"testInsert-1", (Object)"testInsert-1v"), (String)"should not be able to insert at pos -1 in empty Map")});
        lom.put(0, (Object)"testInsert1", (Object)"testInsert1v");
        Assertions.assertEquals((Object)"testInsert1v", (Object)lom.getValue(0));
        lom.put((Object)"testInsertPut", (Object)"testInsertPutv");
        Assertions.assertEquals((Object)"testInsert1v", (Object)lom.getValue(0));
        Assertions.assertEquals((Object)"testInsertPutv", (Object)lom.getValue(1));
        lom.put(0, (Object)"testInsert0", (Object)"testInsert0v");
        Assertions.assertEquals((Object)"testInsert0v", (Object)lom.getValue(0));
        Assertions.assertEquals((Object)"testInsert1v", (Object)lom.getValue(1));
        Assertions.assertEquals((Object)"testInsertPutv", (Object)lom.getValue(2));
        lom.put(3, (Object)"testInsert3", (Object)"testInsert3v");
        Assertions.assertEquals((Object)"testInsert0v", (Object)lom.getValue(0));
        Assertions.assertEquals((Object)"testInsert1v", (Object)lom.getValue(1));
        Assertions.assertEquals((Object)"testInsertPutv", (Object)lom.getValue(2));
        Assertions.assertEquals((Object)"testInsert3v", (Object)lom.getValue(3));
        this.resetFull();
        lom = this.getMap();
        ListOrderedMap lom2 = new ListOrderedMap();
        lom2.putAll(lom);
        lom2.put(0, (Object)"testInsert0", (Object)"testInsert0v");
        Assertions.assertEquals((Object)"testInsert0v", (Object)lom2.getValue(0));
        for (int i = 0; i < lom.size(); ++i) {
            Assertions.assertEquals((Object)lom2.getValue(i + 1), (Object)lom.getValue(i));
        }
        Integer i1 = 1;
        Integer i1b = 1;
        Integer i2 = 2;
        Integer i3 = 3;
        this.resetEmpty();
        lom = this.getMap();
        lom.put((Object)i1, (Object)"1");
        lom.put((Object)i2, (Object)"2");
        lom.put((Object)i3, (Object)"3");
        lom.put(0, (Object)i1, (Object)"One");
        Assertions.assertEquals((int)3, (int)lom.size());
        Assertions.assertEquals((int)3, (int)lom.map.size());
        Assertions.assertEquals((int)3, (int)lom.keyList().size());
        Assertions.assertEquals((Object)"One", (Object)lom.getValue(0));
        Assertions.assertSame((Object)i1, (Object)lom.get(0));
        this.resetEmpty();
        lom = this.getMap();
        lom.put((Object)i1, (Object)"1");
        lom.put((Object)i2, (Object)"2");
        lom.put((Object)i3, (Object)"3");
        lom.put(0, (Object)i1b, (Object)"One");
        Assertions.assertEquals((int)3, (int)lom.size());
        Assertions.assertEquals((int)3, (int)lom.map.size());
        Assertions.assertEquals((int)3, (int)lom.keyList().size());
        Assertions.assertEquals((Object)"One", (Object)lom.getValue(0));
        Assertions.assertEquals((Object)"2", (Object)lom.getValue(1));
        Assertions.assertEquals((Object)"3", (Object)lom.getValue(2));
        Assertions.assertSame((Object)i1b, (Object)lom.get(0));
        this.resetEmpty();
        lom = this.getMap();
        lom.put((Object)i1, (Object)"1");
        lom.put((Object)i2, (Object)"2");
        lom.put((Object)i3, (Object)"3");
        lom.put(1, (Object)i1b, (Object)"One");
        Assertions.assertEquals((int)3, (int)lom.size());
        Assertions.assertEquals((int)3, (int)lom.map.size());
        Assertions.assertEquals((int)3, (int)lom.keyList().size());
        Assertions.assertEquals((Object)"One", (Object)lom.getValue(0));
        Assertions.assertEquals((Object)"2", (Object)lom.getValue(1));
        Assertions.assertEquals((Object)"3", (Object)lom.getValue(2));
        this.resetEmpty();
        lom = this.getMap();
        lom.put((Object)i1, (Object)"1");
        lom.put((Object)i2, (Object)"2");
        lom.put((Object)i3, (Object)"3");
        lom.put(2, (Object)i1b, (Object)"One");
        Assertions.assertEquals((int)3, (int)lom.size());
        Assertions.assertEquals((int)3, (int)lom.map.size());
        Assertions.assertEquals((int)3, (int)lom.keyList().size());
        Assertions.assertEquals((Object)"2", (Object)lom.getValue(0));
        Assertions.assertEquals((Object)"One", (Object)lom.getValue(1));
        Assertions.assertEquals((Object)"3", (Object)lom.getValue(2));
        this.resetEmpty();
        lom = this.getMap();
        lom.put((Object)i1, (Object)"1");
        lom.put((Object)i2, (Object)"2");
        lom.put((Object)i3, (Object)"3");
        lom.put(3, (Object)i1b, (Object)"One");
        Assertions.assertEquals((int)3, (int)lom.size());
        Assertions.assertEquals((int)3, (int)lom.map.size());
        Assertions.assertEquals((int)3, (int)lom.keyList().size());
        Assertions.assertEquals((Object)"2", (Object)lom.getValue(0));
        Assertions.assertEquals((Object)"3", (Object)lom.getValue(1));
        Assertions.assertEquals((Object)"One", (Object)lom.getValue(2));
    }

    @Test
    public void testPutAllWithIndex() {
        this.resetEmpty();
        ListOrderedMap lom = (ListOrderedMap)this.map;
        lom.put((Object)"testInsert0", (Object)"testInsert0v");
        lom.put((Object)"testInsert1", (Object)"testInsert1v");
        lom.put((Object)"testInsert2", (Object)"testInsert2v");
        Assertions.assertEquals((Object)"testInsert0v", (Object)lom.getValue(0));
        Assertions.assertEquals((Object)"testInsert1v", (Object)lom.getValue(1));
        Assertions.assertEquals((Object)"testInsert2v", (Object)lom.getValue(2));
        ListOrderedMap values = new ListOrderedMap();
        values.put("NewInsert0", "NewInsert0v");
        values.put("NewInsert1", "NewInsert1v");
        lom.putAll(1, (Map)values);
        Assertions.assertEquals((Object)"testInsert0v", (Object)lom.getValue(0));
        Assertions.assertEquals((Object)"NewInsert0v", (Object)lom.getValue(1));
        Assertions.assertEquals((Object)"NewInsert1v", (Object)lom.getValue(2));
        Assertions.assertEquals((Object)"testInsert1v", (Object)lom.getValue(3));
        Assertions.assertEquals((Object)"testInsert2v", (Object)lom.getValue(4));
    }

    @Test
    public void testPutAllWithIndexBug441() {
        this.resetEmpty();
        ListOrderedMap<K, V> lom = this.getMap();
        int size = 5;
        for (int i = 0; i < 5; ++i) {
            lom.put((Object)i, (Object)Boolean.TRUE);
        }
        TreeMap<Integer, Boolean> map = new TreeMap<Integer, Boolean>();
        for (int i = 0; i < 5; ++i) {
            map.put(i, Boolean.FALSE);
        }
        lom.putAll(3, map);
        List orderedList = lom.asList();
        for (int i = 0; i < 5; ++i) {
            Assertions.assertEquals((Object)i, orderedList.get(i));
        }
    }

    @Test
    public void testRemoveByIndex() {
        this.resetEmpty();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.getMap().remove(0));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.getMap().remove(-1));
        this.resetFull();
        ListOrderedMap lom = this.getMap();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.getMap().remove(-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> lom.remove(lom.size()));
        ArrayList<Object> list = new ArrayList<Object>();
        OrderedMapIterator it = lom.mapIterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        for (int i = 0; i < list.size(); ++i) {
            Object key = list.get(i);
            Object value = lom.get(key);
            Assertions.assertEquals((Object)value, (Object)lom.remove(i));
            list.remove(i);
            Assertions.assertFalse((boolean)lom.containsKey(key));
        }
    }

    @Test
    public void testSetValueByIndex() {
        this.resetEmpty();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.getMap().setValue(0, (Object)""));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.getMap().setValue(-1, (Object)""));
        this.resetFull();
        ListOrderedMap lom = this.getMap();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> lom.setValue(-1, (Object)""));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> lom.setValue(lom.size(), (Object)""));
        for (int i = 0; i < lom.size(); ++i) {
            Object value = lom.getValue(i);
            Integer input = i;
            Assertions.assertEquals((Object)value, (Object)lom.setValue(i, (Object)input));
            Assertions.assertEquals((Object)input, (Object)lom.getValue(i));
        }
    }

    @Test
    public void testValueList_getByIndex() {
        this.resetFull();
        ListOrderedMap<K, V> lom = this.getMap();
        for (int i = 0; i < lom.size(); ++i) {
            Object expected = lom.getValue(i);
            Assertions.assertEquals((Object)expected, lom.valueList().get(i));
        }
    }

    @Test
    public void testValueList_removeByIndex() {
        this.resetFull();
        ListOrderedMap<K, V> lom = this.getMap();
        while (lom.size() > 1) {
            Object expected = lom.getValue(1);
            Assertions.assertEquals((Object)expected, lom.valueList().remove(1));
        }
    }

    @Test
    public void testValueList_setByIndex() {
        this.resetFull();
        ListOrderedMap<K, V> lom = this.getMap();
        for (int i = 0; i < lom.size(); ++i) {
            Integer input = i;
            Object expected = lom.getValue(i);
            Assertions.assertEquals((Object)expected, (Object)lom.valueList().set(i, input));
            Assertions.assertEquals((Object)input, (Object)lom.getValue(i));
            Assertions.assertEquals((Object)input, lom.valueList().get(i));
        }
    }

    public class TestKeyListView
    extends AbstractListTest<K> {
        @Override
        public K[] getFullElements() {
            return ListOrderedMapTest.this.getSampleKeys();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isNullSupported() {
            return ListOrderedMapTest.this.isAllowNullKey();
        }

        @Override
        public boolean isRemoveSupported() {
            return false;
        }

        @Override
        public boolean isSetSupported() {
            return false;
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public List<K> makeFullCollection() {
            return ListOrderedMapTest.this.makeFullMap().keyList();
        }

        @Override
        public List<K> makeObject() {
            return ListOrderedMapTest.this.makeObject().keyList();
        }
    }

    public class TestValueListView
    extends AbstractListTest<V> {
        @Override
        public V[] getFullElements() {
            return ListOrderedMapTest.this.getSampleValues();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isNullSupported() {
            return ListOrderedMapTest.this.isAllowNullKey();
        }

        @Override
        public boolean isRemoveSupported() {
            return true;
        }

        @Override
        public boolean isSetSupported() {
            return true;
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public List<V> makeFullCollection() {
            return ListOrderedMapTest.this.makeFullMap().valueList();
        }

        @Override
        public List<V> makeObject() {
            return ListOrderedMapTest.this.makeObject().valueList();
        }
    }
}

