/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.keyvalue;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.keyvalue.AbstractMapEntryTest;
import org.apache.commons.collections4.keyvalue.TiedMapEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TiedMapEntryTest<K, V>
extends AbstractMapEntryTest<K, V> {
    @Override
    public Map.Entry<K, V> makeMapEntry(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, value);
        return new TiedMapEntry(map, key);
    }

    @Override
    @Test
    public void testConstructors() {
    }

    @Test
    public void testSetValue() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "a");
        map.put("B", "b");
        map.put("C", "c");
        TiedMapEntry entry = new TiedMapEntry(map, (Object)"A");
        Assertions.assertSame((Object)"A", entry.getKey());
        Assertions.assertSame((Object)"a", entry.getValue());
        Assertions.assertSame((Object)"a", (Object)entry.setValue("x"));
        Assertions.assertSame((Object)"A", entry.getKey());
        Assertions.assertSame((Object)"x", entry.getValue());
        entry = new TiedMapEntry(map, (Object)"B");
        Assertions.assertSame((Object)"B", entry.getKey());
        Assertions.assertSame((Object)"b", entry.getValue());
        Assertions.assertSame((Object)"b", (Object)entry.setValue("y"));
        Assertions.assertSame((Object)"B", entry.getKey());
        Assertions.assertSame((Object)"y", entry.getValue());
        entry = new TiedMapEntry(map, (Object)"C");
        Assertions.assertSame((Object)"C", entry.getKey());
        Assertions.assertSame((Object)"c", entry.getValue());
        Assertions.assertSame((Object)"c", (Object)entry.setValue("z"));
        Assertions.assertSame((Object)"C", entry.getKey());
        Assertions.assertSame((Object)"z", entry.getValue());
    }
}

