/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.FactoryUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.map.AbstractSortedMapTest;
import org.apache.commons.collections4.map.LazySortedMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class LazySortedMapTest<K, V>
extends AbstractSortedMapTest<K, V> {
    private static final Factory<Integer> oneFactory = FactoryUtils.constantFactory((Object)1);
    protected final Comparator<String> reverseStringComparator = new ReverseStringComparator();

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public boolean isAllowNullKey() {
        return false;
    }

    @Override
    protected boolean isLazyMapTest() {
        return true;
    }

    @Override
    public SortedMap<K, V> makeObject() {
        return LazySortedMap.lazySortedMap(new TreeMap(), (Factory)FactoryUtils.nullFactory());
    }

    @Override
    @Test
    public void testMapGet() {
        LazySortedMap map = LazySortedMap.lazySortedMap(new TreeMap(), oneFactory);
        Assertions.assertEquals((int)0, (int)map.size());
        Number i1 = (Number)map.get(5);
        Assertions.assertEquals((Object)1, (Object)i1);
        Assertions.assertEquals((int)1, (int)map.size());
        map = LazySortedMap.lazySortedMap(new TreeMap(), (Factory)FactoryUtils.nullFactory());
        Number o = (Number)map.get(5);
        Assertions.assertNull((Object)o);
        Assertions.assertEquals((int)1, (int)map.size());
    }

    @Test
    public void testReverseSortOrder() {
        LazySortedMap map = LazySortedMap.lazySortedMap(new ConcurrentSkipListMap(this.reverseStringComparator), oneFactory);
        map.put("A", 5);
        map.get("B");
        map.put("C", 8);
        Assertions.assertEquals((Object)"A", map.lastKey(), (String)"Last key should be A");
        Assertions.assertEquals((Object)"C", map.firstKey(), (String)"First key should be C");
        Assertions.assertEquals((Object)"B", (Object)map.tailMap("B").firstKey(), (String)"First key in tail map should be B");
        Assertions.assertEquals((Object)"B", (Object)map.headMap("A").lastKey(), (String)"Last key in head map should be B");
        Assertions.assertEquals((Object)"B", (Object)map.subMap("C", "A").lastKey(), (String)"Last key in submap should be B");
        Comparator c = map.comparator();
        Assertions.assertSame(c, this.reverseStringComparator, (String)"natural order, so comparator should be null");
    }

    @Test
    public void testSortOrder() {
        LazySortedMap map = LazySortedMap.lazySortedMap(new TreeMap(), oneFactory);
        map.put("A", 5);
        map.get("B");
        map.put("C", 8);
        Assertions.assertEquals((Object)"A", map.firstKey(), (String)"First key should be A");
        Assertions.assertEquals((Object)"C", map.lastKey(), (String)"Last key should be C");
        Assertions.assertEquals((Object)"B", (Object)map.tailMap("B").firstKey(), (String)"First key in tail map should be B");
        Assertions.assertEquals((Object)"B", (Object)map.headMap("C").lastKey(), (String)"Last key in head map should be B");
        Assertions.assertEquals((Object)"B", (Object)map.subMap("A", "C").lastKey(), (String)"Last key in submap should be B");
        Comparator c = map.comparator();
        Assertions.assertNull(c, (String)"natural order, so comparator should be null");
    }

    @Test
    public void testTransformerDecorate() {
        Transformer transformer = TransformerUtils.asTransformer(oneFactory);
        LazySortedMap map = LazySortedMap.lazySortedMap(new TreeMap(), (Transformer)transformer);
        Assertions.assertInstanceOf(LazySortedMap.class, (Object)map);
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> LazySortedMap.lazySortedMap(new TreeMap(), (Transformer)null), (String)"Expecting NullPointerException for null transformer"), () -> Assertions.assertThrows(NullPointerException.class, () -> LazySortedMap.lazySortedMap((SortedMap)null, (Transformer)transformer), (String)"Expecting NullPointerException for null map")});
    }

    private static final class ReverseStringComparator
    implements Comparator<String> {
        private ReverseStringComparator() {
        }

        @Override
        public int compare(String arg0, String arg1) {
            return arg1.compareTo(arg0);
        }
    }
}

