/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.iterators.AbstractListIteratorTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractListTest<E>
extends AbstractCollectionTest<E> {
    private void backwardTest(ListIterator<E> iter, int i) {
        Collection list = this.getCollection();
        while (i > 0) {
            Assertions.assertTrue((boolean)iter.hasPrevious(), (String)("Iterator should have previous, i:" + i));
            Assertions.assertEquals((int)i, (int)iter.nextIndex(), (String)("Iterator.nextIndex should work, i:" + i));
            Assertions.assertEquals((int)(i - 1), (int)iter.previousIndex(), (String)("Iterator.previousIndex should work, i:" + i));
            E o = iter.previous();
            Assertions.assertEquals(list.get(i - 1), o, (String)"Iterator returned correct element");
            --i;
        }
        Assertions.assertFalse((boolean)iter.hasPrevious(), (String)"Iterator shouldn't have previous");
        int nextIndex = iter.nextIndex();
        Assertions.assertEquals((int)0, (int)nextIndex, (String)"nextIndex should be 0");
        int prevIndex = iter.previousIndex();
        Assertions.assertEquals((int)-1, (int)prevIndex, (String)"previousIndex should be -1");
        Assertions.assertThrows(NoSuchElementException.class, () -> iter.previous(), (String)"Exhausted iterator should raise NoSuchElement");
    }

    public BulkTest bulkTestListIterator() {
        return new TestListIterator();
    }

    public BulkTest bulkTestSubList() {
        if (this.getFullElements().length - 6 < 10) {
            return null;
        }
        return new BulkTestSubList(this);
    }

    protected void failFastAll(List<E> list) {
        Method[] methods;
        for (Method method : methods = List.class.getMethods()) {
            this.failFastMethod(list, method);
        }
    }

    protected void failFastMethod(List<E> list, Method m) {
        if (m.getName().equals("equals")) {
            return;
        }
        Object element = this.getOtherElements()[0];
        Set c = Collections.singleton(element);
        Class<?>[] types = m.getParameterTypes();
        Object[] params = new Object[types.length];
        for (int i = 0; i < params.length; ++i) {
            if (types[i] == Integer.TYPE) {
                params[i] = 0;
                continue;
            }
            if (types[i] == Collection.class) {
                params[i] = c;
                continue;
            }
            if (types[i] == Object.class) {
                params[i] = element;
                continue;
            }
            if (types[i] != Object[].class) continue;
            params[i] = new Object[0];
        }
        InvocationTargetException thrown = (InvocationTargetException)Assertions.assertThrows(InvocationTargetException.class, () -> m.invoke((Object)list, params), (String)(m.getName() + " should raise ConcurrentModification"));
        Assertions.assertTrue((boolean)(thrown.getTargetException() instanceof ConcurrentModificationException), (String)(m.getName() + " raised unexpected " + thrown.getTargetException()));
    }

    private void forwardTest(ListIterator<E> iter, int i) {
        Collection list = this.getCollection();
        int max = this.getFullElements().length;
        while (i < max) {
            Assertions.assertTrue((boolean)iter.hasNext(), (String)"Iterator should have next");
            Assertions.assertEquals((int)i, (int)iter.nextIndex(), (String)"Iterator.nextIndex should work");
            Assertions.assertEquals((int)(i - 1), (int)iter.previousIndex(), (String)"Iterator.previousIndex should work");
            E o = iter.next();
            Assertions.assertEquals(list.get(i), o, (String)"Iterator returned correct element");
            ++i;
        }
        Assertions.assertFalse((boolean)iter.hasNext(), (String)"Iterator shouldn't have next");
        Assertions.assertEquals((int)max, (int)iter.nextIndex(), (String)"nextIndex should be size");
        Assertions.assertEquals((int)(max - 1), (int)iter.previousIndex(), (String)"previousIndex should be size - 1");
        Assertions.assertThrows(NoSuchElementException.class, () -> iter.next(), (String)"Exhausted iterator should raise NoSuchElement");
    }

    @Override
    public List<E> getCollection() {
        return (List)super.getCollection();
    }

    @Override
    public List<E> getConfirmed() {
        return (List)super.getConfirmed();
    }

    @Override
    public boolean isEqualsCheckable() {
        return true;
    }

    public boolean isSetSupported() {
        return true;
    }

    @Override
    public Collection<E> makeConfirmedCollection() {
        return new ArrayList();
    }

    @Override
    public Collection<E> makeConfirmedFullCollection() {
        return new ArrayList(Arrays.asList(this.getFullElements()));
    }

    @Override
    public List<E> makeFullCollection() {
        Collection list = this.makeObject();
        list.addAll(Arrays.asList(this.getFullElements()));
        return list;
    }

    @Override
    public abstract List<E> makeObject();

    @Test
    public void testEmptyListCompatibility() throws IOException, ClassNotFoundException {
        Collection list = this.makeObject();
        if (list instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            List list2 = (List)this.readExternalFormFromDisk(this.getCanonicalEmptyCollectionName(list));
            Assertions.assertEquals((int)0, (int)list2.size(), (String)"List is empty");
            Assertions.assertEquals((Object)list, (Object)list2);
        }
    }

    @Test
    public void testEmptyListSerialization() throws IOException, ClassNotFoundException {
        Collection list = this.makeObject();
        if (!(list instanceof Serializable) || !this.isTestSerialization()) {
            return;
        }
        byte[] object = this.writeExternalFormToBytes((Serializable)((Object)list));
        List list2 = (List)this.readExternalFormFromBytes(object);
        Assertions.assertEquals((int)0, (int)list.size(), (String)"Both lists are empty");
        Assertions.assertEquals((int)0, (int)list2.size(), (String)"Both lists are empty");
    }

    @Test
    public void testFullListCompatibility() throws IOException, ClassNotFoundException {
        Collection list = this.makeFullCollection();
        if (list instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            List list2 = (List)this.readExternalFormFromDisk(this.getCanonicalFullCollectionName(list));
            if (list2.size() == 4) {
                return;
            }
            Assertions.assertEquals((int)list.size(), (int)list2.size(), (String)"List is the right size");
            Assertions.assertEquals((Object)list, (Object)list2);
        }
    }

    @Test
    public void testFullListSerialization() throws IOException, ClassNotFoundException {
        Collection list = this.makeFullCollection();
        int size = this.getFullElements().length;
        if (!(list instanceof Serializable) || !this.isTestSerialization()) {
            return;
        }
        byte[] object = this.writeExternalFormToBytes((Serializable)((Object)list));
        List list2 = (List)this.readExternalFormFromBytes(object);
        Assertions.assertEquals((int)size, (int)list.size(), (String)"Both lists are same size");
        Assertions.assertEquals((int)size, (int)list2.size(), (String)"Both lists are same size");
    }

    @Test
    public void testListAddByIndex() {
        if (!this.isAddSupported()) {
            return;
        }
        Object element = this.getOtherElements()[0];
        int max = this.getFullElements().length;
        for (int i = 0; i <= max; ++i) {
            this.resetFull();
            this.getCollection().add(i, element);
            this.getConfirmed().add(i, element);
            this.verify();
        }
    }

    @Test
    public void testListAddByIndexBoundsChecking() {
        if (!this.isAddSupported()) {
            return;
        }
        Object element = this.getOtherElements()[0];
        Collection finalList0 = this.makeObject();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListAddByIndexBoundsChecking$3((List)finalList0, element), (String)"List.add should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        Collection finalList1 = this.makeObject();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListAddByIndexBoundsChecking$4((List)finalList1, element), (String)"List.add should throw IndexOutOfBoundsException [-1]");
        Collection finalList2 = this.makeObject();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListAddByIndexBoundsChecking$5((List)finalList2, element), (String)"List.add should throw IndexOutOfBoundsException [1]");
        Collection finalList3 = this.makeObject();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListAddByIndexBoundsChecking$6((List)finalList3, element), (String)"List.add should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
    }

    @Test
    public void testListAddByIndexBoundsChecking2() {
        if (!this.isAddSupported()) {
            return;
        }
        Object element = this.getOtherElements()[0];
        Collection finalList0 = this.makeFullCollection();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListAddByIndexBoundsChecking2$7((List)finalList0, element), (String)"List.add should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        Collection finalList1 = this.makeFullCollection();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListAddByIndexBoundsChecking2$8((List)finalList1, element), (String)"List.add should throw IndexOutOfBoundsException [-1]");
        Collection finalList2 = this.makeFullCollection();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListAddByIndexBoundsChecking2$9((List)finalList2, element), (String)"List.add should throw IndexOutOfBoundsException [size + 1]");
        Collection finalList3 = this.makeFullCollection();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListAddByIndexBoundsChecking2$10((List)finalList3, element), (String)"List.add should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
    }

    @Test
    public void testListEquals() {
        this.resetEmpty();
        Collection list = this.getCollection();
        Assertions.assertTrue((boolean)list.equals(this.getConfirmed()), (String)"Empty lists should be equal");
        this.verify();
        Assertions.assertTrue((boolean)list.equals(list), (String)"Empty list should equal self");
        this.verify();
        Collection list2 = Arrays.asList(this.getFullElements());
        Assertions.assertFalse((boolean)list.equals(list2), (String)"Empty list shouldn't equal full");
        this.verify();
        list2 = Arrays.asList(this.getOtherElements());
        Assertions.assertFalse((boolean)list.equals(list2), (String)"Empty list shouldn't equal other");
        this.verify();
        this.resetFull();
        list = this.getCollection();
        Assertions.assertTrue((boolean)list.equals(this.getConfirmed()), (String)"Full lists should be equal");
        this.verify();
        Assertions.assertTrue((boolean)list.equals(list), (String)"Full list should equal self");
        this.verify();
        list2 = this.makeObject();
        Assertions.assertFalse((boolean)list.equals(list2), (String)"Full list shouldn't equal empty");
        this.verify();
        list2 = Arrays.asList(this.getOtherElements());
        Assertions.assertFalse((boolean)list.equals(list2), (String)"Full list shouldn't equal other");
        this.verify();
        list2 = Arrays.asList(this.getFullElements());
        if (list2.size() < 2 && this.isAddSupported()) {
            list.addAll(Arrays.asList(this.getOtherElements()));
            this.getConfirmed().addAll(Arrays.asList(this.getOtherElements()));
            list2 = new ArrayList(list2);
            list2.addAll(Arrays.asList(this.getOtherElements()));
        }
        if (list2.size() > 1) {
            Collections.reverse(list2);
            Assertions.assertFalse((boolean)list.equals(list2), (String)"Full list shouldn't equal full list with same elements but different order");
            this.verify();
        }
        this.resetFull();
        list = this.getCollection();
        Assertions.assertFalse((boolean)list.isEmpty(), (String)"List shouldn't equal String");
        this.verify();
        final List listForC = Arrays.asList(this.getFullElements());
        AbstractCollection c = new AbstractCollection<E>(){

            @Override
            public Iterator<E> iterator() {
                return listForC.iterator();
            }

            @Override
            public int size() {
                return listForC.size();
            }
        };
        Assertions.assertFalse((boolean)list.equals(c), (String)"List shouldn't equal nonlist with same elements in same order");
        this.verify();
    }

    @Test
    public void testListGetByIndex() {
        this.resetFull();
        Collection list = this.getCollection();
        E[] elements = this.getFullElements();
        for (int i = 0; i < elements.length; ++i) {
            Assertions.assertEquals(elements[i], list.get(i), (String)"List should contain correct elements");
            this.verify();
        }
    }

    @Test
    public void testListGetByIndexBoundsChecking() {
        Collection list = this.makeObject();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListGetByIndexBoundsChecking$11((List)list), (String)"List.get should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListGetByIndexBoundsChecking$12((List)list), (String)"List.get should throw IndexOutOfBoundsException [-1]");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListGetByIndexBoundsChecking$13((List)list), (String)"List.get should throw IndexOutOfBoundsException [0]");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListGetByIndexBoundsChecking$14((List)list), (String)"List.get should throw IndexOutOfBoundsException [1]");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListGetByIndexBoundsChecking$15((List)list), (String)"List.get should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
    }

    @Test
    public void testListGetByIndexBoundsChecking2() {
        Collection list = this.makeFullCollection();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListGetByIndexBoundsChecking2$16((List)list), (String)"List.get should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListGetByIndexBoundsChecking2$17((List)list), (String)"List.get should throw IndexOutOfBoundsException [-1]");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.lambda$testListGetByIndexBoundsChecking2$18((List)list), (String)"List.get should throw IndexOutOfBoundsException [size]");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListGetByIndexBoundsChecking2$19((List)list), (String)"List.get should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
    }

    @Test
    public void testListHashCode() {
        this.resetEmpty();
        int hash1 = this.getCollection().hashCode();
        int hash2 = this.getConfirmed().hashCode();
        Assertions.assertEquals((int)hash1, (int)hash2, (String)"Empty lists should have equal hashCodes");
        this.verify();
        this.resetFull();
        hash1 = this.getCollection().hashCode();
        hash2 = this.getConfirmed().hashCode();
        Assertions.assertEquals((int)hash1, (int)hash2, (String)"Full lists should have equal hashCodes");
        this.verify();
    }

    @Test
    public void testListIndexOf() {
        E[] other;
        this.resetFull();
        Collection list1 = this.getCollection();
        Collection list2 = this.getConfirmed();
        for (Object element : list2) {
            Assertions.assertEquals((int)list1.indexOf(element), (int)list2.indexOf(element), (String)"indexOf should return correct result");
            this.verify();
        }
        for (Object element : other = this.getOtherElements()) {
            Assertions.assertEquals((int)-1, (int)list1.indexOf(element), (String)"indexOf should return -1 for nonexistent element");
            this.verify();
        }
    }

    @Test
    public void testListIteratorAdd() {
        if (!this.isAddSupported()) {
            return;
        }
        this.resetEmpty();
        Collection list1 = this.getCollection();
        Collection list2 = this.getConfirmed();
        E[] elements = this.getFullElements();
        ListIterator iter1 = list1.listIterator();
        ListIterator iter2 = list2.listIterator();
        for (Object element : elements) {
            iter1.add(element);
            iter2.add(element);
            this.verify();
        }
        this.resetFull();
        iter1 = this.getCollection().listIterator();
        iter2 = this.getConfirmed().listIterator();
        for (Object element : elements) {
            iter1.next();
            iter2.next();
            iter1.add(element);
            iter2.add(element);
            this.verify();
        }
    }

    @Test
    public void testListIteratorSet() {
        if (!this.isSetSupported()) {
            return;
        }
        E[] elements = this.getFullElements();
        this.resetFull();
        ListIterator iter1 = this.getCollection().listIterator();
        ListIterator iter2 = this.getConfirmed().listIterator();
        for (Object element : elements) {
            iter1.next();
            iter2.next();
            iter1.set(element);
            iter2.set(element);
            this.verify();
        }
    }

    @Test
    public void testListLastIndexOf() {
        E[] other;
        this.resetFull();
        Collection list1 = this.getCollection();
        Collection list2 = this.getConfirmed();
        for (Object element : list2) {
            Assertions.assertEquals((int)list1.lastIndexOf(element), (int)list2.lastIndexOf(element), (String)"lastIndexOf should return correct result");
            this.verify();
        }
        for (Object element : other = this.getOtherElements()) {
            Assertions.assertEquals((int)-1, (int)list1.lastIndexOf(element), (String)"lastIndexOf should return -1 for nonexistent element");
            this.verify();
        }
    }

    @Test
    public void testListListIterator() {
        this.resetFull();
        this.forwardTest(this.getCollection().listIterator(), 0);
        this.backwardTest(this.getCollection().listIterator(), 0);
    }

    @Test
    public void testListListIteratorByIndex() {
        int i;
        this.resetFull();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.getCollection().listIterator(-1));
        this.resetFull();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.getCollection().listIterator(this.getCollection().size() + 1));
        this.resetFull();
        for (i = 0; i <= this.getConfirmed().size(); ++i) {
            this.forwardTest(this.getCollection().listIterator(i), i);
            this.backwardTest(this.getCollection().listIterator(i), i);
        }
        this.resetFull();
        for (i = 0; i <= this.getConfirmed().size(); ++i) {
            this.backwardTest(this.getCollection().listIterator(i), i);
        }
    }

    @Test
    public void testListListIteratorNextRemoveNext() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        if (this.getCollection().size() < 4) {
            return;
        }
        ListIterator it = this.getCollection().listIterator();
        Object zero = it.next();
        Object one = it.next();
        Object two = it.next();
        Assertions.assertEquals(zero, this.getCollection().get(0));
        Assertions.assertEquals(one, this.getCollection().get(1));
        Assertions.assertEquals(two, this.getCollection().get(2));
        Object three = this.getCollection().get(3);
        it.remove();
        Assertions.assertEquals(zero, this.getCollection().get(0));
        Assertions.assertEquals(one, this.getCollection().get(1));
        Object three2 = it.next();
        Assertions.assertEquals(three, three2);
        Assertions.assertEquals((Object)(this.getCollection().size() > 3 ? 1 : 0), (Object)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
    }

    @Test
    public void testListListIteratorNextRemovePrevious() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        if (this.getCollection().size() < 4) {
            return;
        }
        ListIterator it = this.getCollection().listIterator();
        Object zero = it.next();
        Object one = it.next();
        Object two = it.next();
        Assertions.assertEquals(zero, this.getCollection().get(0));
        Assertions.assertEquals(one, this.getCollection().get(1));
        Assertions.assertEquals(two, this.getCollection().get(2));
        it.remove();
        Assertions.assertEquals(zero, this.getCollection().get(0));
        Assertions.assertEquals(one, this.getCollection().get(1));
        Object one2 = it.previous();
        Assertions.assertEquals(one, one2);
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
    }

    @Test
    public void testListListIteratorPreviousRemoveNext() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        if (this.getCollection().size() < 4) {
            return;
        }
        ListIterator it = this.getCollection().listIterator();
        Object zero = it.next();
        Object one = it.next();
        Object two = it.next();
        Object two2 = it.previous();
        Object one2 = it.previous();
        Assertions.assertEquals(one, one2);
        Assertions.assertEquals(two, two2);
        Assertions.assertEquals(zero, this.getCollection().get(0));
        Assertions.assertEquals(one, this.getCollection().get(1));
        Assertions.assertEquals(two, this.getCollection().get(2));
        it.remove();
        Assertions.assertEquals(zero, this.getCollection().get(0));
        Assertions.assertEquals(two, this.getCollection().get(1));
        Object two3 = it.next();
        Assertions.assertEquals(two, two3);
        Assertions.assertEquals((Object)(this.getCollection().size() > 2 ? 1 : 0), (Object)it.hasNext());
        Assertions.assertTrue((boolean)it.hasPrevious());
    }

    @Test
    public void testListListIteratorPreviousRemovePrevious() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        if (this.getCollection().size() < 4) {
            return;
        }
        ListIterator it = this.getCollection().listIterator();
        Object zero = it.next();
        Object one = it.next();
        Object two = it.next();
        Object two2 = it.previous();
        Object one2 = it.previous();
        Assertions.assertEquals(one, one2);
        Assertions.assertEquals(two, two2);
        Assertions.assertEquals(zero, this.getCollection().get(0));
        Assertions.assertEquals(one, this.getCollection().get(1));
        Assertions.assertEquals(two, this.getCollection().get(2));
        it.remove();
        Assertions.assertEquals(zero, this.getCollection().get(0));
        Assertions.assertEquals(two, this.getCollection().get(1));
        Object zero3 = it.previous();
        Assertions.assertEquals(zero, zero3);
        Assertions.assertFalse((boolean)it.hasPrevious());
        Assertions.assertEquals((Object)(this.getCollection().size() > 2 ? 1 : 0), (Object)it.hasNext());
    }

    @Test
    public void testListRemoveByIndex() {
        if (!this.isRemoveSupported()) {
            return;
        }
        int max = this.getFullElements().length;
        for (int i = 0; i < max; ++i) {
            this.resetFull();
            Object o1 = this.getCollection().remove(i);
            Object o2 = this.getConfirmed().remove(i);
            Assertions.assertEquals(o1, o2, (String)"remove should return correct element");
            this.verify();
        }
    }

    @Test
    public void testListRemoveByIndexBoundsChecking() {
        if (!this.isRemoveSupported()) {
            return;
        }
        Collection list = this.makeObject();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListRemoveByIndexBoundsChecking$22((List)list), (String)"List.remove should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListRemoveByIndexBoundsChecking$23((List)list), (String)"List.remove should throw IndexOutOfBoundsException [-1]");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListRemoveByIndexBoundsChecking$24((List)list), (String)"List.remove should throw IndexOutOfBoundsException [0]");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListRemoveByIndexBoundsChecking$25((List)list), (String)"List.remove should throw IndexOutOfBoundsException [1]");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListRemoveByIndexBoundsChecking$26((List)list), (String)"List.remove should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
    }

    @Test
    public void testListRemoveByIndexBoundsChecking2() {
        if (!this.isRemoveSupported()) {
            return;
        }
        Collection list = this.makeFullCollection();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListRemoveByIndexBoundsChecking2$27((List)list), (String)"List.remove should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListRemoveByIndexBoundsChecking2$28((List)list), (String)"List.remove should throw IndexOutOfBoundsException [-1]");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.lambda$testListRemoveByIndexBoundsChecking2$29((List)list), (String)"List.remove should throw IndexOutOfBoundsException [size]");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListRemoveByIndexBoundsChecking2$30((List)list), (String)"List.remove should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
    }

    @Test
    public void testListSetByIndex() {
        if (!this.isSetSupported()) {
            return;
        }
        this.resetFull();
        E[] elements = this.getFullElements();
        E[] other = this.getOtherElements();
        for (int i = 0; i < elements.length; ++i) {
            Object n = other[i % other.length];
            Object v = this.getCollection().set(i, n);
            Assertions.assertEquals(elements[i], v, (String)"Set should return correct element");
            this.getConfirmed().set(i, n);
            this.verify();
        }
    }

    @Test
    public void testListSetByIndexBoundsChecking() {
        if (!this.isSetSupported()) {
            return;
        }
        Collection list = this.makeObject();
        Object element = this.getOtherElements()[0];
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListSetByIndexBoundsChecking$31((List)list, element), (String)"List.set should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListSetByIndexBoundsChecking$32((List)list, element), (String)"List.set should throw IndexOutOfBoundsException [-1]");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListSetByIndexBoundsChecking$33((List)list, element), (String)"List.set should throw IndexOutOfBoundsException [0]");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListSetByIndexBoundsChecking$34((List)list, element), (String)"List.set should throw IndexOutOfBoundsException [1]");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListSetByIndexBoundsChecking$35((List)list, element), (String)"List.set should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
    }

    @Test
    public void testListSetByIndexBoundsChecking2() {
        if (!this.isSetSupported()) {
            return;
        }
        Collection list = this.makeFullCollection();
        Object element = this.getOtherElements()[0];
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListSetByIndexBoundsChecking2$36((List)list, element), (String)"List.set should throw IndexOutOfBoundsException [Integer.MIN_VALUE]");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListSetByIndexBoundsChecking2$37((List)list, element), (String)"List.set should throw IndexOutOfBoundsException [-1]");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.lambda$testListSetByIndexBoundsChecking2$38((List)list, element), (String)"List.set should throw IndexOutOfBoundsException [size]");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> AbstractListTest.lambda$testListSetByIndexBoundsChecking2$39((List)list, element), (String)"List.set should throw IndexOutOfBoundsException [Integer.MAX_VALUE]");
    }

    @Test
    public void testListSubListFailFastOnAdd() {
        if (!this.isFailFastSupported()) {
            return;
        }
        if (!this.isAddSupported()) {
            return;
        }
        this.resetFull();
        int size = this.getCollection().size();
        List sub = this.getCollection().subList(1, size);
        this.getCollection().add(this.getOtherElements()[0]);
        this.failFastAll(sub);
        this.resetFull();
        sub = this.getCollection().subList(1, size);
        this.getCollection().add(0, this.getOtherElements()[0]);
        this.failFastAll(sub);
        this.resetFull();
        sub = this.getCollection().subList(1, size);
        this.getCollection().addAll(Arrays.asList(this.getOtherElements()));
        this.failFastAll(sub);
        this.resetFull();
        sub = this.getCollection().subList(1, size);
        this.getCollection().addAll(0, Arrays.asList(this.getOtherElements()));
        this.failFastAll(sub);
    }

    @Test
    public void testListSubListFailFastOnRemove() {
        if (!this.isFailFastSupported()) {
            return;
        }
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        int size = this.getCollection().size();
        List sub = this.getCollection().subList(1, size);
        this.getCollection().remove(0);
        this.failFastAll(sub);
        this.resetFull();
        sub = this.getCollection().subList(1, size);
        this.getCollection().remove(this.getFullElements()[2]);
        this.failFastAll(sub);
        this.resetFull();
        sub = this.getCollection().subList(1, size);
        this.getCollection().removeAll(Arrays.asList(this.getFullElements()));
        this.failFastAll(sub);
        this.resetFull();
        sub = this.getCollection().subList(1, size);
        this.getCollection().retainAll(Arrays.asList(this.getOtherElements()));
        this.failFastAll(sub);
        this.resetFull();
        sub = this.getCollection().subList(1, size);
        this.getCollection().clear();
        this.failFastAll(sub);
    }

    @Test
    public void testUnsupportedSet() {
        if (this.isSetSupported()) {
            return;
        }
        this.resetFull();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getCollection().set(0, this.getFullElements()[0]), (String)"Empty collection should not support set.");
        this.verify();
    }

    @Override
    public void verify() {
        super.verify();
        Collection list1 = this.getCollection();
        Collection list2 = this.getConfirmed();
        Assertions.assertEquals((Object)list1, (Object)list2, (String)"List should equal confirmed");
        Assertions.assertEquals((Object)list2, (Object)list1, (String)"Confirmed should equal list");
        Assertions.assertEquals((int)list1.hashCode(), (int)list2.hashCode(), (String)"Hash codes should be equal");
        int i = 0;
        Iterator iterator1 = list1.iterator();
        Object[] array = list1.toArray();
        for (Object o2 : list2) {
            Assertions.assertTrue((boolean)iterator1.hasNext(), (String)"List iterator should have next");
            Object o1 = iterator1.next();
            Assertions.assertEquals(o1, o2, (String)"Iterator elements should be equal");
            o2 = list1.get(i);
            Assertions.assertEquals(o1, o2, (String)"get should return correct element");
            o2 = array[i];
            Assertions.assertEquals(o1, o2, (String)"toArray should have correct element");
            ++i;
        }
    }

    private static /* synthetic */ void lambda$testListSetByIndexBoundsChecking2$39(List list, Object element) throws Throwable {
        list.set(Integer.MAX_VALUE, element);
    }

    private /* synthetic */ void lambda$testListSetByIndexBoundsChecking2$38(List list, Object element) throws Throwable {
        list.set(this.getFullElements().length, element);
    }

    private static /* synthetic */ void lambda$testListSetByIndexBoundsChecking2$37(List list, Object element) throws Throwable {
        list.set(-1, element);
    }

    private static /* synthetic */ void lambda$testListSetByIndexBoundsChecking2$36(List list, Object element) throws Throwable {
        list.set(Integer.MIN_VALUE, element);
    }

    private static /* synthetic */ void lambda$testListSetByIndexBoundsChecking$35(List list, Object element) throws Throwable {
        list.set(Integer.MAX_VALUE, element);
    }

    private static /* synthetic */ void lambda$testListSetByIndexBoundsChecking$34(List list, Object element) throws Throwable {
        list.set(1, element);
    }

    private static /* synthetic */ void lambda$testListSetByIndexBoundsChecking$33(List list, Object element) throws Throwable {
        list.set(0, element);
    }

    private static /* synthetic */ void lambda$testListSetByIndexBoundsChecking$32(List list, Object element) throws Throwable {
        list.set(-1, element);
    }

    private static /* synthetic */ void lambda$testListSetByIndexBoundsChecking$31(List list, Object element) throws Throwable {
        list.set(Integer.MIN_VALUE, element);
    }

    private static /* synthetic */ void lambda$testListRemoveByIndexBoundsChecking2$30(List list) throws Throwable {
        list.remove(Integer.MAX_VALUE);
    }

    private /* synthetic */ void lambda$testListRemoveByIndexBoundsChecking2$29(List list) throws Throwable {
        list.remove(this.getFullElements().length);
    }

    private static /* synthetic */ void lambda$testListRemoveByIndexBoundsChecking2$28(List list) throws Throwable {
        list.remove(-1);
    }

    private static /* synthetic */ void lambda$testListRemoveByIndexBoundsChecking2$27(List list) throws Throwable {
        list.remove(Integer.MIN_VALUE);
    }

    private static /* synthetic */ void lambda$testListRemoveByIndexBoundsChecking$26(List list) throws Throwable {
        list.remove(Integer.MAX_VALUE);
    }

    private static /* synthetic */ void lambda$testListRemoveByIndexBoundsChecking$25(List list) throws Throwable {
        list.remove(1);
    }

    private static /* synthetic */ void lambda$testListRemoveByIndexBoundsChecking$24(List list) throws Throwable {
        list.remove(0);
    }

    private static /* synthetic */ void lambda$testListRemoveByIndexBoundsChecking$23(List list) throws Throwable {
        list.remove(-1);
    }

    private static /* synthetic */ void lambda$testListRemoveByIndexBoundsChecking$22(List list) throws Throwable {
        list.remove(Integer.MIN_VALUE);
    }

    private static /* synthetic */ void lambda$testListGetByIndexBoundsChecking2$19(List list) throws Throwable {
        list.get(Integer.MAX_VALUE);
    }

    private /* synthetic */ void lambda$testListGetByIndexBoundsChecking2$18(List list) throws Throwable {
        list.get(this.getFullElements().length);
    }

    private static /* synthetic */ void lambda$testListGetByIndexBoundsChecking2$17(List list) throws Throwable {
        list.get(-1);
    }

    private static /* synthetic */ void lambda$testListGetByIndexBoundsChecking2$16(List list) throws Throwable {
        list.get(Integer.MIN_VALUE);
    }

    private static /* synthetic */ void lambda$testListGetByIndexBoundsChecking$15(List list) throws Throwable {
        list.get(Integer.MAX_VALUE);
    }

    private static /* synthetic */ void lambda$testListGetByIndexBoundsChecking$14(List list) throws Throwable {
        list.get(1);
    }

    private static /* synthetic */ void lambda$testListGetByIndexBoundsChecking$13(List list) throws Throwable {
        list.get(0);
    }

    private static /* synthetic */ void lambda$testListGetByIndexBoundsChecking$12(List list) throws Throwable {
        list.get(-1);
    }

    private static /* synthetic */ void lambda$testListGetByIndexBoundsChecking$11(List list) throws Throwable {
        list.get(Integer.MIN_VALUE);
    }

    private static /* synthetic */ void lambda$testListAddByIndexBoundsChecking2$10(List finalList3, Object element) throws Throwable {
        finalList3.add(Integer.MAX_VALUE, element);
    }

    private static /* synthetic */ void lambda$testListAddByIndexBoundsChecking2$9(List finalList2, Object element) throws Throwable {
        finalList2.add(finalList2.size() + 1, element);
    }

    private static /* synthetic */ void lambda$testListAddByIndexBoundsChecking2$8(List finalList1, Object element) throws Throwable {
        finalList1.add(-1, element);
    }

    private static /* synthetic */ void lambda$testListAddByIndexBoundsChecking2$7(List finalList0, Object element) throws Throwable {
        finalList0.add(Integer.MIN_VALUE, element);
    }

    private static /* synthetic */ void lambda$testListAddByIndexBoundsChecking$6(List finalList3, Object element) throws Throwable {
        finalList3.add(Integer.MAX_VALUE, element);
    }

    private static /* synthetic */ void lambda$testListAddByIndexBoundsChecking$5(List finalList2, Object element) throws Throwable {
        finalList2.add(1, element);
    }

    private static /* synthetic */ void lambda$testListAddByIndexBoundsChecking$4(List finalList1, Object element) throws Throwable {
        finalList1.add(-1, element);
    }

    private static /* synthetic */ void lambda$testListAddByIndexBoundsChecking$3(List finalList0, Object element) throws Throwable {
        finalList0.add(Integer.MIN_VALUE, element);
    }

    public class TestListIterator
    extends AbstractListIteratorTest<E> {
        @Override
        public E addSetValue() {
            return AbstractListTest.this.getOtherElements()[0];
        }

        @Override
        public ListIterator<E> makeEmptyIterator() {
            AbstractListTest.this.resetEmpty();
            return AbstractListTest.this.getCollection().listIterator();
        }

        @Override
        public ListIterator<E> makeObject() {
            AbstractListTest.this.resetFull();
            return AbstractListTest.this.getCollection().listIterator();
        }

        @Override
        public boolean supportsAdd() {
            return AbstractListTest.this.isAddSupported();
        }

        @Override
        public boolean supportsRemove() {
            return AbstractListTest.this.isRemoveSupported();
        }

        @Override
        public boolean supportsSet() {
            return AbstractListTest.this.isSetSupported();
        }
    }

    public static class BulkTestSubList<E>
    extends AbstractListTest<E> {
        private final AbstractListTest<E> outer;

        public BulkTestSubList(AbstractListTest<E> outer) {
            this.outer = outer;
        }

        @Override
        public E[] getFullElements() {
            List l = Arrays.asList(this.outer.getFullElements());
            return l.subList(3, l.size() - 3).toArray();
        }

        @Override
        public E[] getOtherElements() {
            return this.outer.getOtherElements();
        }

        @Override
        public boolean isAddSupported() {
            return this.outer.isAddSupported();
        }

        @Override
        public boolean isRemoveSupported() {
            return this.outer.isRemoveSupported();
        }

        @Override
        public boolean isSetSupported() {
            return this.outer.isSetSupported();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public List<E> makeFullCollection() {
            int size = this.getFullElements().length;
            return this.outer.makeFullCollection().subList(3, size - 3);
        }

        @Override
        public List<E> makeObject() {
            return this.outer.makeFullCollection().subList(4, 4);
        }

        @Override
        public void resetEmpty() {
            this.outer.resetFull();
            this.setCollection(this.outer.getCollection().subList(4, 4));
            this.setConfirmed(this.outer.getConfirmed().subList(4, 4));
        }

        @Override
        public void resetFull() {
            this.outer.resetFull();
            int size = this.outer.getConfirmed().size();
            this.setCollection(this.outer.getCollection().subList(3, size - 3));
            this.setConfirmed(this.outer.getConfirmed().subList(3, size - 3));
        }

        @Override
        public void verify() {
            super.verify();
            this.outer.verify();
        }
    }
}

