/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.LongPredicate;
import org.apache.commons.collections4.bloomfilter.BitMaps;
import org.apache.commons.collections4.bloomfilter.CountingLongPredicate;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.apache.commons.collections4.bloomfilter.LongBiPredicate;

@FunctionalInterface
public interface BitMapExtractor {
    public static BitMapExtractor fromBitMapArray(final long ... bitMaps) {
        return new BitMapExtractor(){

            @Override
            public long[] asBitMapArray() {
                return Arrays.copyOf(bitMaps, bitMaps.length);
            }

            @Override
            public boolean processBitMaps(LongPredicate predicate) {
                for (long word : bitMaps) {
                    if (predicate.test(word)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean processBitMapPairs(BitMapExtractor other, LongBiPredicate func) {
                CountingLongPredicate p = new CountingLongPredicate(bitMaps, func);
                return other.processBitMaps(p) && p.processRemaining();
            }
        };
    }

    public static BitMapExtractor fromIndexExtractor(IndexExtractor extractor, int numberOfBits) {
        Objects.requireNonNull(extractor, "extractor");
        long[] result = new long[BitMaps.numberOfBitMaps(numberOfBits)];
        extractor.processIndices(i -> {
            BitMaps.set(result, i);
            return true;
        });
        return BitMapExtractor.fromBitMapArray(result);
    }

    default public long[] asBitMapArray() {
        final class Bits {
            private long[] data = new long[16];
            private int size;

            Bits() {
            }

            boolean add(long bits) {
                if (this.size == this.data.length) {
                    this.data = Arrays.copyOf(this.data, this.size * 2);
                }
                this.data[this.size++] = bits;
                return true;
            }

            long[] toArray() {
                return this.size == this.data.length ? this.data : Arrays.copyOf(this.data, this.size);
            }
        }
        Bits bits = new Bits();
        this.processBitMaps(bits::add);
        return bits.toArray();
    }

    public boolean processBitMaps(LongPredicate var1);

    default public boolean processBitMapPairs(BitMapExtractor other, LongBiPredicate func) {
        CountingLongPredicate p = new CountingLongPredicate(this.asBitMapArray(), func);
        return other.processBitMaps(p) && p.processRemaining();
    }
}

