/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.set.AbstractSetTest;
import org.apache.commons.collections4.set.UnmodifiableSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnmodifiableSetTest<E>
extends AbstractSetTest<E> {
    public UnmodifiableSetTest() {
        super(UnmodifiableSetTest.class.getSimpleName());
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    protected int getIterationBehaviour() {
        return 1;
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public Set<E> makeFullCollection() {
        HashSet set = new HashSet(Arrays.asList(this.getFullElements()));
        return UnmodifiableSet.unmodifiableSet(set);
    }

    @Override
    public Set<E> makeObject() {
        return UnmodifiableSet.unmodifiableSet(new HashSet());
    }

    @Test
    public void testDecorateFactory() {
        Collection set = this.makeFullCollection();
        Assertions.assertSame((Object)set, (Object)UnmodifiableSet.unmodifiableSet((Set)set));
        Assertions.assertThrows(NullPointerException.class, () -> UnmodifiableSet.unmodifiableSet(null));
    }

    @Test
    public void testUnmodifiable() {
        Assertions.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        Assertions.assertTrue((boolean)(this.makeFullCollection() instanceof Unmodifiable));
    }
}

